/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.alarms;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.AlarmProviderOld;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.alarms.AlarmDisplay;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;

public abstract class SimpleAlarm
extends ConsolePanel
implements AlarmProviderOld,
IPeriodicUpdates {
    private static final long serialVersionUID = 1L;
    @NeptusProperty(name="Period between updates", description="Ammount of time (in milliseconds) to wait between updates")
    public long updatePeriod = 1000L;
    @NeptusProperty(name="Beep on error", description="Produce an audible effect in the case of an error")
    public boolean beepOnError = false;
    protected AlarmDisplay display = new AlarmDisplay();
    private int state = -2;
    private String message = "";

    public AlarmDisplay getDisplay() {
        return this.display;
    }

    public SimpleAlarm(ConsoleLayout console) {
        super(console);
        this.setLayout(new BorderLayout());
        this.display.setText(this.getTextToDisplay());
        this.add((Component)((Object)this.display), "Center");
        this.setPreferredSize(new Dimension(118, 29));
        this.setMinimumSize(new Dimension(10, 10));
        this.setSize(118, 29);
    }

    protected String getTextToDisplay() {
        return this.getName();
    }

    public int sourceState() {
        return this.getAlarmState();
    }

    public long millisBetweenUpdates() {
        return this.updatePeriod;
    }

    public boolean update() {
        String prevMessage = this.message;
        int prevState = this.state;
        this.state = this.getAlarmState();
        this.message = this.getAlarmMessage();
        if (this.state != prevState || !this.message.equals(prevMessage)) {
            this.getMainpanel().getAlarmlistener().updateAlarmsListeners((AlarmProviderOld)this);
            this.display.setState(this.state);
            this.display.setToolTipText(this.message);
            if (this.state == 4 && this.beepOnError) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        return true;
    }
}

