/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.gauges;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.concurrent.LinkedBlockingDeque;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.colormap.InterpolationColorMap;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.AlarmProviderOld;
import pt.lsts.neptus.console.plugins.ConsoleScript;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.gauges.GaugeDisplay;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.util.ConsoleParse;

@PluginDescription(author="ZP", name="MultiVariable Gauge", description="This panel displays various variables simultaneously", icon="pt/lsts/neptus/plugins/gauges/gauges.png")
public class CpuBattDiskNetGauge
extends ConsolePanel
implements AlarmProviderOld,
IPeriodicUpdates,
ConfigurationListener,
NeptusMessageListener {
    private final LinkedBlockingDeque<Long> beats = new LinkedBlockingDeque();
    private final GaugeDisplay battDisplay = new GaugeDisplay();
    private final GaugeDisplay cpuDisplay = new GaugeDisplay();
    private final GaugeDisplay netDisplay = new GaugeDisplay();
    private final GaugeDisplay diskDisplay = new GaugeDisplay();
    private final ConsoleScript battScript = new ConsoleScript();
    private final ConsoleScript battTextScript = new ConsoleScript();
    private final ConsoleScript cpuScript = new ConsoleScript();
    private final ConsoleScript cpuTextScript = new ConsoleScript();
    private final ConsoleScript diskScript = new ConsoleScript();
    private final ConsoleScript diskTextScript = new ConsoleScript();
    @NeptusProperty(name="Update interval", description="Interval between updates in milliseconds")
    public long millisBetweenUpdates = 1000L;
    protected long lastBeatTime = System.currentTimeMillis();
    @NeptusProperty(name="Battery value", category="Battery", description="Expression for calculating battery voltage. Should be a value between 0 and 1.")
    public String battExpression = "$(InternalVoltage.11.value) * 12";
    protected String message = "As usual, everything is working just fine.";
    protected int alarmLevel = 0;
    @NeptusProperty(name="Battery text", category="Battery", description="Text to display. Can use tree variables.")
    public String battText = "$(InternalVoltage.0.value) * 0.01";
    @NeptusProperty(name="CPU load value", category="CPU", description="Expression for calculating CPU load. Should be a value between 0 and 1.")
    public String cpuExpression = "$(CpuUsage.usage)/100";
    @NeptusProperty(name="CPU load text", category="CPU", description="Text to display in the CPU gauge. Can use tree variables.")
    public String cpuText = "\"CPU load: \"+$(CpuUsage.usage)+\"%\"";
    @NeptusProperty(name="Disk usage value", category="Disk", description="Expression for calculating disk usage. Should be a value between 0 and 1.")
    public String diskExpression = "$(StorageUsage.value) / 100.0";
    @NeptusProperty(name="Disk usage text", category="Disk", description="Text to display in the disk usage gauge.")
    public String diskText = "\"Free: \"+$(StorageUsage.available)+\" MB\"";
    @NeptusProperty(category="Network")
    public int heartBeatSecs = 5;
    protected Runnable updateInterface = new Runnable(){

        @Override
        public void run() {
            int before;
            boolean enabled = System.currentTimeMillis() - CpuBattDiskNetGauge.this.lastBeatTime < (long)(CpuBattDiskNetGauge.this.heartBeatSecs * 2000);
            CpuBattDiskNetGauge.this.netDisplay.setEnabled(enabled);
            long minTime = System.currentTimeMillis() - (long)(CpuBattDiskNetGauge.this.heartBeatSecs * 1000);
            while (CpuBattDiskNetGauge.this.beats.peek() != null && (Long)CpuBattDiskNetGauge.this.beats.peek() < minTime) {
                CpuBattDiskNetGauge.this.beats.poll();
            }
            float hbRatio = (float)CpuBattDiskNetGauge.this.beats.size() / (float)CpuBattDiskNetGauge.this.heartBeatSecs;
            if (!Float.isNaN(hbRatio)) {
                CpuBattDiskNetGauge.this.netDisplay.setValue(Math.min(1.0, (double)hbRatio));
                CpuBattDiskNetGauge.this.netDisplay.setToolTipText("Heartbeat reception rate");
            }
            if (hbRatio == 0.0f) {
                before = CpuBattDiskNetGauge.this.alarmLevel;
                CpuBattDiskNetGauge.this.alarmLevel = 4;
                CpuBattDiskNetGauge.this.message = "No heartbeat has been heard for more than " + CpuBattDiskNetGauge.this.heartBeatSecs + " seconds";
                if (before != CpuBattDiskNetGauge.this.alarmLevel) {
                    CpuBattDiskNetGauge.this.getMainpanel().getAlarmlistener().updateAlarmsListeners((AlarmProviderOld)CpuBattDiskNetGauge.this);
                }
            } else {
                before = CpuBattDiskNetGauge.this.alarmLevel;
                CpuBattDiskNetGauge.this.alarmLevel = 0;
                CpuBattDiskNetGauge.this.message = "As usual, everything is working just fine.";
                if (before != CpuBattDiskNetGauge.this.alarmLevel) {
                    CpuBattDiskNetGauge.this.getMainpanel().getAlarmlistener().updateAlarmsListeners((AlarmProviderOld)CpuBattDiskNetGauge.this);
                }
            }
            CpuBattDiskNetGauge.this.cpuDisplay.setEnabled(enabled);
            double val = CpuBattDiskNetGauge.this.evalToDouble(CpuBattDiskNetGauge.this.cpuScript);
            if (!Double.isNaN(val)) {
                CpuBattDiskNetGauge.this.cpuDisplay.setValue(val);
                CpuBattDiskNetGauge.this.cpuDisplay.setToolTipText(CpuBattDiskNetGauge.this.evalToString(CpuBattDiskNetGauge.this.cpuTextScript));
            }
            CpuBattDiskNetGauge.this.battDisplay.setEnabled(enabled);
            val = CpuBattDiskNetGauge.this.evalToDouble(CpuBattDiskNetGauge.this.battScript);
            if (!Double.isNaN(val)) {
                CpuBattDiskNetGauge.this.battDisplay.setValue(val);
                CpuBattDiskNetGauge.this.battDisplay.setToolTipText(CpuBattDiskNetGauge.this.evalToString(CpuBattDiskNetGauge.this.battTextScript));
            }
            CpuBattDiskNetGauge.this.diskDisplay.setEnabled(enabled);
            val = CpuBattDiskNetGauge.this.evalToDouble(CpuBattDiskNetGauge.this.diskScript);
            if (!Double.isNaN(val)) {
                CpuBattDiskNetGauge.this.diskDisplay.setValue(val);
                CpuBattDiskNetGauge.this.diskDisplay.setToolTipText(CpuBattDiskNetGauge.this.evalToString(CpuBattDiskNetGauge.this.diskTextScript));
            }
            CpuBattDiskNetGauge.this.repaint();
        }
    };

    public String validateBattExpression(String script) {
        try {
            new ConsoleScript().setScript(script);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    public String validateBattText(String script) {
        try {
            new ConsoleScript().setScript(script);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    public String validateCpuExpression(String script) {
        try {
            new ConsoleScript().setScript(script);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    public String validateCpuText(String script) {
        try {
            new ConsoleScript().setScript(script);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    public String validateDiskExpression(String script) {
        try {
            new ConsoleScript().setScript(script);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    public String validateDiskText(String script) {
        try {
            new ConsoleScript().setScript(script);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    public long millisBetweenUpdates() {
        return this.millisBetweenUpdates;
    }

    private double evalToDouble(ConsoleScript script) {
        Object o = script.evaluate(this.getState());
        if (o != null && o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        return Double.NaN;
    }

    private String evalToString(ConsoleScript script) {
        Object o = script.evaluate(this.getState());
        if (o != null) {
            return o.toString();
        }
        return "";
    }

    public boolean update() {
        if (this.isVisible()) {
            try {
                SwingUtilities.invokeLater(this.updateInterface);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void propertiesChanged() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        CpuBattDiskNetGauge.this.cpuScript.setScript(CpuBattDiskNetGauge.this.cpuExpression);
                        CpuBattDiskNetGauge.this.cpuTextScript.setScript(CpuBattDiskNetGauge.this.cpuText);
                        CpuBattDiskNetGauge.this.battScript.setScript(CpuBattDiskNetGauge.this.battExpression);
                        CpuBattDiskNetGauge.this.battTextScript.setScript(CpuBattDiskNetGauge.this.battText);
                        CpuBattDiskNetGauge.this.diskScript.setScript(CpuBattDiskNetGauge.this.diskExpression);
                        CpuBattDiskNetGauge.this.diskTextScript.setScript(CpuBattDiskNetGauge.this.diskText);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getAlarmMessage() {
        return this.message;
    }

    public int getAlarmState() {
        return this.alarmLevel;
    }

    public int sourceState() {
        return this.alarmLevel;
    }

    public CpuBattDiskNetGauge(ConsoleLayout console) {
        super(console);
        this.removeAll();
        this.setLayout((LayoutManager)new MigLayout("", "[right][grow]", "[]3[]"));
        JLabel batLbl = new JLabel("Battery");
        JLabel cpuLbl = new JLabel("CPU");
        JLabel hddLabel = new JLabel("Storage");
        JLabel hbLabel = new JLabel("HeartBeat");
        batLbl.setPreferredSize(new Dimension(50, 25));
        batLbl.setHorizontalAlignment(4);
        cpuLbl.setPreferredSize(new Dimension(50, 25));
        cpuLbl.setHorizontalAlignment(4);
        hddLabel.setPreferredSize(new Dimension(50, 25));
        hddLabel.setHorizontalAlignment(4);
        hbLabel.setPreferredSize(new Dimension(50, 25));
        hbLabel.setHorizontalAlignment(4);
        this.add(batLbl);
        this.add((Component)((Object)this.battDisplay), "wrap,grow");
        this.add(cpuLbl);
        this.cpuDisplay.setColormap(ColorMapFactory.createInvertedColorMap((InterpolationColorMap)((InterpolationColorMap)ColorMapFactory.createRedYellowGreenColorMap())));
        this.add((Component)((Object)this.cpuDisplay), "wrap,grow");
        this.add(hddLabel);
        this.diskDisplay.setColormap(ColorMapFactory.createInvertedColorMap((InterpolationColorMap)((InterpolationColorMap)ColorMapFactory.createRedYellowGreenColorMap())));
        this.add((Component)((Object)this.diskDisplay), "wrap,grow");
        this.add(hbLabel);
        this.add((Component)((Object)this.netDisplay), "wrap,grow");
        this.propertiesChanged();
    }

    public static void main(String[] args) {
        ConsoleParse.testSubPanel(CpuBattDiskNetGauge.class);
    }

    public String[] getObservedMessages() {
        return new String[]{"Heartbeat"};
    }

    public void messageArrived(IMCMessage message) {
        this.beats.add(System.currentTimeMillis());
        this.lastBeatTime = System.currentTimeMillis();
    }

    public void initSubPanel() {
    }

    public void cleanSubPanel() {
    }
}

