/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.gauges;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.GlossPainter;
import org.jdesktop.swingx.painter.Painter;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

public class GaugeDisplay
extends JXPanel
implements Painter<JXLabel> {
    private String text = "";
    private JXLabel gauge = new JXLabel(this.text);
    private ColorMap colormap = ColorMapFactory.createRedYellowGreenColorMap();
    private double value;
    protected boolean enabled = true;

    public GaugeDisplay() {
        this.setLayout(new BorderLayout());
        this.gauge.setBackgroundPainter((Painter)new CompoundPainter(new Painter[]{this, new GlossPainter()}));
        this.gauge.setHorizontalTextPosition(0);
        this.gauge.setHorizontalAlignment(0);
        this.gauge.setFont(new Font("Arial", 1, 14));
        this.gauge.setForeground(Color.black);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add((Component)this.gauge, "Center");
    }

    public void paint(Graphics2D arg0, JXLabel arg1, int arg2, int arg3) {
        Color color = this.colormap.getColor(this.value);
        double max = arg1.getWidth() - 4;
        double width = max * this.value;
        if (!this.isEnabled()) {
            color = Color.gray.darker();
            width = max;
        }
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(2.0, 2.0, width, arg1.getHeight() - 4, 4.0, 4.0);
        arg0.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        arg0.setPaint(new LinearGradientPaint(0.0f, 0.0f, this.getWidth(), this.getHeight(), new float[]{0.0f, 1.0f}, new Color[]{color, color.darker()}));
        arg0.fill(rect);
        rect = new RoundRectangle2D.Double(2.0, 2.0, arg1.getWidth() - 4, arg1.getHeight() - 4, 4.0, 4.0);
        arg0.draw(rect);
        arg0.setColor(Color.black);
        arg0.setStroke(new BasicStroke(1.5f));
        arg0.setColor(Color.black);
        arg0.draw(rect);
    }

    public void setText(String text) {
        this.text = text;
        this.gauge.setText(text);
        this.repaint();
    }

    public ColorMap getColormap() {
        return this.colormap;
    }

    public void setColormap(ColorMap colormap) {
        this.colormap = colormap;
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
        this.text = GuiUtils.getNeptusDecimalFormat((int)1).format(value * 100.0) + "%";
        this.gauge.setText(this.text);
        this.repaint();
    }

    public static void main(String[] args) {
        GuiUtils.setLookAndFeel();
        JLabel lbl = new JLabel(ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/gauges/hdd.png"));
        GaugeDisplay gd = new GaugeDisplay();
        gd.setText("10%");
        gd.setValue(0.1);
        gd.setEnabled(false);
        gd.setToolTipText("my text");
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        p.add((Component)((Object)gd), "Center");
        p.add((Component)lbl, "West");
        GuiUtils.testFrame((JComponent)p);
    }

    public Dimension getPreferredSize() {
        return new Dimension(120, 18);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

