/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.gauges;

import java.awt.BorderLayout;
import java.awt.Component;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.ConsoleScript;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.gauges.GaugeDisplay;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;

@PluginDescription(author="ZP", name="Gauge Panel", description="This panel displays a variable as a bar gauge", icon="pt/lsts/neptus/plugins/gauges/gauges.png")
public class GaugeSubPanel
extends ConsolePanel
implements ConfigurationListener,
IPeriodicUpdates {
    private GaugeDisplay display = new GaugeDisplay();
    private ConsoleScript script = new ConsoleScript();
    private ConsoleScript textScript = new ConsoleScript();
    @NeptusProperty
    public String expression = "$(CpuUsage.usage)/100";
    @NeptusProperty
    public String textToDisplay = "\"Usage: \"+($(CpuUsage.usage)/100)";
    @NeptusProperty
    public int millisBetweenUpdates = 1000;

    public String validateExpression(String script) {
        try {
            new ConsoleScript().setScript(script);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    public String validateTextToDisplay(String script) {
        try {
            new ConsoleScript().setScript(script);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    public GaugeSubPanel(ConsoleLayout console) {
        super(console);
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.display));
    }

    public long millisBetweenUpdates() {
        return this.millisBetweenUpdates;
    }

    public void propertiesChanged() {
        try {
            this.script.setScript(this.expression);
            this.textScript.setScript(this.textToDisplay);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean update() {
        Object o = this.script.evaluate(this.getState());
        if (o != null && o instanceof Number) {
            this.display.setValue(((Number)o).doubleValue());
        }
        if ((o = this.textScript.evaluate(this.getState())) != null) {
            this.display.setToolTipText(o.toString());
        } else {
            this.display.setToolTipText("null");
        }
        return true;
    }

    public void initSubPanel() {
    }

    public void cleanSubPanel() {
    }
}

