/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.accu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.mp.MapChangeEvent;
import pt.lsts.neptus.plugins.MultiSystemIMCMessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.accu.AccuUtils;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.TransponderElement;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.util.ConsoleParse;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription(name="Android CCU Tools", icon="pt/lsts/neptus/plugins/accu/accu.png")
public class AccuTools
extends ConsolePanel {
    private static final long serialVersionUID = -5015167316733219875L;
    @NeptusProperty(editable=false)
    private String destination = "accu-10688";
    private MultiSystemIMCMessageListener listener = new MultiSystemIMCMessageListener(((Object)((Object)this)).getClass().getSimpleName() + " [" + Integer.toHexString(((Object)((Object)this)).hashCode()) + "]"){

        public void messageArrived(ImcId16 id, IMCMessage msg) {
            final IMCMessage message = msg;
            Thread t = new Thread(){

                @Override
                public void run() {
                    int option;
                    Vector<IMCMessage> configs = new Vector<IMCMessage>();
                    Vector transponders = MapGroup.getMapGroupInstance((MissionType)AccuTools.this.getConsole().getMission()).getAllObjectsOfType(TransponderElement.class);
                    LinkedHashMap<String, TransponderElement> tHash = new LinkedHashMap<String, TransponderElement>();
                    for (TransponderElement el : transponders) {
                        tHash.put(el.getId().toLowerCase(), el);
                    }
                    for (int i = 0; i < 6; ++i) {
                        IMCMessage tmp = message.getMessage("beacon" + i);
                        if (tmp == null) continue;
                        configs.add(tmp);
                    }
                    if (!configs.isEmpty() && (option = JOptionPane.showConfirmDialog((Component)AccuTools.this.getConsole(), "Received a message with transponder configurations from " + ImcSystemsHolder.lookupSystem((ImcId16)new ImcId16((long)message.getHeader().getInteger("src"))) + ". Replace current transponder configuration?", "LBL configuration received", 0)) == 0) {
                        for (IMCMessage cfg : configs) {
                            TransponderElement elem;
                            String tid = cfg.getAsString("beacon").toLowerCase();
                            LocationType loc = new LocationType();
                            loc.setLatitudeDegs(Math.toDegrees(cfg.getDouble("lat")));
                            loc.setLongitudeDegs(Math.toDegrees(cfg.getDouble("lon")));
                            loc.setDepth(cfg.getDouble("depth"));
                            if (tHash.containsKey(tid)) {
                                elem = (TransponderElement)tHash.get(tid);
                                elem.setCenterLocation(loc);
                            } else {
                                MapType map = MapGroup.getMapGroupInstance((MissionType)AccuTools.this.getConsole().getMission()).getMaps()[0];
                                elem = new TransponderElement(map.getMapGroup(), map);
                                elem.setId(tid);
                                elem.setCenterLocation(loc);
                                elem.setConfiguration(elem.getId() + ".conf");
                                elem.setMapGroup(MapGroup.getMapGroupInstance((MissionType)AccuTools.this.getConsole().getMission()));
                                MapGroup.getMapGroupInstance((MissionType)AccuTools.this.getConsole().getMission()).getMaps()[0].addObject((AbstractElement)elem);
                            }
                            NeptusLog.pub().debug((Object)("Setting " + elem.getId() + " transponder in the console"));
                            elem.getMapGroup().warnListeners(new MapChangeEvent(0));
                        }
                    }
                }
            };
            t.start();
        }
    };

    public AccuTools(ConsoleLayout console) {
        super(console);
    }

    public void cleanSubPanel() {
        this.listener.clean();
    }

    public void initSubPanel() {
        this.removeAll();
        this.setVisibility(false);
        this.addMenuItem("Tools>Android CCU>Send map", ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/accu/accu_map.png"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AccuTools.this.getConsole().getMission() == null) {
                    GuiUtils.errorMessage((Component)AccuTools.this.getConsole(), (String)"Send Map", (String)"Cannot send map with no mission loaded in the console");
                    return;
                }
                try {
                    IMCMessage msg = AccuUtils.getAccuMap(AccuTools.this.getConsole().getMission());
                    ImcSystem[] systems = ImcSystemsHolder.lookupActiveSystemCCUs();
                    if (systems.length == 0) {
                        GuiUtils.errorMessage((Component)AccuTools.this.getConsole(), (String)"Send Map", (String)"No active CCUs");
                        return;
                    }
                    Object[] names = new String[systems.length];
                    for (int i = 0; i < systems.length; ++i) {
                        names[i] = systems[i].getName();
                    }
                    Object opt = JOptionPane.showInputDialog((Component)AccuTools.this.getConsole(), "Please enter the address of the destination", "Send Map", 3, null, names, AccuTools.this.destination);
                    if (opt != null) {
                        AccuTools.this.destination = opt.toString();
                        AccuTools.this.send(AccuTools.this.destination, msg);
                    }
                }
                catch (Exception ex) {
                    GuiUtils.errorMessage((Component)AccuTools.this.getConsole(), (Exception)ex);
                }
            }
        });
        this.addMenuItem("Tools>Android CCU>Send Current LBL Config", ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/accu/accu_map.png"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AccuTools.this.getConsole().getMission() == null) {
                    GuiUtils.errorMessage((Component)AccuTools.this.getConsole(), (String)"Send LBL Config", (String)"Cannot send LBL setup with no mission loaded in the console");
                    return;
                }
                try {
                    IMCMessage msg = IMCUtils.getLblConfig((MissionType)AccuTools.this.getConsole().getMission());
                    if (msg == null) {
                        GuiUtils.errorMessage((String)"Send LBL Config", (String)"Unable to generate LblConfig IMC message");
                        return;
                    }
                    ImcSystem[] systems = ImcSystemsHolder.lookupActiveSystemCCUs();
                    if (systems.length == 0) {
                        GuiUtils.errorMessage((Component)AccuTools.this.getConsole(), (String)"Send LBL Config", (String)"No active CCUs");
                        return;
                    }
                    Object[] names = new String[systems.length];
                    for (int i = 0; i < systems.length; ++i) {
                        names[i] = systems[i].getName();
                    }
                    Object opt = JOptionPane.showInputDialog((Component)AccuTools.this.getConsole(), "Please enter the address of the destination", "Send LBL Config", 3, null, names, AccuTools.this.destination);
                    if (opt != null) {
                        AccuTools.this.destination = opt.toString();
                        AccuTools.this.send(AccuTools.this.destination, msg);
                    }
                }
                catch (Exception ex) {
                    GuiUtils.errorMessage((Component)AccuTools.this.getConsole(), (Exception)ex);
                }
            }
        });
        this.listener.setMessagesToListen(new String[]{"LblConfig"});
        this.listener.setSystemToListen(new ImcId16[0]);
    }

    public static void main(String[] args) {
        ConsoleParse.testSubPanel(AccuTools.class);
    }
}

