/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.accu;

import java.awt.Color;
import java.util.Vector;
import javax.vecmath.Point3d;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.PathElement;
import pt.lsts.neptus.types.mission.MissionType;

public class AccuUtils {
    public static IMCMessage getAccuMap(MissionType mt) {
        try {
            IMCMessage msg = IMCDefinition.getInstance().create("Map", new Object[]{"id", mt.getId()});
            Vector<IMCMessage> features = new Vector<IMCMessage>();
            for (AbstractElement elem : MapGroup.getMapGroupInstance((MissionType)mt).getAllObjects()) {
                IMCMessage feature = AccuUtils.getAccuMapFeature(elem);
                if (feature == null) continue;
                features.add(feature);
            }
            msg.setValue("features", (Object)IMCUtils.asMessageList(features));
            return msg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IMCMessage getMapPoint(LocationType loc) {
        double[] lld = loc.getAbsoluteLatLonDepth();
        lld[0] = Math.toRadians(lld[0]);
        lld[1] = Math.toRadians(lld[1]);
        lld[2] = -lld[2];
        try {
            return IMCDefinition.getInstance().create("MapPoint", new Object[]{"lat", lld[0], "lon", lld[1], "alt", lld[2]});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IMCMessage getAccuMapFeature(AbstractElement element) {
        try {
            IMCMessage msg = IMCDefinition.getInstance().create("MapFeature", new Object[]{"id", element.getId()});
            Color color = Color.black;
            switch (element.getElementType()) {
                case TYPE_MARK: {
                    msg.setValue("feature_type", (Object)"POI");
                    msg.setValue("feature", (Object)AccuUtils.getMapPoint(element.getCenterLocation()));
                    if (!element.getId().equalsIgnoreCase("start")) {
                        color = Color.white;
                        break;
                    }
                    msg.setValue("feature_type", (Object)"STARTLOC");
                    color = Color.green;
                    break;
                }
                case TYPE_PATH: {
                    PathElement path = (PathElement)element;
                    if (path.isShape()) {
                        msg.setValue("feature_type", (Object)"FILLEDPOLY");
                    } else {
                        msg.setValue("feature_type", (Object)"LINE");
                    }
                    color = path.getMyColor();
                    Vector<IMCMessage> mapPoints = new Vector<IMCMessage>();
                    mapPoints.add(AccuUtils.getMapPoint(element.getCenterLocation()));
                    for (Point3d pt : path.getPoints()) {
                        LocationType loc = new LocationType(element.getCenterLocation());
                        loc.translatePosition(pt.x, pt.y, pt.z);
                        mapPoints.add(AccuUtils.getMapPoint(loc));
                    }
                    msg.setValue("feature", (Object)IMCUtils.asMessageList(mapPoints));
                    break;
                }
                case TYPE_TRANSPONDER: {
                    msg.setValue("feature_type", (Object)"TRANSPONDER");
                    msg.setValue("feature", (Object)AccuUtils.getMapPoint(element.getCenterLocation()));
                    color = Color.orange;
                    break;
                }
                case TYPE_HOMEREFERENCE: {
                    msg.setValue("id", (Object)"homeref");
                    msg.setValue("feature_type", (Object)"HOMEREF");
                    msg.setValue("feature", (Object)AccuUtils.getMapPoint(element.getCenterLocation()));
                    color = Color.red;
                    break;
                }
                default: {
                    return null;
                }
            }
            msg.setValue("rgb_red", (Object)color.getRed());
            msg.setValue("rgb_green", (Object)color.getGreen());
            msg.setValue("rgb_blue", (Object)color.getBlue());
            return msg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

