/*
 * Decompiled with CFR 0.152.
 */
package convcao.com.caoAgent;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.types.coord.LocationType;

public class NoptilusCoords
implements PropertiesProvider {
    @NeptusProperty(name="Area Center")
    public LocationType squareCenter = new LocationType();
    @NeptusProperty(name="Cell size", description="Cell size in meters for each map square")
    public double cellWidth = 1.0;
    @NeptusProperty(name="Number of Rows", description="Number of rows in the area rectangle")
    public double numRows = 240.0;
    @NeptusProperty(name="Number of Columns", description="Number of columns in the area rectangle")
    public double numCols = 240.0;
    @NeptusProperty(name="Maximum Depth", description="Number of depth units to use for the Noptilus map")
    public double maxDepth = 50.0;

    public NoptilusCoords() {
        this.loadProps();
    }

    protected void loadProps() {
        try {
            PluginUtils.loadProperties((String)"conf/noptcoords.properties", (Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void saveProps() {
        try {
            PluginUtils.saveProperties((String)"conf/noptcoords.properties", (Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LocationType convert(double row, double col) {
        if (col < 0.0 || col >= this.numCols) {
            System.err.println("Invalid column: " + col);
            return null;
        }
        if (row < 0.0 || col >= this.numRows) {
            System.err.println("Invalid Row: " + row);
            return null;
        }
        LocationType loc = new LocationType(this.squareCenter);
        double transN = (-this.numRows / 2.0 + row) * this.cellWidth;
        double transE = (-this.numCols / 2.0 + col) * this.cellWidth;
        loc.translatePosition(transN, transE, 0.0);
        return loc;
    }

    public double convertWgsDepthToNoptilusDepth(double depth) {
        return this.maxDepth - depth;
    }

    public double convertNoptilusDepthToWgsDepth(double depth) {
        return this.maxDepth - depth;
    }

    public double[] convert(LocationType loc) {
        LocationType sw = new LocationType(this.squareCenter);
        sw.translatePosition(-this.cellWidth * this.numRows / 2.0, -this.cellWidth * this.numCols / 2.0, 0.0);
        double[] offsets = loc.getOffsetFrom(sw);
        offsets[0] = offsets[0] / this.cellWidth;
        offsets[1] = offsets[1] / this.cellWidth;
        if (offsets[0] < 0.0) {
            offsets[0] = 0.0;
        }
        if (offsets[0] > this.numRows - 1.0) {
            offsets[0] = this.numRows - 1.0;
        }
        if (offsets[1] < 0.0) {
            offsets[1] = 0.0;
        }
        if (offsets[1] > this.numCols - 1.0) {
            offsets[1] = this.numCols - 1.0;
        }
        return new double[]{offsets[0], offsets[1]};
    }

    public DefaultProperty[] getProperties() {
        return PluginUtils.getPluginProperties((Object)this);
    }

    public String getPropertiesDialogTitle() {
        return "Noptilus Coordinate System properties";
    }

    public String[] getPropertiesErrors(Property[] properties) {
        return null;
    }

    public void setProperties(Property[] properties) {
        PluginUtils.setPluginProperties((Object)this, (Property[])properties);
    }

    public static void main(String[] args) {
        NoptilusCoords coords = new NoptilusCoords();
        PluginUtils.editPluginProperties((Object)coords, (boolean)true);
        coords.saveProps();
        System.out.println(coords.convert(20.0, 21.0));
        System.out.println(coords.convert(new LocationType(41.0, -7.999941))[1]);
    }
}

