/*
 * Decompiled with CFR 0.152.
 */
package convcao.com.caoAgent;

import com.google.gson.Gson;
import convcao.com.caoAgent.NoptilusCoords;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Random;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import org.apache.commons.net.ftp.FTPClient;
import pt.lsts.imc.DesiredZ;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.FollowRefState;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.Reference;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.Popup;
import pt.lsts.neptus.plugins.controllers.ControllerManager;
import pt.lsts.neptus.plugins.controllers.IController;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription(author="thanasis", category=PluginDescription.CATEGORY.UNSORTED, name="convcao Neptus Interaction")
@Popup(accelerator=78, pos=Popup.POSITION.CENTER, height=500, width=510, name="convcao Neptus Interaction")
public class convcaoNeptusInteraction
extends ConsolePanel
implements Renderer2DPainter,
IController,
ConfigurationListener {
    private static final long serialVersionUID = -1330079540844029305L;
    protected int AUVS;
    protected String SessionID = "";
    protected boolean cancel = false;
    protected String Report = "";
    protected JButton jButton1;
    protected JButton jButton2;
    protected JLabel jLabel1;
    protected JLabel jLabel2;
    protected JLabel jLabel3;
    protected JLabel jLabel4;
    protected JLabel jLabel5;
    protected JLabel jLabel7;
    protected JLabel jLabel8;
    protected JLabel jLabel9;
    protected JLabel jLabel10;
    protected JLabel jLabel11;
    protected JLabel jLabel12;
    protected JLabel jLabel6;
    protected JPanel jPanel1;
    protected JPanel jPanel2;
    protected JPanel jPanelMain;
    protected JPasswordField jPasswordField1;
    protected JScrollPane jScrollPane1;
    protected JScrollPane jScrollPane2;
    protected JTextArea jTextArea1;
    protected JTextField jTextField1;
    protected JTextPane jTextPane1;
    protected JButton renewButton;
    protected JButton connectButton;
    private boolean active = false;
    protected ImageIcon runIcon = ImageUtils.getIcon((String)"images/checklists/run.png");
    protected ImageIcon appLogo = ImageUtils.getIcon((String)"images/control-mode/externalApp.png");
    protected ImageIcon noptilusLogo = ImageUtils.getIcon((String)"images/control-mode/noptilus.png");
    protected ControllerManager manager = new ControllerManager();
    @NeptusProperty(name="Used vehicles", description="Identifiers of the vehicles to be used, separated by commas")
    public String controlledVehicles = "lauv-noptilus-1,lauv-noptilus-2";
    @NeptusProperty(name="First Depth", description="Depth for vehicle closer to the surface")
    public double firstVehicleDepth = 1.5;
    @NeptusProperty(name="Depth separation", description="Depth separation between vehicles")
    public double depthIncrements = 1.5;
    @NeptusProperty(name="Control Latency", description="Time, in seconds, between sending vehicle references")
    public int controlLatencySecs = 3;
    @NeptusProperty(name="Control Timeout", description="Time, in seconds, after which the vehicle will stop executing the plan if no references are received")
    public int controlTimeoutSecs = 120;
    @NeptusProperty(name="Use Acoustic Communications", description="Use acoustic communications to transmit desired control references")
    public boolean useAcousticComms = false;
    @NeptusProperty(name="Near distance", description="Distance, in meters, to consider that the vehicles have arrived at desired reference points")
    public double nearDistance = 12.5;
    protected Thread controlThread = null;
    int timestep = 1;
    protected NoptilusCoords coords = new NoptilusCoords();
    protected LinkedHashMap<String, LocationType> positions = new LinkedHashMap();
    protected LinkedHashMap<String, LocationType> destinations = new LinkedHashMap();
    protected LinkedHashMap<String, Double> bathymetry = new LinkedHashMap();
    protected LinkedHashMap<String, Boolean> arrived = new LinkedHashMap();
    protected LinkedHashMap<Integer, String> nameTable = new LinkedHashMap();
    protected LinkedHashMap<String, Double> depths = new LinkedHashMap();

    protected void showText(String text) {
        this.jTextArea1.append("[" + this.timestep + "] " + text + "\n");
        while (this.jTextArea1.getRows() > 50 && this.jTextArea1.getText().contains("\n")) {
            this.jTextArea1.setText(this.jTextArea1.getText().substring(this.jTextArea1.getText().indexOf(10) + 1));
        }
        this.jTextArea1.repaint();
        this.jTextArea1.scrollRectToVisible(new Rectangle(0, this.jTextArea1.getHeight() + 22, 1, 1));
    }

    public void propertiesChanged() {
        this.manager.setUseAcousticComms(this.useAcousticComms);
        LinkedHashMap<String, Double> newDepths = new LinkedHashMap<String, Double>();
        double depth = this.firstVehicleDepth;
        for (String v : this.positions.keySet()) {
            newDepths.put(v, depth);
            depth += this.depthIncrements;
        }
        this.depths = newDepths;
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        Point2D center = renderer.getScreenPosition(this.coords.squareCenter);
        double width = (double)renderer.getZoom() * this.coords.cellWidth * this.coords.numCols;
        double height = (double)renderer.getZoom() * this.coords.cellWidth * this.coords.numRows;
        g.setColor(new Color(0, 0, 255, 64));
        g.translate(center.getX(), center.getY());
        g.rotate(-renderer.getRotation());
        g.fill(new Rectangle2D.Double(-width / 2.0, -height / 2.0, width, height));
        g.rotate(renderer.getRotation());
        g.translate(-center.getX(), -center.getY());
        if (!this.active) {
            return;
        }
        g.setColor(Color.orange);
        int pos = 50;
        for (String v : this.nameTable.values()) {
            g.drawString(v + ": " + this.depths.get(v) + "m", 15, pos);
            pos += 20;
        }
        for (String vehicle : this.nameTable.values()) {
            LocationType src = this.positions.get(vehicle);
            LocationType dst = this.destinations.get(vehicle);
            if (!this.arrived.get(vehicle).booleanValue()) {
                g.setColor(Color.red.darker());
            } else {
                g.setColor(Color.green.darker());
            }
            float[] dash = new float[]{4.0f};
            g.setStroke(new BasicStroke(1.0f, 0, 0, 5.0f, dash, 0.0f));
            g.draw(new Line2D.Double(renderer.getScreenPosition(src), renderer.getScreenPosition(dst)));
            Point2D dstPt = renderer.getScreenPosition(dst);
            if (!this.arrived.get(vehicle).booleanValue()) {
                g.setColor(Color.red.darker());
            } else {
                g.setColor(Color.green.darker());
            }
            g.fill(new Ellipse2D.Double(dstPt.getX() - 4.0, dstPt.getY() - 4.0, 8.0, 8.0));
        }
    }

    public TransferData localState() {
        TransferData data = new TransferData();
        data.timeStep = this.timestep;
        data.SessionID = this.SessionID;
        data.Bathymeter = new double[this.AUVS];
        data.Location = new double[this.AUVS][3];
        for (int AUV = 0; AUV < this.AUVS; ++AUV) {
            String auvName = this.nameTable.get(AUV);
            double noptDepth = this.coords.convertWgsDepthToNoptilusDepth(this.positions.get(auvName).getDepth());
            data.Bathymeter[AUV] = noptDepth - this.bathymetry.get(auvName);
            double[] nopCoords = this.coords.convert(this.positions.get(auvName));
            if (nopCoords == null) {
                GuiUtils.errorMessage((Component)this.getConsole(), (String)"ConvCAO", (String)(auvName + " is outside operating region"));
                return null;
            }
            data.Location[AUV][0] = Math.round(nopCoords[0]);
            data.Location[AUV][1] = Math.round(nopCoords[1]);
            data.Location[AUV][2] = (int)noptDepth;
        }
        return data;
    }

    public void controlLoop() throws Exception {
        TransferData send = this.localState();
        if (send == null) {
            throw new Exception("Unable to compute local state");
        }
        TransferData receive = new TransferData();
        for (int AUV = 0; AUV < this.AUVS; ++AUV) {
            this.showText(this.nameTable.get(AUV) + " is at " + send.Location[AUV][0] + ", " + send.Location[AUV][1] + ", " + send.Location[AUV][2]);
        }
        Gson gson = new Gson();
        String json = gson.toJson((Object)send);
        PrintWriter writer = null;
        writer = new PrintWriter(this.SessionID + "_Data.txt", "UTF-8");
        writer.write(json);
        writer.close();
        NeptusLog.pub().info((Object)("uploading to convcao..." + json.toString()));
        this.Upload("www.convcao.com", "NEPTUS", "", this.jTextField1.getText(), new String(this.jPasswordField1.getPassword()), this.SessionID + "_Data.txt");
        this.showText("Upload complete, downloading new AUV destinations");
        int receivedTimestep = 0;
        while (!this.cancel && receivedTimestep < this.timestep) {
            Thread.sleep(100L);
            try {
                URL url = new URL("http://www.convcao.com/caoagile/FilesFromAgent/NEPTUS/" + this.SessionID + "_NewActions.txt");
                URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                conn.connect();
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String jsonClient = in.readLine();
                receive = (TransferData)new Gson().fromJson(jsonClient, TransferData.class);
                receivedTimestep = receive.timeStep;
            }
            catch (IOException ex) {
                NeptusLog.pub().error((Object)ex);
            }
        }
        this.showText("Received updated positions from convcao");
        ++this.timestep;
        for (int AUV = 0; AUV < receive.Location.length; ++AUV) {
            String name = this.nameTable.get(AUV);
            LocationType loc = this.coords.convert(receive.Location[AUV][0], receive.Location[AUV][1]);
            loc.setDepth(1.0 + (double)AUV * 1.5);
            this.destinations.put(name, loc);
            this.showText(name + " is being sent to " + receive.Location[AUV][0] + ", " + receive.Location[AUV][1]);
        }
        this.myDeleteFile(this.SessionID + "_Data.txt");
    }

    public Thread auvMonitor() {
        Thread auvMon = new Thread("AuvMonitor"){

            @Override
            public void run() {
                while (!convcaoNeptusInteraction.this.cancel) {
                    convcaoNeptusInteraction.this.updateLocalStructures();
                    boolean arrivedState = true;
                    for (boolean arr : convcaoNeptusInteraction.this.arrived.values()) {
                        if (arr) continue;
                        arrivedState = false;
                    }
                    try {
                        if (arrivedState) {
                            convcaoNeptusInteraction.this.showText("All vehicles arrived at desired positions. Starting new control sequence");
                            try {
                                convcaoNeptusInteraction.this.controlLoop();
                                continue;
                            }
                            catch (InterruptedException e) {
                                NeptusLog.pub().warn((Object)"Control thread interrupted");
                                convcaoNeptusInteraction.this.manager.stop();
                                return;
                            }
                            catch (Exception e) {
                                GuiUtils.errorMessage((Component)convcaoNeptusInteraction.this.getConsole(), (Exception)e);
                                e.printStackTrace();
                                return;
                            }
                        }
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        convcaoNeptusInteraction.this.showText("Control thread interrupted");
                        convcaoNeptusInteraction.this.manager.stop();
                        return;
                    }
                }
            }
        };
        return auvMon;
    }

    public convcaoNeptusInteraction(ConsoleLayout console) {
        super(console);
    }

    private String GenerateID() {
        Random rnd = new Random(System.currentTimeMillis());
        String ID = "Neptus_User_" + Integer.toString(rnd.nextInt(10000));
        return ID;
    }

    private void renewButtonActionPerformed(ActionEvent evt) {
        this.SessionID = this.GenerateID();
        this.jTextField1.setEditable(true);
        this.jPasswordField1.setEditable(true);
        this.jLabel1.setVisible(true);
        this.jButton1.setEnabled(false);
        this.jButton2.setEnabled(false);
        this.jTextPane1.setText(this.SessionID);
        this.connectButton.setEnabled(true);
        this.jLabel6.setVisible(true);
    }

    private void StopButtonActionPerformed(ActionEvent evt) {
        this.jLabel10.setText("Please Wait...");
        this.Report = "Canceled";
        this.cancel = true;
        if (this.controlThread != null) {
            this.controlThread.interrupt();
        }
        this.manager.stop();
        this.jLabel9.setVisible(false);
        this.jButton1.setEnabled(false);
        this.jButton2.setEnabled(false);
        this.connectButton.setEnabled(false);
        this.renewButton.setEnabled(true);
        this.Report = "";
        this.jLabel1.setVisible(false);
        this.jTextArea1.setText("");
        this.jLabel10.setText("");
        this.jLabel6.setText("Please Renew your ID to start again");
        this.timestep = 1;
        this.active = false;
    }

    private void StartButtonActionPerformed(ActionEvent evt) {
        this.cancel = false;
        this.jLabel9.setVisible(true);
        this.jButton2.setEnabled(true);
        this.jButton1.setEnabled(false);
        this.renewButton.setEnabled(false);
        this.connectButton.setEnabled(false);
        this.timestep = 1;
        this.showText("Starting FollowReference plans on vehicles");
        this.active = true;
        try {
            for (String v : this.nameTable.values()) {
                this.manager.associateControl((IController)this, VehiclesHolder.getVehicleById((String)v), this.controlLatencySecs, this.controlTimeoutSecs);
            }
        }
        catch (Exception e) {
            GuiUtils.errorMessage((Component)this.getConsole(), (Exception)e);
            return;
        }
        this.controlThread = this.auvMonitor();
        this.controlThread.start();
    }

    private void updateLocalStructures() {
        for (String auvName : this.nameTable.values()) {
            EstimatedState state = ImcMsgManager.getManager().getState(auvName).lastEstimatedState();
            LocationType auvPosition = IMCUtils.getLocation((IMCMessage)state);
            this.positions.put(auvName, auvPosition);
            this.bathymetry.put(auvName, state.getDepth() + state.getAlt());
            double dist = auvPosition.getHorizontalDistanceInMeters(this.destinations.get(auvName));
            if (dist < this.nearDistance) {
                this.arrived.put(auvName, true);
                continue;
            }
            this.arrived.put(auvName, false);
        }
    }

    private void startLocalStructures(String[] vehicles) throws Exception {
        this.positions.clear();
        this.destinations.clear();
        this.bathymetry.clear();
        this.nameTable.clear();
        this.arrived.clear();
        for (String auvName : vehicles) {
            EstimatedState state = ImcMsgManager.getManager().getState(auvName).lastEstimatedState();
            if (state == null) {
                throw new Exception("Not able to get initial position for vehicle " + auvName);
            }
            LocationType auvPosition = IMCUtils.getLocation((IMCMessage)state);
            this.positions.put(auvName, auvPosition);
            this.destinations.put(auvName, auvPosition);
            this.bathymetry.put(auvName, state.getDepth() + state.getAlt());
            this.arrived.put(auvName, true);
            this.startControlling(VehiclesHolder.getVehicleById((String)auvName), ImcMsgManager.getManager().getState(auvName).lastEstimatedState());
        }
        int i = 0;
        double depth = this.firstVehicleDepth;
        for (String v : this.positions.keySet()) {
            this.nameTable.put(i++, v);
            this.depths.put(v, depth);
            depth += this.depthIncrements;
        }
    }

    private void connectButtonActionPerformed(ActionEvent evt) throws SocketException, IOException {
        String[] vehicles = this.controlledVehicles.split(",");
        this.jTextArea1.setText("");
        this.jTextArea1.repaint();
        this.showText("Initializing Control Structures");
        try {
            this.startLocalStructures(vehicles);
        }
        catch (Exception e) {
            GuiUtils.errorMessage((Component)this.getConsole(), (Exception)e);
            return;
        }
        this.AUVS = this.positions.keySet().size();
        this.showText("Initializing server connection");
        FTPClient client = new FTPClient();
        boolean PathNameCreated = false;
        try {
            client.connect("www.convcao.com", 21);
            client.login(this.jTextField1.getText(), new String(this.jPasswordField1.getPassword()));
            PathNameCreated = client.makeDirectory("/NEPTUS/" + this.SessionID);
            client.logout();
        }
        catch (IOException e) {
            this.jLabel6.setText("Connection Error");
            throw e;
        }
        this.showText("Sending session data");
        InputData initialState = new InputData();
        initialState.DateTime = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(new Date());
        initialState.SessionID = this.SessionID;
        initialState.DemoMode = "1";
        initialState.AUVs = "" + this.positions.keySet().size();
        String fileName = this.SessionID + ".txt";
        Gson gson = new Gson();
        String json = gson.toJson((Object)initialState);
        PrintWriter writer = new PrintWriter(fileName, "UTF-8");
        writer.write(json);
        writer.close();
        if (PathNameCreated) {
            this.jLabel6.setText("Connection Established");
            this.jLabel1.setVisible(true);
            System.out.println("Uploading first file");
            this.Upload("www.convcao.com", "NEPTUS", "", this.jTextField1.getText(), new String(this.jPasswordField1.getPassword()), fileName);
            System.out.println("Uploading second file");
            this.Upload("www.convcao.com", "NEPTUS/" + this.SessionID, "plugins-dev/caoAgent/convcao/com/caoAgent/", this.jTextField1.getText(), new String(this.jPasswordField1.getPassword()), "mapPortoSparse.txt");
            System.out.println("Both files uploaded");
            this.jButton1.setEnabled(true);
            this.jButton2.setEnabled(true);
            this.jTextPane1.setEditable(false);
            this.jTextField1.setEditable(false);
            this.jPasswordField1.setEditable(false);
            this.connectButton.setEnabled(false);
            this.renewButton.setEnabled(false);
        } else {
            this.jLabel6.setText(client.getReplyString());
            this.jLabel1.setVisible(false);
        }
        this.myDeleteFile(fileName);
        this.showText("ConvCAO control has started");
    }

    private void myDeleteFile(String fileName) {
        String[] files;
        File f = new File(fileName);
        if (!f.exists()) {
            throw new IllegalArgumentException("Delete: no such file or directory: " + fileName);
        }
        if (!f.canWrite()) {
            throw new IllegalArgumentException("Delete: write protected: " + fileName);
        }
        if (f.isDirectory() && (files = f.list()).length > 0) {
            throw new IllegalArgumentException("Delete: directory not empty: " + fileName);
        }
        boolean success = f.delete();
        if (!success) {
            throw new IllegalArgumentException("Delete: deletion failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Upload(String ftpServer, String pathDirectory, String SourcePathDirectory, String userName, String password, String filename) {
        FTPClient client = new FTPClient();
        FileInputStream fis = null;
        try {
            client.connect(ftpServer);
            client.login(userName, password);
            client.enterLocalPassiveMode();
            client.setFileType(2);
            fis = new FileInputStream(SourcePathDirectory + filename);
            client.changeWorkingDirectory("/" + pathDirectory);
            client.storeFile(filename, (InputStream)fis);
            System.out.println("The file " + SourcePathDirectory + " was stored to " + "/" + pathDirectory + "/" + filename);
            client.logout();
        }
        catch (Exception exp) {
            exp.printStackTrace();
            this.Report = "Server Error";
            this.jLabel6.setText(this.Report);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                client.disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void jLabel1MouseClicked(MouseEvent evt) throws URISyntaxException, IOException {
        Desktop desktop;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            URI uri = new URI("http://www.noptilus-fp7.eu/default.asp?node=page&id=321&lng=2");
            desktop.browse(uri);
        }
    }

    public void initSubPanel() {
        this.jPanelMain = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.renewButton = new JButton();
        this.jLabel4 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel5 = new JLabel();
        this.jPasswordField1 = new JPasswordField();
        this.connectButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel11.setIcon(this.noptilusLogo);
        this.jLabel12.setHorizontalAlignment(2);
        this.jLabel12.setText("<html>www.convcao.com<br>version 0.01</html>");
        this.jLabel12.setToolTipText("");
        this.jLabel12.setHorizontalTextPosition(4);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel11, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 19, Short.MAX_VALUE).addComponent(this.jLabel12, -2, -1, -2)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel11, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel12, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        this.jLabel2.setFont(new Font("Tahoma", 0, 10));
        this.jLabel2.setText("Unique ID");
        this.jTextPane1.setEditable(true);
        this.jScrollPane1.setViewportView(this.jTextPane1);
        this.renewButton.setText("RENEW");
        this.renewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                convcaoNeptusInteraction.this.renewButtonActionPerformed(evt);
            }
        });
        this.jLabel4.setFont(new Font("Tahoma", 0, 12));
        this.jLabel4.setText("Username");
        this.jTextField1.setText("FTPUser");
        this.jLabel5.setFont(new Font("Tahoma", 0, 12));
        this.jLabel5.setText("Password");
        this.jPasswordField1.setText("FTPUser123");
        this.connectButton.setText("Connect");
        this.connectButton.setEnabled(false);
        this.connectButton.setActionCommand("connect");
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    convcaoNeptusInteraction.this.connectButtonActionPerformed(evt);
                }
                catch (FileNotFoundException | UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextArea1);
        this.jLabel7.setFont(new Font("Tahoma", 0, 12));
        this.jLabel7.setText("Command Monitor");
        this.jButton1.setFont(new Font("Tahoma", 1, 12));
        this.jButton1.setText("START");
        this.jButton1.setEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                convcaoNeptusInteraction.this.StartButtonActionPerformed(evt);
            }
        });
        this.jButton2.setFont(new Font("Tahoma", 1, 12));
        this.jButton2.setText("STOP");
        this.jButton2.setEnabled(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                convcaoNeptusInteraction.this.StopButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setForeground(new Color(255, 0, 0));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("<html>Click HERE to activate the web service using your ID<br>When the web application is ready, press Start </html>");
        this.jLabel1.setCursor(new Cursor(12));
        this.jLabel1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                try {
                    convcaoNeptusInteraction.this.jLabel1MouseClicked(evt);
                }
                catch (IOException | URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        });
        this.jLabel9.setIcon(this.runIcon);
        this.jLabel9.setVisible(false);
        this.jLabel10.setText("---");
        this.jLabel6.setForeground(new Color(0, 204, 0));
        this.jLabel6.setHorizontalAlignment(0);
        this.jLabel6.setText("---");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(126, 126, 126).addComponent(this.jLabel7, -2, 110, -2)).addGroup(jPanel2Layout.createSequentialGroup().addGap(23, 23, 23).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jLabel9, -2, 56, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton1, -2, 80, -2).addGap(29, 29, 29).addComponent(this.jButton2, -2, 77, -2)).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING, -2, 308, -2)).addComponent(this.jLabel10, GroupLayout.Alignment.LEADING, -2, 103, -2).addComponent(this.jLabel1, -2, 299, -2)))).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jLabel2, -2, 80, -2).addGap(18, 18, 18).addComponent(this.jScrollPane1, -2, 130, -2).addGap(18, 18, 18).addComponent(this.renewButton)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel4, -2, 64, -2).addGap(18, 18, 18).addComponent(this.jTextField1, -2, 130, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel5, -2, 64, -2).addGap(18, 18, 18).addComponent(this.jPasswordField1))).addGap(14, 14, 14).addComponent(this.connectButton))))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.renewButton, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1).addComponent(this.jLabel2, -2, 25, -2)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.jTextField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE).addComponent(this.jPasswordField1, -2, -1, -2).addComponent(this.connectButton, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel6, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 113, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButton2, -1, -1, Short.MAX_VALUE).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel9, -2, 33, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10, -2, 26, -2).addGap(5, 5, 5)));
        this.jLabel1.getAccessibleContext().setAccessibleName("jLabel1");
        this.jLabel3.setFont(new Font("Tahoma", 1, 22));
        this.jLabel3.setText("Real Time Navigation");
        this.jLabel8.setIcon(this.appLogo);
        GroupLayout layout = new GroupLayout(this.jPanelMain);
        this.jPanelMain.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel8, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, 331, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel8, -2, 110, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.addMenuItem("Settings>Noptilus>Coordinate Settings", ImageUtils.getIcon((String)PluginUtils.getPluginIcon(((Object)((Object)this)).getClass())), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginUtils.editPluginProperties((Object)convcaoNeptusInteraction.this.coords, (boolean)true);
                convcaoNeptusInteraction.this.coords.saveProps();
            }
        });
        this.addMenuItem("Settings>Noptilus>ConvCAO Settings", ImageUtils.getIcon((String)PluginUtils.getPluginIcon(((Object)((Object)this)).getClass())), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginUtils.editPluginProperties((Object)((Object)convcaoNeptusInteraction.this), (boolean)true);
            }
        });
        this.addMenuItem("Settings>Noptilus>Force vehicle depth", ImageUtils.getIcon((String)PluginUtils.getPluginIcon(((Object)((Object)this)).getClass())), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (convcaoNeptusInteraction.this.positions.isEmpty()) {
                    GuiUtils.errorMessage((Component)convcaoNeptusInteraction.this.getConsole(), (String)"Force vehicle depth", (String)"ConvCAO control is not active");
                    return;
                }
                Object[] choices = convcaoNeptusInteraction.this.nameTable.values().toArray(new String[0]);
                String vehicle = (String)JOptionPane.showInputDialog((Component)convcaoNeptusInteraction.this.getConsole(), "Force vehicle depth", "Choose vehicle", 3, null, choices, choices[0]);
                if (vehicle != null) {
                    double depth = convcaoNeptusInteraction.this.depths.get(vehicle);
                    String newDepth = JOptionPane.showInputDialog((Component)convcaoNeptusInteraction.this.getConsole(), "New depth", "" + depth);
                    try {
                        double dd = Double.parseDouble(newDepth);
                        convcaoNeptusInteraction.this.depths.put(vehicle, dd);
                    }
                    catch (Exception ex) {
                        GuiUtils.errorMessage((Component)convcaoNeptusInteraction.this.getConsole(), (Exception)ex);
                    }
                }
            }
        });
        this.add(this.jPanelMain);
        this.renewButtonActionPerformed(null);
    }

    public void cleanSubPanel() {
    }

    void updateConvCaoService() {
    }

    public String getControllerName() {
        return "convcao";
    }

    public Reference guide(VehicleType vehicle, EstimatedState estate, FollowRefState frefState) {
        if (estate.getAlt() != -1.0) {
            this.bathymetry.put(vehicle.getId(), estate.getDepth() + estate.getAlt());
        }
        this.positions.put(vehicle.getId(), IMCUtils.parseLocation((IMCMessage)estate));
        if (!this.destinations.containsKey(vehicle.getId())) {
            this.destinations.put(vehicle.getId(), this.positions.get(vehicle.getId()));
        }
        Reference ref = new Reference();
        ref.setFlags((short)5);
        LocationType dest = this.destinations.get(vehicle.getId());
        float depth = this.depths.get(vehicle.getId()).floatValue();
        dest.convertToAbsoluteLatLonDepth();
        ref.setLat(dest.getLatitudeRads());
        ref.setLon(dest.getLongitudeRads());
        DesiredZ desZ = new DesiredZ(depth, DesiredZ.Z_UNITS.DEPTH);
        if (depth > 0.0f) {
            ref.setRadius(10.0);
        }
        ref.setZ(desZ);
        System.out.println("Sending this reference to " + vehicle.getId() + ":");
        ref.dump((OutputStream)System.out);
        return ref;
    }

    public void startControlling(VehicleType vehicle, EstimatedState state) {
        this.positions.put(vehicle.getId(), IMCUtils.getLocation((IMCMessage)state));
        if (state.getAlt() != -1.0) {
            this.bathymetry.put(vehicle.getId(), state.getDepth() + state.getAlt());
        }
    }

    public void stopControlling(VehicleType vehicle) {
    }

    public boolean supportsVehicle(VehicleType vehicle, EstimatedState state) {
        return vehicle.getType().equalsIgnoreCase("uuv") || vehicle.getType().equalsIgnoreCase("auv");
    }

    public void vehicleTimedOut(VehicleType vehicle) {
        this.stopControlling(vehicle);
    }

    public class TransferData {
        public String SessionID = "";
        public int timeStep = 0;
        public double[] Bathymeter;
        public double[][] Location;
    }

    public class InputData {
        public String DateTime = "";
        public String SessionID = "";
        public String DemoMode = "1";
        public String AUVs = "";
    }
}

