/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.noptilus;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Random;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.vecmath.Point3d;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.colormap.ColorMapUtils;
import pt.lsts.neptus.colormap.DataDiscretizer;
import pt.lsts.neptus.util.GuiUtils;

public class DummyMapGenerator {
    protected int rows = 200;
    protected int cols = 200;
    protected double resolution = 0.5;
    protected Vector<Point3d> lowResData = new Vector();
    protected Vector<Point3d> highResData = new Vector();
    protected Vector<Point3d> noiseData = new Vector();

    public Vector<Point3d> generateRandomData(int numPoints) {
        Vector<Point3d> data = new Vector<Point3d>();
        Random rnd = new Random(System.currentTimeMillis());
        for (int i = 0; i < 50; ++i) {
            int x = rnd.nextInt(this.rows);
            int y = rnd.nextInt(this.cols);
            double val = rnd.nextGaussian() * 20.0;
            data.add(new Point3d((double)x, (double)y, val));
        }
        return data;
    }

    public Vector<Point3d> generatePathData(int numPoints) {
        Vector<Point3d> data = new Vector<Point3d>();
        Random rnd = new Random(System.currentTimeMillis());
        for (int i = 0; i < 50; ++i) {
            int x;
            int y = x = rnd.nextInt(this.rows);
            double val = rnd.nextGaussian() * 20.0;
            data.add(new Point3d((double)x, (double)y, val));
        }
        return data;
    }

    public void firstPhase() {
        this.noiseData = this.generateRandomData(25);
        this.lowResData = this.generatePathData(50);
        this.highResData = this.generatePathData(100);
        DataDiscretizer dd = new DataDiscretizer(20.0);
        for (Point3d pt : this.lowResData) {
            dd.addPoint(pt.x, pt.y, pt.z);
        }
        for (Point3d pt : this.noiseData) {
            dd.addPoint(pt.x, pt.y, pt.z);
        }
        BufferedImage img = new BufferedImage(this.rows, this.cols, 2);
        ColorMapUtils.generateColorMap((DataDiscretizer.DataPoint[])dd.getDataPoints(), (Graphics2D)img.createGraphics(), (double)this.rows, (double)this.cols, (int)0, (ColorMap)ColorMapFactory.createGrayScaleColorMap());
        JLabel lbl = new JLabel(new ImageIcon(img));
        GuiUtils.testFrame((JComponent)lbl);
        this.highResData = this.generatePathData(50);
        dd = new DataDiscretizer(1.0);
        for (Point3d pt : this.noiseData) {
            dd.addPoint(pt.x, pt.y, pt.z);
        }
        for (Point3d pt : this.lowResData) {
            dd.addPoint(pt.x, pt.y, pt.z);
        }
        for (Point3d pt : this.highResData) {
            dd.addPoint(pt.x, pt.y, pt.z);
        }
        BufferedImage img2 = new BufferedImage(this.rows, this.cols, 2);
        ColorMapUtils.generateColorMap((DataDiscretizer.DataPoint[])dd.getDataPoints(), (Graphics2D)img2.createGraphics(), (double)this.rows, (double)this.cols, (int)0, (ColorMap)ColorMapFactory.createGrayScaleColorMap());
        JLabel lbl2 = new JLabel(new ImageIcon(img2));
        GuiUtils.testFrame((JComponent)lbl2);
        try {
            this.PathToFile(this.lowResData, new File("path_lowres.txt"));
            this.highResData.addAll(this.lowResData);
            this.PathToFile(this.highResData, new File("path_highres.txt"));
            this.ImageToFile(img, new File("lowres.txt"), "Low resolution using 50 data points and cell width of 20 meters");
            ImageIO.write((RenderedImage)img, "png", new File("lowres.png"));
            this.ImageToFile(img2, new File("highres.txt"), "High resolution using 150 data points and cell width of 1 meters");
            ImageIO.write((RenderedImage)img2, "png", new File("highres.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void PathToFile(Vector<Point3d> points, File out) throws Exception {
        BufferedWriter bw = new BufferedWriter(new FileWriter(out));
        bw.write("# Path generated by Neptus Dummy Map Generator\n");
        bw.write("200 200 0.5 0 0\n\n");
        int[] path = new int[this.cols];
        for (Point3d pt : points) {
            int i = (int)pt.x;
            path[i] = 1;
        }
        for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.cols; ++x) {
                if (x == y && path[x] == 1) {
                    bw.write("1 ");
                    continue;
                }
                bw.write("0 ");
            }
            bw.write("\n");
            System.out.println();
        }
        bw.close();
    }

    public void ImageToFile(BufferedImage img, File out, String desc) throws Exception {
        BufferedWriter bw = new BufferedWriter(new FileWriter(out));
        bw.write("# Map generated by Neptus Dummy Map Generator\n");
        bw.write("# " + desc + "\n");
        bw.write("200 200 0.5 0 0\n\n");
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                int val = (img.getRGB(x, y) & 0xFF00) >> 8;
                System.out.print((double)val / 255.0 + " ");
                double value = (double)(val * 20) / 255.0;
                bw.write((float)value + " ");
            }
            bw.write("\n");
            System.out.println();
        }
        bw.close();
    }

    public static void main(String[] args) {
        new DummyMapGenerator().firstPhase();
    }
}

