/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.noptilus;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.plugins.noptilus.LandmarkUtils;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;

public class LandmarkReplay
implements Renderer2DPainter {
    protected BufferedReader replayReader = null;
    protected int numMarks;
    protected int lineno;
    protected LandmarkUtils.LANDMARK[] state;
    protected StateRenderer2D renderer = null;
    protected Vector<LocationType> locations = new Vector();
    protected Thread replayThread = null;

    public LandmarkReplay(File positions, File states, long timestepMillis) throws Exception {
        LandmarkUtils.loadLandmarks(positions, this.locations);
        this.numMarks = this.locations.size();
        this.state = new LandmarkUtils.LANDMARK[this.numMarks];
        for (int i = 0; i < this.numMarks; ++i) {
            this.state[i] = LandmarkUtils.LANDMARK.UNKNOWN;
        }
        if (states != null) {
            this.replayReader = new BufferedReader(new FileReader(states));
            String firstLine = this.replayReader.readLine();
            String[] parts = firstLine.split("\\s+");
            this.lineno = 1;
            this.updateState(parts);
            this.replayThread = this.startReplay(timestepMillis);
        }
    }

    public void cleanup() {
        if (this.replayThread != null) {
            this.replayThread.interrupt();
        }
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        this.renderer = renderer;
        for (int i = 0; i < this.locations.size(); ++i) {
            g.setColor(this.state[i].getColor());
            Point2D pt = renderer.getScreenPosition(this.locations.get(i));
            g.draw(new Line2D.Double(pt.getX() - 1.0, pt.getY() - 1.0, pt.getX() + 1.0, pt.getY() + 1.0));
            g.draw(new Line2D.Double(pt.getX() + 1.0, pt.getY() - 1.0, pt.getX() - 1.0, pt.getY() + 1.0));
        }
    }

    protected void updateState(String[] parts) {
        int j = 0;
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].isEmpty()) continue;
            this.state[j++] = LandmarkUtils.getLandmarkState(Integer.parseInt(parts[i]));
        }
    }

    public Thread startReplay(final long timestepMillis) {
        Thread t = new Thread("Landmark replay thread"){

            @Override
            public void run() {
                String line = null;
                try {
                    line = LandmarkReplay.this.replayReader.readLine();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                while (line != null) {
                    line = line.replaceAll("\\s+", "\t");
                    ++LandmarkReplay.this.lineno;
                    String[] parts = line.split("\\t");
                    LandmarkReplay.this.updateState(parts);
                    if (LandmarkReplay.this.renderer != null) {
                        LandmarkReplay.this.renderer.repaint();
                    }
                    try {
                        Thread.sleep(timestepMillis);
                        line = LandmarkReplay.this.replayReader.readLine();
                    }
                    catch (InterruptedException e) {
                        NeptusLog.pub().info((Object)"replay stopped");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        t.start();
        return t;
    }
}

