/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.noptilus;

import java.awt.Color;
import java.io.File;
import java.util.Vector;
import javax.swing.JFileChooser;
import pt.lsts.neptus.plugins.noptilus.PlanUtils;
import pt.lsts.neptus.types.coord.LocationType;

public class LandmarkUtils {
    public static LANDMARK getLandmarkState(int value) {
        switch (value) {
            case 0: {
                return LANDMARK.UNKNOWN;
            }
            case 1: {
                return LANDMARK.VISIBLE;
            }
        }
        return LANDMARK.ACCURATE;
    }

    public static void loadLandmarks(File landmarksFile, Vector<LocationType> positions) throws Exception {
        Vector<double[]> points = PlanUtils.loadWaypoints(landmarksFile);
        positions.clear();
        for (double[] pt : points) {
            LocationType loc = new LocationType(pt[0], pt[1]);
            loc.setAbsoluteDepth(pt[2]);
            positions.add(loc);
        }
    }

    public static void main(String[] args) {
        JFileChooser chooser = new JFileChooser();
        chooser.showOpenDialog(null);
    }

    public static enum LANDMARK {
        UNKNOWN(0, Color.black),
        VISIBLE(1, Color.red),
        ACCURATE(2, Color.green);

        private final Color color;
        private final int value;

        private LANDMARK(int value, Color color) {
            this.color = color;
            this.value = value;
        }

        public Color getColor() {
            return this.color;
        }

        public int getValue() {
            return this.value;
        }
    }
}

