/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.noptilus;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import convcao.com.caoAgent.NoptilusCoords;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import javax.imageio.ImageIO;
import javax.swing.ProgressMonitor;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfIterator;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.colormap.ColorMapUtils;
import pt.lsts.neptus.colormap.DataDiscretizer;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.api.BathymetryPoint;
import pt.lsts.neptus.mra.api.BathymetrySwath;
import pt.lsts.neptus.mra.exporters.MRAExporter;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.importers.deltat.DeltaTParser;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.types.coord.LocationType;

@PluginDescription
public class NoptilusMapExporter
implements MRAExporter,
PropertiesProvider {
    NoptilusCoords coords = new NoptilusCoords();
    protected IMraLogGroup source = null;

    public NoptilusMapExporter(IMraLogGroup source) {
        this.source = source;
        PluginUtils.loadProperties((Object)this, (String)"default");
    }

    public boolean canBeApplied(IMraLogGroup source) {
        return false;
    }

    public String process(IMraLogGroup source, ProgressMonitor pmonitor) {
        PropertiesEditor.editProperties((PropertiesProvider)this, (boolean)true);
        this.coords.squareCenter.convertToAbsoluteLatLonDepth();
        PluginUtils.saveProperties((Object)this, (String)"default");
        double mapWidth = this.coords.numCols * this.coords.cellWidth;
        double mapHeight = this.coords.numRows * this.coords.cellWidth;
        double cellSize = this.coords.cellWidth;
        LocationType sw = new LocationType(this.coords.squareCenter);
        sw.translatePosition(-mapWidth / 2.0, -mapHeight / 2.0, 0.0);
        DataDiscretizer highRes = new DataDiscretizer(cellSize);
        DataDiscretizer lowRes = new DataDiscretizer(cellSize * 10.0);
        int numCols = (int)(mapWidth / cellSize);
        int numRows = (int)(mapHeight / cellSize);
        boolean[][] pathHigh = new boolean[numCols][numRows];
        boolean[][] pathLow = new boolean[numCols / 10 + 1][numRows / 10 + 1];
        BufferedImage imgHigh = new BufferedImage(numRows, numCols, 2);
        BufferedImage imgLow = new BufferedImage(numRows / 10, numCols / 10, 2);
        BufferedImage pathImg = new BufferedImage(numRows, numCols, 2);
        NeptusLog.pub().info((Object)I18n.text((String)"no multibeam data has been found... using DVL"));
        LsfIterator it = source.getLsfIndex().getIterator(EstimatedState.class);
        while (it.hasNext()) {
            EstimatedState state = (EstimatedState)it.next();
            LocationType loc = IMCUtils.parseLocation((IMCMessage)state);
            double[] offsets = loc.getOffsetFrom(sw);
            if (offsets[0] < 0.0 || offsets[0] > mapHeight || offsets[1] < 0.0 || offsets[1] > mapWidth) continue;
            int col = (int)(offsets[1] / cellSize);
            int row = (int)(offsets[0] / cellSize);
            pathHigh[col][row] = true;
            pathLow[col / 10][row / 10] = true;
            highRes.addPoint(offsets[1], offsets[0], state.getAlt() + state.getDepth());
            lowRes.addPoint(offsets[1], offsets[0], state.getAlt() + state.getDepth());
            pathImg.setRGB(col, row, Color.blue.darker().getRGB());
        }
        if (DeltaTParser.findDataSource((IMraLogGroup)source) != null) {
            BathymetrySwath swath;
            highRes = new DataDiscretizer(cellSize);
            DeltaTParser parser = new DeltaTParser(source);
            parser.rewind();
            LocationType topLeft = new LocationType(this.coords.squareCenter);
            topLeft.translatePosition(mapHeight / 2.0, -mapWidth / 2.0, 0.0);
            LocationType bottomRight = new LocationType(this.coords.squareCenter);
            bottomRight.translatePosition(-mapHeight / 2.0, mapWidth / 2.0, 0.0);
            while ((swath = parser.nextSwath(0.3)) != null) {
                LocationType loc = swath.getPose().getPosition();
                for (BathymetryPoint bp : swath.getData()) {
                    if (Math.random() < 0.2) continue;
                    LocationType loc2 = new LocationType(loc);
                    if (bp == null) continue;
                    loc2.translatePosition((double)bp.north, (double)bp.east, 0.0);
                    double[] offsets = loc2.getOffsetFrom(sw);
                    if (offsets[0] < 0.0 || offsets[0] > mapHeight || offsets[1] < 0.0 || offsets[1] > mapWidth) continue;
                    highRes.addPoint(offsets[1], offsets[0], (double)bp.depth);
                }
            }
        }
        String dirOut = source.getFile("mra").getAbsolutePath() + "/noptilus";
        ColorMapUtils.generateColorMap((DataDiscretizer.DataPoint[])highRes.getDataPoints(), (Graphics2D)imgHigh.createGraphics(), (double)numRows, (double)numCols, (int)0, (ColorMap)ColorMapFactory.createGrayScaleColorMap());
        ColorMapUtils.generateColorMap((DataDiscretizer.DataPoint[])lowRes.getDataPoints(), (Graphics2D)imgLow.createGraphics(), (double)(numRows / 10), (double)(numCols / 10), (int)0, (ColorMap)ColorMapFactory.createGrayScaleColorMap());
        try {
            String desc = "Map centered in " + this.coords.squareCenter.getLatitudeAsPrettyString() + " / " + this.coords.squareCenter.getLongitudeAsPrettyString();
            this.pathToFile(pathHigh, (float)cellSize, new File(dirOut + "/path_highres.txt"), desc);
            this.pathToFile(pathLow, (float)cellSize * 10.0f, new File(dirOut + "/path_lowres.txt"), desc);
            this.ImageToFile(imgHigh, (float)cellSize, new File(dirOut + "/highres.txt"), desc);
            this.ImageToFile(imgLow, (float)cellSize * 10.0f, new File(dirOut + "/lowres.txt"), desc);
            ImageIO.write((RenderedImage)pathImg, "PNG", new File(dirOut + "/path.png"));
            ImageIO.write((RenderedImage)imgHigh, "PNG", new File(dirOut + "/highres.png"));
            ImageIO.write((RenderedImage)imgLow, "PNG", new File(dirOut + "/lowres.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getClass().getSimpleName() + "  while generating maps: " + e.getMessage();
        }
        return "Map files saved in " + dirOut;
    }

    public void pathToFile(boolean[][] path, float resolution, File out, String desc) throws Exception {
        out.getParentFile().mkdirs();
        int numRows = path.length;
        int numCols = path[0].length;
        BufferedWriter bw = new BufferedWriter(new FileWriter(out));
        bw.write("# Path generated by Neptus MRA\n");
        bw.write("# " + desc + "\n");
        bw.write("# <num cols> <num rows> <cell size> <?> <?>\n");
        bw.write(numCols + " " + numRows + " " + resolution + " 0 0\n\n");
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < numCols; ++col) {
                if (path[col][row]) {
                    bw.write(49);
                } else {
                    bw.write(48);
                }
                if (col == numCols - 1) {
                    bw.write(10);
                    continue;
                }
                bw.write(32);
            }
        }
        bw.close();
    }

    public void ImageToFile(BufferedImage img, float resolution, File out, String desc) throws Exception {
        out.getParentFile().mkdirs();
        BufferedWriter bw = new BufferedWriter(new FileWriter(out));
        bw.write("# Map generated by Neptus MRA\n");
        bw.write("# " + desc + "\n");
        bw.write("# <num cols> <num rows> <cell size> <?> <?>\n");
        bw.write(img.getWidth() + " " + img.getHeight() + " " + resolution + " 0 0\n\n");
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                int val = (img.getRGB(x, y) & 0xFF00) >> 8;
                double value = (double)(val * 20) / 255.0;
                bw.write((float)value + " ");
            }
            bw.write("\n");
        }
        bw.close();
    }

    public DefaultProperty[] getProperties() {
        return this.coords.getProperties();
    }

    public String getPropertiesDialogTitle() {
        return this.coords.getPropertiesDialogTitle();
    }

    public String[] getPropertiesErrors(Property[] properties) {
        return null;
    }

    public void setProperties(Property[] properties) {
        PluginUtils.setPluginProperties((Object)this.coords, (Property[])properties);
    }

    public String getName() {
        return "Normalized map";
    }
}

