/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.noptilus;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import pt.lsts.imc.FollowPath;
import pt.lsts.imc.Goto;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.PlanSpecification;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.noptilus.LandmarkReplay;
import pt.lsts.neptus.plugins.noptilus.PlanUtils;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.GuiUtils;

@PluginDescription(name="Noptilus Plan Generation", author="Noptilus")
public class NoptilusPlanGenerator
extends ConsolePanel
implements Renderer2DPainter {
    private static final long serialVersionUID = 1L;
    @NeptusProperty(name="Multiplication factor")
    public double multFactor = 1.0;
    @NeptusProperty(name="Addition factor")
    public double addFactor = 0.0;
    @NeptusProperty(name="Use FollowPath maneuver")
    public boolean useFollowPath = false;
    @NeptusProperty(name="Minimum distance between waypoints")
    public double minDistance = 0.0;
    @NeptusProperty(name="Plan Speed")
    public double speed = 1000.0;
    @NeptusProperty(name="Speed Units")
    public Goto.SPEED_UNITS units = Goto.SPEED_UNITS.RPM;
    @NeptusProperty(name="Waypoints folder", editable=true)
    public String defaultFolder = ".";
    @NeptusProperty(name="Show generated message")
    public boolean showMessage = false;
    @NeptusProperty(name="Replay interval in milliseconds")
    public long replayTimestep = 500L;
    protected Vector<LocationType> landmarkPositions = new Vector();
    protected Vector<Color> landmarkColors = new Vector();
    protected LandmarkReplay replay = null;

    public NoptilusPlanGenerator(ConsoleLayout console) {
        super(console);
        this.setVisibility(false);
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (this.replay != null) {
            this.replay.paint(g, renderer);
        }
    }

    public void initSubPanel() {
        this.addMenuItem("Noptilus>Plan Generation>Generate plan", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(NoptilusPlanGenerator.this.defaultFolder);
                chooser.setDialogTitle("Open waypoints file");
                int option = chooser.showOpenDialog((Component)NoptilusPlanGenerator.this.getConsole());
                if (option == 0) {
                    File selection = chooser.getSelectedFile();
                    NoptilusPlanGenerator.this.defaultFolder = selection.getParent();
                    try {
                        Vector<double[]> waypoints = PlanUtils.loadWaypoints(selection);
                        PlanUtils.normalizeZ(waypoints, NoptilusPlanGenerator.this.multFactor, NoptilusPlanGenerator.this.addFactor);
                        if (NoptilusPlanGenerator.this.minDistance > 0.0) {
                            PlanUtils.filterShortDistances(waypoints, NoptilusPlanGenerator.this.minDistance);
                        }
                        String plan_id = JOptionPane.showInputDialog((Component)NoptilusPlanGenerator.this.getConsole(), "Enter desired plan id", "generated_plan");
                        PlanSpecification spec = NoptilusPlanGenerator.this.useFollowPath ? PlanUtils.trajectoryPlan(plan_id, waypoints, NoptilusPlanGenerator.this.speed, FollowPath.SPEED_UNITS.valueOf((String)NoptilusPlanGenerator.this.units.toString())) : PlanUtils.planFromWaypoints(plan_id, waypoints, NoptilusPlanGenerator.this.speed, NoptilusPlanGenerator.this.units);
                        if (NoptilusPlanGenerator.this.showMessage) {
                            JFrame frm = GuiUtils.testFrame((JComponent)new JScrollPane(new JLabel(IMCUtils.getAsHtml((IMCMessage)spec))));
                            frm.setDefaultCloseOperation(2);
                        }
                        PlanType plan = IMCUtils.parsePlanSpecification((MissionType)NoptilusPlanGenerator.this.getConsole().getMission(), (IMCMessage)spec);
                        plan.setVehicle(NoptilusPlanGenerator.this.getConsole().getMainSystem());
                        NoptilusPlanGenerator.this.getConsole().getMission().addPlan(plan);
                        NoptilusPlanGenerator.this.getConsole().warnMissionListeners();
                        NoptilusPlanGenerator.this.getConsole().setPlan(plan);
                        NoptilusPlanGenerator.this.getConsole().getMission().save(false);
                    }
                    catch (Exception ex) {
                        GuiUtils.errorMessage((Component)NoptilusPlanGenerator.this.getConsole(), (Exception)ex);
                        return;
                    }
                }
            }
        });
        this.addMenuItem("Noptilus>Plan Generation>Settings", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesEditor.editProperties((PropertiesProvider)NoptilusPlanGenerator.this, (boolean)true);
                NoptilusPlanGenerator.this.getConsole().saveFile();
            }
        });
        this.addMenuItem("Noptilus>Plan Generation>Load Landmarks", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(NoptilusPlanGenerator.this.defaultFolder);
                chooser.setDialogTitle("Open landmarks file");
                int option = chooser.showOpenDialog((Component)NoptilusPlanGenerator.this.getConsole());
                if (option == 0) {
                    File landmarksFile = chooser.getSelectedFile();
                    File replayFile = new File(chooser.getSelectedFile().getAbsolutePath().replace("_Positions", "_State"));
                    if (!replayFile.canRead()) {
                        replayFile = null;
                    }
                    if (NoptilusPlanGenerator.this.replay != null) {
                        NoptilusPlanGenerator.this.replay.cleanup();
                    }
                    try {
                        NoptilusPlanGenerator.this.replay = new LandmarkReplay(landmarksFile, replayFile, NoptilusPlanGenerator.this.replayTimestep);
                    }
                    catch (Exception ex) {
                        GuiUtils.errorMessage((Component)NoptilusPlanGenerator.this.getConsole(), (Exception)ex);
                    }
                    NeptusLog.pub().info((Object)("<###> " + NoptilusPlanGenerator.this.replay));
                }
            }
        });
    }

    public void cleanSubPanel() {
    }
}

