/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.noptilus;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;
import pt.lsts.imc.FollowPath;
import pt.lsts.imc.Goto;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.PathPoint;
import pt.lsts.imc.PlanSpecification;
import pt.lsts.imc.types.PlanSpecificationAdapter;
import pt.lsts.neptus.types.coord.LocationType;

public class PlanUtils {
    public static Vector<double[]> loadWaypoints(File inFile) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(inFile));
        String line = reader.readLine();
        Vector<double[]> locs = new Vector<double[]>();
        while (line != null) {
            line = line.trim();
            line = line.replaceAll("\\s+", "\t");
            String[] parts = line.trim().split("\\t");
            double[] loc = new double[]{Double.parseDouble(parts[0]), Double.parseDouble(parts[1]), Double.parseDouble(parts[2])};
            locs.add(loc);
            line = reader.readLine();
        }
        reader.close();
        return locs;
    }

    public static void normalizeZ(Vector<double[]> points, double multFactor, double addFactor) {
        for (int i = 0; i < points.size(); ++i) {
            points.get((int)i)[2] = points.get(i)[2] * multFactor + addFactor;
        }
    }

    public static void filterShortDistances(Vector<double[]> points, double minDistance) {
        LocationType previousManeuver = null;
        Vector<double[]> filtered = new Vector<double[]>();
        for (double[] pt : points) {
            LocationType loc = new LocationType(pt[0], pt[1]);
            loc.setAbsoluteDepth(pt[2]);
            if (previousManeuver != null && !(loc.getDistanceInMeters(previousManeuver) > minDistance)) continue;
            filtered.add(pt);
            previousManeuver = loc;
        }
        points.clear();
        points.addAll(filtered);
    }

    public static PlanSpecification trajectoryPlan(String plan_id, Vector<double[]> lld_locations, double speed, FollowPath.SPEED_UNITS units) {
        FollowPath maneuver = new FollowPath();
        LocationType firstLoc = new LocationType(lld_locations.get(0)[0], lld_locations.get(0)[1]);
        maneuver.setLat(firstLoc.getLatitudeRads());
        maneuver.setLon(firstLoc.getLongitudeRads());
        maneuver.setSpeed(speed);
        maneuver.setSpeedUnits(units);
        Vector<PathPoint> points = new Vector<PathPoint>();
        for (int i = 0; i < lld_locations.size(); ++i) {
            PathPoint point = new PathPoint();
            LocationType curLoc = new LocationType(lld_locations.get(i)[0], lld_locations.get(i)[1]);
            curLoc.setAbsoluteDepth(lld_locations.get(i)[2]);
            double[] offsets = curLoc.getOffsetFrom(firstLoc);
            point.setX(offsets[0]);
            point.setY(offsets[1]);
            point.setZ(offsets[2]);
            points.add(point);
        }
        maneuver.setPoints(points);
        PlanSpecificationAdapter plan = new PlanSpecificationAdapter();
        plan.setPlanId(plan_id);
        plan.addManeuver("path", (IMCMessage)maneuver);
        plan.setDescription("Trajectory plan generated from a list of waypoints");
        return (PlanSpecification)plan.getData(IMCDefinition.getInstance());
    }

    public static PlanSpecification planFromWaypoints(String plan_id, Vector<double[]> lld_locations, double speed, Goto.SPEED_UNITS units) {
        int i;
        Vector<Goto> maneuvers = new Vector<Goto>();
        PlanSpecificationAdapter plan = new PlanSpecificationAdapter();
        plan.setPlanId(plan_id);
        plan.setDescription("Plan generated from a list of waypoints");
        for (i = 0; i < lld_locations.size(); ++i) {
            Goto gotoManeuver = new Goto();
            gotoManeuver.setLat(Math.toRadians(lld_locations.get(i)[0]));
            gotoManeuver.setLon(Math.toRadians(lld_locations.get(i)[1]));
            gotoManeuver.setZ(lld_locations.get(i)[2]);
            gotoManeuver.setSpeed(speed);
            gotoManeuver.setSpeedUnits(units);
            maneuvers.add(gotoManeuver);
            plan.addManeuver("" + (i + 1), (IMCMessage)gotoManeuver);
        }
        for (i = 1; i < maneuvers.size(); ++i) {
            plan.addTransition("" + i, "" + (i + 1), "ManeuverIsDone", null);
        }
        return (PlanSpecification)plan.getData(IMCDefinition.getInstance());
    }
}

