/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.noptilus;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Random;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.LblBeacon;
import pt.lsts.imc.LblConfig;
import pt.lsts.imc.LblRangeAcceptance;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

@PluginDescription(name="Transponder Location Estimation", author="Noptilus")
public class TransponderEstimation
extends ConsolePanel
implements Renderer2DPainter {
    private static final long serialVersionUID = 1L;
    @NeptusProperty(name="Logs folder", editable=true)
    public String logsFolder = ".";
    @NeptusProperty(name="Number of iterations")
    public int numIterations = 10000;
    @NeptusProperty(name="Distance treshold")
    public double dropDistance = 100.0;
    protected LinkedHashMap<String, LocationType> estimations = new LinkedHashMap();
    protected JMenuItem calcMenu = null;
    protected JMenuItem settingsMenu = null;
    public static final int TIME = 0;
    public static final int X = 1;
    public static final int Y = 2;
    public static final int Z = 3;
    public static final int RANGE = 4;

    public TransponderEstimation(ConsoleLayout console) {
        super(console);
        this.setVisibility(false);
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        for (String name : this.estimations.keySet()) {
            LocationType loc = this.estimations.get(name);
            Point2D pt = renderer.getScreenPosition(loc);
            g.setColor(Color.green.brighter());
            g.drawString(name, (int)pt.getX() + 10, (int)pt.getY());
            g.draw(new Line2D.Double(pt.getX() - 3.0, pt.getY() - 3.0, pt.getX() + 3.0, pt.getY() + 3.0));
            g.draw(new Line2D.Double(pt.getX() + 3.0, pt.getY() - 3.0, pt.getX() - 3.0, pt.getY() + 3.0));
        }
    }

    public void initSubPanel() {
        this.calcMenu = this.addMenuItem("Noptilus>Transponder Estimation>Calculate", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(TransponderEstimation.this.logsFolder);
                chooser.setDialogTitle("Open surface log file");
                int option = chooser.showOpenDialog((Component)TransponderEstimation.this.getConsole());
                if (option == 0) {
                    File selection = chooser.getSelectedFile();
                    TransponderEstimation.this.logsFolder = selection.getParent();
                    try {
                        TransponderEstimation.this.getRanges(selection);
                    }
                    catch (Exception ex) {
                        GuiUtils.errorMessage((Component)TransponderEstimation.this.getConsole(), (Exception)ex);
                    }
                }
            }
        });
        this.settingsMenu = this.addMenuItem("Noptilus>Transponder Estimation>Settings", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesEditor.editProperties((PropertiesProvider)TransponderEstimation.this, (boolean)true);
            }
        });
    }

    public void getRanges(File lsfFile) throws Exception {
        EstimatedState state;
        LsfIndex index = new LsfIndex(lsfFile, new IMCDefinition((InputStream)new FileInputStream(new File(lsfFile.getParent(), "IMC.xml"))));
        LinkedHashMap ranges = new LinkedHashMap();
        LinkedHashMap<Short, double[]> beaconLocations = new LinkedHashMap<Short, double[]>();
        LinkedHashMap<Short, String> beaconNames = new LinkedHashMap<Short, String>();
        int curPos = index.getFirstMessageOfType(357);
        while (curPos != -1) {
            int estate;
            LblRangeAcceptance range = LblRangeAcceptance.clone((IMCMessage)index.getMessage(curPos));
            if (!ranges.containsKey(range.getId())) {
                ranges.put(range.getId(), new Vector());
            }
            if ((estate = index.getNextMessageOfType(350, curPos)) != -1) {
                state = EstimatedState.clone((IMCMessage)index.getMessage(estate));
                double[] values = new double[]{range.getTimestamp(), state.getX(), state.getY(), state.getZ(), range.getRange()};
                ((Vector)ranges.get(range.getId())).add(values);
            }
            curPos = index.getNextMessageOfType(357, curPos);
        }
        int lblIndex = index.getFirstMessageOfType(203);
        if (lblIndex == -1) {
            throw new Exception("No LBL configuration found in the log");
        }
        int hrefIndex = index.getFirstMessageOfType(350);
        if (hrefIndex == -1) {
            throw new Exception("No HomeRef found in the log");
        }
        state = EstimatedState.clone((IMCMessage)index.getMessage(hrefIndex));
        LocationType homeLoc = new LocationType(Math.toDegrees(state.getLat()), Math.toDegrees(state.getLon()));
        LblConfig lblConfig = LblConfig.clone((IMCMessage)index.getMessage(lblIndex));
        Vector beacons = lblConfig.getBeacons();
        for (short i = 0; i < beacons.size(); i = (short)((short)(i + 1))) {
            LblBeacon beacon;
            if (beacons.get(i) == null || (beacon = (LblBeacon)beacons.get(i)) == null) continue;
            LocationType loc = new LocationType(Math.toDegrees(beacon.getLat()), Math.toDegrees(beacon.getLon()));
            loc.setAbsoluteDepth(beacon.getDepth());
            beaconLocations.put(i, loc.getOffsetFrom(homeLoc));
            beaconNames.put(i, beacon.getBeacon());
        }
        JTabbedPane tabs = new JTabbedPane();
        for (Short key : ranges.keySet()) {
            Vector vec = (Vector)ranges.get(key);
            Object[][] values = new Object[vec.size()][5];
            for (int i = 0; i < vec.size(); ++i) {
                for (int j = 0; j < 5; ++j) {
                    values[i][j] = ((double[])vec.get(i))[j];
                }
            }
            DefaultTableModel model = new DefaultTableModel(values, new String[]{"time", "x", "y", "z", "range"});
            JTable table = new JTable(model);
            JScrollPane scroll = new JScrollPane(table);
            tabs.addTab("Beacon " + key, scroll);
        }
        Random rand = new Random(System.currentTimeMillis());
        Iterator i$ = beaconNames.keySet().iterator();
        while (i$.hasNext()) {
            long beacon = ((Short)i$.next()).shortValue();
            double[] estimate = Arrays.copyOf((double[])beaconLocations.get(beacon), ((double[])beaconLocations.get(beacon)).length);
            double[] bestEstimate = Arrays.copyOf(estimate, estimate.length);
            Vector measurements = (Vector)ranges.get(beacon);
            if (measurements == null) continue;
            int N = measurements.size();
            double bestR = Double.MAX_VALUE;
            for (int k = 0; k < this.numIterations; ++k) {
                int i;
                double r = 0.0;
                for (i = 0; i < measurements.size(); ++i) {
                    double Px = ((double[])measurements.get(i))[1];
                    double Py = ((double[])measurements.get(i))[2];
                    double Pz = ((double[])measurements.get(i))[3];
                    double val1 = Math.sqrt((Px - estimate[0]) * (Px - estimate[0]) + (Py - estimate[1]) * (Py - estimate[1]) + (Pz - estimate[2]) * (Pz - estimate[2]));
                    double val2 = ((double[])measurements.get(i))[4];
                    r += Math.abs(val1 - val2);
                }
                if ((r /= (double)N) < bestR) {
                    bestEstimate = Arrays.copyOf(estimate, estimate.length);
                    bestR = r;
                }
                for (i = 0; i < 3; ++i) {
                    estimate[i] = bestEstimate[i] + rand.nextGaussian() * Math.sqrt(bestR);
                }
            }
            LocationType loc = new LocationType(homeLoc);
            loc.translatePosition(bestEstimate);
            this.estimations.put((String)beaconNames.get(beacon), loc);
        }
        JMenu menu = this.getConsole().getOrCreateJMenu(new String[]{"Noptilus", "Transponder Estimation"});
        menu.removeAll();
        menu.add(this.calcMenu);
        menu.add(this.settingsMenu);
        for (String beaconName : this.estimations.keySet()) {
            final LocationType loc = this.estimations.get(beaconName);
            loc.setId(beaconName);
            JMenuItem item = new JMenuItem("Copy " + beaconName + " location");
            item.setToolTipText(loc.getLatitudeAsPrettyString() + " / " + loc.getLongitudeAsPrettyString() + " / " + loc.getAllZ());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClipboardOwner owner = new ClipboardOwner(){

                        @Override
                        public void lostOwnership(Clipboard clipboard, Transferable contents) {
                        }
                    };
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(loc.getClipboardText()), owner);
                }
            });
            item.setActionCommand("copy " + beaconName);
            menu.add(item);
        }
        JMenuItem clear = new JMenuItem("Clear");
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenu menu = TransponderEstimation.this.getConsole().getOrCreateJMenu(new String[]{"Noptilus", "Transponder Estimation"});
                TransponderEstimation.this.estimations.clear();
                menu.removeAll();
                menu.add(TransponderEstimation.this.calcMenu);
                menu.add(TransponderEstimation.this.settingsMenu);
            }
        });
        menu.add(clear);
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        TransponderEstimation est = new TransponderEstimation(null);
        JFileChooser chooser = new JFileChooser(".");
        chooser.setDialogTitle("Open surface log file");
        int option = chooser.showOpenDialog(null);
        if (option == 0) {
            File selection = chooser.getSelectedFile();
            try {
                est.getRanges(selection);
            }
            catch (Exception ex) {
                GuiUtils.errorMessage(null, (Exception)ex);
                ex.printStackTrace();
            }
        }
    }

    public void cleanSubPanel() {
    }
}

