/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.xmsf.dis.impl.runtime;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.web3d.xmsf.dis.impl.runtime.GrammarInfo;
import org.web3d.xmsf.dis.impl.runtime.UnmarshallableObject;
import org.web3d.xmsf.dis.impl.runtime.UnmarshallingContext;
import org.web3d.xmsf.dis.impl.runtime.UnmarshallingEventHandler;
import org.web3d.xmsf.dis.impl.runtime.XMLSerializable;

public class GrammarInfoImpl
implements GrammarInfo {
    private final Map rootTagMap;
    private final Class objectFactoryClass;
    private final Map defaultImplementationMap;
    private final ClassLoader classLoader;

    public GrammarInfoImpl(Map map, Map map2, Class clazz) {
        this.rootTagMap = map;
        this.defaultImplementationMap = map2;
        this.objectFactoryClass = clazz;
        this.classLoader = this.objectFactoryClass.getClassLoader();
    }

    private final Class lookupRootMap(String string, String string2) {
        QName qName = new QName(string, string2);
        if (this.rootTagMap.containsKey(qName)) {
            return (Class)this.rootTagMap.get(qName);
        }
        qName = new QName(string, "*");
        if (this.rootTagMap.containsKey(qName)) {
            return (Class)this.rootTagMap.get(qName);
        }
        qName = new QName("*", "*");
        return (Class)this.rootTagMap.get(qName);
    }

    public final Class getRootElement(String string, String string2) {
        Class clazz = this.lookupRootMap(string, string2);
        if (clazz == null) {
            return null;
        }
        return this.getDefaultImplementation(clazz);
    }

    public final UnmarshallingEventHandler createUnmarshaller(String string, String string2, UnmarshallingContext unmarshallingContext) {
        Class clazz = this.getRootElement(string, string2);
        if (clazz == null) {
            return null;
        }
        try {
            return ((UnmarshallableObject)clazz.newInstance()).createUnmarshaller(unmarshallingContext);
        }
        catch (InstantiationException instantiationException) {
            throw new InstantiationError(instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.toString());
        }
    }

    public final String[] getProbePoints() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.rootTagMap.keySet().iterator();
        while (iterator.hasNext()) {
            QName qName = (QName)iterator.next();
            arrayList.add(qName.getNamespaceURI());
            arrayList.add(qName.getLocalPart());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public final boolean recognize(String string, String string2) {
        return this.lookupRootMap(string, string2) != null;
    }

    public final Class getDefaultImplementation(Class clazz) {
        try {
            return Class.forName((String)this.defaultImplementationMap.get(clazz), true, this.classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.toString());
        }
    }

    public XMLSerializable castToXMLSerializable(Object object) {
        if (object instanceof XMLSerializable) {
            return (XMLSerializable)object;
        }
        return null;
    }
}

