/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.xmsf.disutil;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.web3d.xmsf.dis.AcknowledgePdu;
import org.web3d.xmsf.dis.AcknowledgePduType;
import org.web3d.xmsf.dis.ArticulationParametersType;
import org.web3d.xmsf.dis.BurstDescriptorType;
import org.web3d.xmsf.dis.ClockType;
import org.web3d.xmsf.dis.CollisionPdu;
import org.web3d.xmsf.dis.CollisionPduType;
import org.web3d.xmsf.dis.CreateEntityPdu;
import org.web3d.xmsf.dis.CreateEntityPduType;
import org.web3d.xmsf.dis.DISType;
import org.web3d.xmsf.dis.DeadReckoningParametersType;
import org.web3d.xmsf.dis.DetonationPdu;
import org.web3d.xmsf.dis.DetonationPduType;
import org.web3d.xmsf.dis.EntityIDType;
import org.web3d.xmsf.dis.EntityMarking;
import org.web3d.xmsf.dis.EntityStatePduType;
import org.web3d.xmsf.dis.EntityType;
import org.web3d.xmsf.dis.EulerAnglesType;
import org.web3d.xmsf.dis.EventIDType;
import org.web3d.xmsf.dis.FirePdu;
import org.web3d.xmsf.dis.FirePduType;
import org.web3d.xmsf.dis.HeaderType;
import org.web3d.xmsf.dis.ProtocolDataUnitType;
import org.web3d.xmsf.dis.RemoveEntityPdu;
import org.web3d.xmsf.dis.RemoveEntityPduType;
import org.web3d.xmsf.dis.StartResumePdu;
import org.web3d.xmsf.dis.StartResumePduType;
import org.web3d.xmsf.dis.StopFreezePdu;
import org.web3d.xmsf.dis.StopFreezePduType;
import org.web3d.xmsf.dis.Vector3Double;
import org.web3d.xmsf.dis.Vector3Float;
import org.web3d.xmsf.disutil.PduFactory;

public class DisMarshaller {
    public static long startupTime = System.currentTimeMillis();

    public void marshallPdus(List list, OutputStream outputStream) throws IOException {
        if (!this.listElementsArePdus(list)) {
            throw new IOException("Not all elements in the list are subclasses of ProtocolDataUnitType");
        }
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((String)"org.web3d.xmsf.dis");
            PduFactory pduFactory = new PduFactory();
            DISType dISType = pduFactory.getDIS();
            List list2 = dISType.getAcknowledgePduOrActionRequestPduOrActionResponsePdu();
            list2.addAll(list);
            Marshaller marshaller = jAXBContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)dISType, outputStream);
        }
        catch (Exception exception) {
            throw new IOException("Unable to write DIS objects to output stream in XML format");
        }
    }

    public void marshallPdus(List list, String string) throws IOException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            this.marshallPdus(list, fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new IOException("Unable to open file to write Java DIS objects to XML");
        }
    }

    private boolean listElementsArePdus(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof ProtocolDataUnitType) continue;
            return false;
        }
        return true;
    }

    public byte[] marshallPduToSend(ProtocolDataUnitType protocolDataUnitType) {
        long l = System.currentTimeMillis();
        protocolDataUnitType.getPduHeader().setTimestamp((int)(l - startupTime));
        return this.marshallPdu(protocolDataUnitType);
    }

    public byte[] marshallPdu(ProtocolDataUnitType protocolDataUnitType) {
        switch (protocolDataUnitType.getPduHeader().getPduType()) {
            case 1: {
                return this.marshallEntityStatePdu((EntityStatePduType)protocolDataUnitType);
            }
            case 2: {
                return this.marshallFirePdu((FirePdu)protocolDataUnitType);
            }
            case 3: {
                return this.marshallDetonationPdu((DetonationPdu)protocolDataUnitType);
            }
            case 4: {
                return this.marshallCollisionPdu((CollisionPdu)protocolDataUnitType);
            }
            case 5: {
                return this.marshallCreateEntityPdu((CreateEntityPdu)protocolDataUnitType);
            }
            case 6: {
                return this.marshallRemoveEntityPdu((RemoveEntityPdu)protocolDataUnitType);
            }
            case 7: {
                return this.marshallStartResumePdu((StartResumePdu)protocolDataUnitType);
            }
            case 8: {
                return this.marshallStopFreezePdu((StopFreezePdu)protocolDataUnitType);
            }
            case 9: {
                return this.marshallAcknowledgePdu((AcknowledgePdu)protocolDataUnitType);
            }
        }
        System.out.println("Unrecognized PDU type, " + protocolDataUnitType.getPduHeader().getPduType());
        return null;
    }

    public byte[] marshallEntityStatePdu(EntityStatePduType entityStatePduType) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.serializePduHeader(entityStatePduType.getPduHeader(), dataOutputStream);
            this.serializeEntityID(entityStatePduType.getEntityID(), dataOutputStream);
            dataOutputStream.writeByte(entityStatePduType.getForceID());
            dataOutputStream.writeByte(entityStatePduType.getNumberOfArticulationParameters());
            this.serializeEntityType(entityStatePduType.getEntity(), dataOutputStream);
            this.serializeEntityType(entityStatePduType.getAlternativeEntity(), dataOutputStream);
            this.serializeVector3Float(entityStatePduType.getEntityLinearVelocity(), dataOutputStream);
            this.serializeVector3Double(entityStatePduType.getEntityLocation(), dataOutputStream);
            this.serializeEulerAnglesType(entityStatePduType.getEntityOrientation(), dataOutputStream);
            dataOutputStream.writeInt(entityStatePduType.getEntityAppearance());
            this.serializeDeadReckoningParameters(entityStatePduType.getDeadReckoningParameters(), dataOutputStream);
            this.serializeMarking(entityStatePduType.getEntityMarking(), dataOutputStream);
            dataOutputStream.writeInt(entityStatePduType.getCapabilities());
            this.serializeArticulationParameters(entityStatePduType.getArticulationParameters(), dataOutputStream);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    public byte[] marshallFirePdu(FirePduType firePduType) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.serializePduHeader(firePduType.getPduHeader(), dataOutputStream);
            this.serializeEntityID(firePduType.getFiringEntityID(), dataOutputStream);
            this.serializeEntityID(firePduType.getTargetEntityID(), dataOutputStream);
            this.serializeEntityID(firePduType.getMunitionID(), dataOutputStream);
            this.serializeEventID(firePduType.getEventID(), dataOutputStream);
            dataOutputStream.writeInt(firePduType.getFireMissionIndex());
            this.serializeVector3Double(firePduType.getLocationInWorldCoordinates(), dataOutputStream);
            this.serializeBurstDescriptor(firePduType.getBurstDescriptor(), dataOutputStream);
            this.serializeVector3Float(firePduType.getVelocity(), dataOutputStream);
            dataOutputStream.writeFloat(firePduType.getRange());
        }
        catch (Exception exception) {
            System.out.println("Problem marshalling Fire PDU " + exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] marshallDetonationPdu(DetonationPduType detonationPduType) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.serializePduHeader(detonationPduType.getPduHeader(), dataOutputStream);
            this.serializeEntityID(detonationPduType.getFiringEntityID(), dataOutputStream);
            this.serializeEntityID(detonationPduType.getTargetEntityID(), dataOutputStream);
            this.serializeEntityID(detonationPduType.getMunitionID(), dataOutputStream);
            this.serializeEventID(detonationPduType.getEventID(), dataOutputStream);
            this.serializeVector3Float(detonationPduType.getVelocity(), dataOutputStream);
            this.serializeVector3Double(detonationPduType.getLocationInWorldCoordinates(), dataOutputStream);
            this.serializeBurstDescriptor(detonationPduType.getBurstDescriptor(), dataOutputStream);
            this.serializeVector3Float(detonationPduType.getLocationInEntityCoordinates(), dataOutputStream);
            dataOutputStream.writeByte(detonationPduType.getDetonationResult());
            dataOutputStream.writeByte(detonationPduType.getNumberOfArticulationParameters());
            dataOutputStream.writeShort(0);
        }
        catch (Exception exception) {
            System.out.println("Problem marshalling Fire PDU " + exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] marshallCollisionPdu(CollisionPduType collisionPduType) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.serializePduHeader(collisionPduType.getPduHeader(), dataOutputStream);
            this.serializeEntityID(collisionPduType.getIssuingEntityID(), dataOutputStream);
            this.serializeEntityID(collisionPduType.getCollidingEntityID(), dataOutputStream);
            this.serializeEventID(collisionPduType.getEventID(), dataOutputStream);
            dataOutputStream.writeByte(collisionPduType.getCollisionType());
            dataOutputStream.writeByte(collisionPduType.getPadding());
            this.serializeVector3Float(collisionPduType.getVelocity(), dataOutputStream);
            dataOutputStream.writeFloat(collisionPduType.getMass());
            this.serializeVector3Float(collisionPduType.getLocationWithRespectToEntity(), dataOutputStream);
        }
        catch (Exception exception) {
            System.out.println("Problem marshalling Fire PDU " + exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] marshallCreateEntityPdu(CreateEntityPduType createEntityPduType) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.serializePduHeader(createEntityPduType.getPduHeader(), dataOutputStream);
            this.serializeEntityID(createEntityPduType.getOriginatingEntityID(), dataOutputStream);
            this.serializeEntityID(createEntityPduType.getReceivingEntityID(), dataOutputStream);
            dataOutputStream.writeInt((int)createEntityPduType.getRequestID());
        }
        catch (Exception exception) {
            System.out.println("Problem marshalling Create Entity PDU " + exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] marshallRemoveEntityPdu(RemoveEntityPduType removeEntityPduType) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.serializePduHeader(removeEntityPduType.getPduHeader(), dataOutputStream);
            this.serializeEntityID(removeEntityPduType.getOriginatingEntityID(), dataOutputStream);
            this.serializeEntityID(removeEntityPduType.getReceivingEntityID(), dataOutputStream);
            dataOutputStream.writeInt((int)removeEntityPduType.getRequestID());
        }
        catch (Exception exception) {
            System.out.println("Problem marshalling Remove Entity PDU " + exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] marshallStartResumePdu(StartResumePduType startResumePduType) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.serializePduHeader(startResumePduType.getPduHeader(), dataOutputStream);
            this.serializeEntityID(startResumePduType.getOriginatingEntityID(), dataOutputStream);
            this.serializeEntityID(startResumePduType.getReceivingEntityID(), dataOutputStream);
            this.serializeClockType(startResumePduType.getRealWorldTime(), dataOutputStream);
            this.serializeClockType(startResumePduType.getSimulationTime(), dataOutputStream);
            dataOutputStream.writeInt((int)startResumePduType.getRequestID());
        }
        catch (Exception exception) {
            System.out.println("Problem marshalling start/resume PDU " + exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] marshallStopFreezePdu(StopFreezePduType stopFreezePduType) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.serializePduHeader(stopFreezePduType.getPduHeader(), dataOutputStream);
            this.serializeEntityID(stopFreezePduType.getOriginatingEntityID(), dataOutputStream);
            this.serializeEntityID(stopFreezePduType.getReceivingEntityID(), dataOutputStream);
            this.serializeClockType(stopFreezePduType.getRealWorldTime(), dataOutputStream);
            dataOutputStream.writeByte(stopFreezePduType.getReason());
            dataOutputStream.writeByte(stopFreezePduType.getFrozenBehavior());
            dataOutputStream.writeShort(stopFreezePduType.getPadding());
            dataOutputStream.writeInt((int)stopFreezePduType.getRequestID());
        }
        catch (Exception exception) {
            System.out.println("Problem marshalling stop/freeze PDU " + exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] marshallAcknowledgePdu(AcknowledgePduType acknowledgePduType) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.serializePduHeader(acknowledgePduType.getPduHeader(), dataOutputStream);
            this.serializeEntityID(acknowledgePduType.getOriginatingEntityID(), dataOutputStream);
            this.serializeEntityID(acknowledgePduType.getReceivingEntityID(), dataOutputStream);
            dataOutputStream.writeShort(acknowledgePduType.getAcknowledgeFlag());
            dataOutputStream.writeShort(acknowledgePduType.getResponseFlag());
            dataOutputStream.writeInt((int)acknowledgePduType.getRequestID());
        }
        catch (Exception exception) {
            System.out.println("Problem marshalling Acknowledge PDU " + exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void serializePduHeader(HeaderType headerType, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeByte(headerType.getProtocolVersion());
            dataOutputStream.writeByte((byte)headerType.getExerciseID());
            dataOutputStream.writeByte(headerType.getPduType());
            dataOutputStream.writeByte(headerType.getProtocolFamily());
            dataOutputStream.writeInt((int)headerType.getTimestamp());
            dataOutputStream.writeShort(headerType.getLength());
            dataOutputStream.writeShort(headerType.getPadding());
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void serializeClockType(ClockType clockType, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeInt(clockType.getHour());
            dataOutputStream.writeInt((int)clockType.getTimePastHour());
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void serializeEntityID(EntityIDType entityIDType, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeShort(entityIDType.getSite());
            dataOutputStream.writeShort(entityIDType.getApplication());
            dataOutputStream.writeShort(entityIDType.getEntity());
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void serializeEventID(EventIDType eventIDType, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeShort(eventIDType.getSite());
            dataOutputStream.writeShort(eventIDType.getApplication());
            dataOutputStream.writeShort(eventIDType.getEventNumber());
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void serializeEntityType(EntityType entityType, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeByte(entityType.getEntityKind());
            dataOutputStream.writeByte(entityType.getDomain());
            dataOutputStream.writeShort(entityType.getCountry());
            dataOutputStream.writeByte(entityType.getCategory());
            dataOutputStream.writeByte(entityType.getSubCategory());
            dataOutputStream.writeByte(entityType.getSpecific());
            dataOutputStream.writeByte(entityType.getExtra());
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private void serializeVector3Float(Vector3Float vector3Float, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeFloat(vector3Float.getX());
            dataOutputStream.writeFloat(vector3Float.getY());
            dataOutputStream.writeFloat(vector3Float.getZ());
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private void serializeVector3Double(Vector3Double vector3Double, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeDouble(vector3Double.getX());
            dataOutputStream.writeDouble(vector3Double.getY());
            dataOutputStream.writeDouble(vector3Double.getZ());
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private void serializeEulerAnglesType(EulerAnglesType eulerAnglesType, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeFloat(eulerAnglesType.getPsi());
            dataOutputStream.writeFloat(eulerAnglesType.getTheta());
            dataOutputStream.writeFloat(eulerAnglesType.getPhi());
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private void serializeDeadReckoningParameters(DeadReckoningParametersType deadReckoningParametersType, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeByte(deadReckoningParametersType.getDeadReckoningAlgorithm());
            byte[] byArray = deadReckoningParametersType.getOtherParameters();
            for (int i = 0; i < byArray.length; ++i) {
                dataOutputStream.writeByte(byArray[i]);
            }
            this.serializeVector3Float(deadReckoningParametersType.getEntityLinearAcceleration(), dataOutputStream);
            this.serializeVector3Float(deadReckoningParametersType.getEntityAngularVelocity(), dataOutputStream);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private void serializeMarking(EntityMarking entityMarking, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeByte(entityMarking.getCharacterSet());
            byte[] byArray = entityMarking.getCharacters();
            for (int i = 0; i < byArray.length; ++i) {
                dataOutputStream.writeByte(byArray[i]);
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private void serializeBurstDescriptor(BurstDescriptorType burstDescriptorType, DataOutputStream dataOutputStream) {
        try {
            this.serializeEntityType(burstDescriptorType.getMunition(), dataOutputStream);
            dataOutputStream.writeShort(burstDescriptorType.getWarhead());
            dataOutputStream.writeShort(burstDescriptorType.getFuse());
            dataOutputStream.writeShort(burstDescriptorType.getQuantity());
            dataOutputStream.writeShort(burstDescriptorType.getRate());
        }
        catch (Exception exception) {
            System.out.println("Problem writing burst description " + exception);
        }
    }

    private void serializeArticulationParameters(List list, DataOutputStream dataOutputStream) {
        try {
            for (int i = 0; i < list.size(); ++i) {
                ArticulationParametersType articulationParametersType = (ArticulationParametersType)list.get(i);
                dataOutputStream.writeByte(articulationParametersType.getParameterTypeDesignator());
                dataOutputStream.writeShort(articulationParametersType.getChange());
                dataOutputStream.writeShort(articulationParametersType.getIDPartAttachedTo());
                dataOutputStream.writeInt(articulationParametersType.getParameterType());
                dataOutputStream.writeDouble(articulationParametersType.getParameterValue());
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

