/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.xmsf.disutil;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.web3d.xmsf.dis.BurstDescriptorType;
import org.web3d.xmsf.dis.CollisionPdu;
import org.web3d.xmsf.dis.CollisionPduType;
import org.web3d.xmsf.dis.DIS;
import org.web3d.xmsf.dis.DeadReckoningParametersType;
import org.web3d.xmsf.dis.DetonationPdu;
import org.web3d.xmsf.dis.DetonationPduType;
import org.web3d.xmsf.dis.EntityIDType;
import org.web3d.xmsf.dis.EntityStatePdu;
import org.web3d.xmsf.dis.EntityStatePduType;
import org.web3d.xmsf.dis.EntityType;
import org.web3d.xmsf.dis.EulerAnglesType;
import org.web3d.xmsf.dis.EventIDType;
import org.web3d.xmsf.dis.FirePdu;
import org.web3d.xmsf.dis.FirePduType;
import org.web3d.xmsf.dis.HeaderType;
import org.web3d.xmsf.dis.Vector3Double;
import org.web3d.xmsf.dis.Vector3Float;
import org.web3d.xmsf.disutil.PduFactory;

public class DisUnmarshaller1995 {
    public List unmarshallFromXML(InputStream inputStream) throws IOException {
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((String)"org.web3d.xmsf.dis");
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            DIS dIS = (DIS)unmarshaller.unmarshal(inputStream);
            return dIS.getAcknowledgePduOrActionRequestPduOrActionResponsePdu();
        }
        catch (Exception exception) {
            throw new IOException("Unable to read XML from input stream");
        }
    }

    public List unmarshallFromXML(String string) throws IOException {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            List list = this.unmarshallFromXML(fileInputStream);
            fileInputStream.close();
            return list;
        }
        catch (Exception exception) {
            throw new IOException("Unable to read DIS-XML correctly from file " + string);
        }
    }

    public EntityStatePdu unmarshallEntityStatePdu(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        PduFactory pduFactory = new PduFactory();
        EntityStatePduType entityStatePduType = pduFactory.getEntityStatePdu();
        try {
            this.deserializePduHeader(entityStatePduType.getPduHeader(), dataInputStream);
            this.deserializeEntityID(entityStatePduType.getEntityID(), dataInputStream);
            entityStatePduType.setForceID(dataInputStream.readByte());
            entityStatePduType.setNumberOfArticulationParameters(dataInputStream.readByte());
            this.deserializeEntityType(entityStatePduType.getEntity(), dataInputStream);
            this.deserializeEntityType(entityStatePduType.getAlternativeEntity(), dataInputStream);
            this.deserializeVector3Float(entityStatePduType.getEntityLinearVelocity(), dataInputStream);
            this.deserializeVector3Double(entityStatePduType.getEntityLocation(), dataInputStream);
            this.deserializeEulerAnglesType(entityStatePduType.getEntityOrientation(), dataInputStream);
            entityStatePduType.setEntityAppearance(dataInputStream.readInt());
            this.deserializeDeadReckoningParameters(entityStatePduType.getDeadReckoningParameters(), dataInputStream);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return (EntityStatePdu)entityStatePduType;
    }

    public FirePdu unmarshallFirePdu(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        PduFactory pduFactory = new PduFactory();
        FirePduType firePduType = pduFactory.getFirePdu();
        try {
            this.deserializePduHeader(firePduType.getPduHeader(), dataInputStream);
            this.deserializeEntityID(firePduType.getFiringEntityID(), dataInputStream);
            this.deserializeEntityID(firePduType.getTargetEntityID(), dataInputStream);
            this.deserializeEntityID(firePduType.getMunitionID(), dataInputStream);
            this.deserializeEventID(firePduType.getEventID(), dataInputStream);
            firePduType.setFireMissionIndex(dataInputStream.readInt());
            this.deserializeVector3Double(firePduType.getLocationInWorldCoordinates(), dataInputStream);
            this.deserializeBurstDescriptor(firePduType.getBurstDescriptor(), dataInputStream);
            this.deserializeVector3Float(firePduType.getVelocity(), dataInputStream);
        }
        catch (Exception exception) {
            System.out.println("Problem unmarshalling fire pdu " + exception);
        }
        return (FirePdu)firePduType;
    }

    public DetonationPdu unmarshallDetonationPdu(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        PduFactory pduFactory = new PduFactory();
        DetonationPduType detonationPduType = pduFactory.getDetonationPdu();
        try {
            this.deserializePduHeader(detonationPduType.getPduHeader(), dataInputStream);
            this.deserializeEntityID(detonationPduType.getFiringEntityID(), dataInputStream);
            this.deserializeEntityID(detonationPduType.getTargetEntityID(), dataInputStream);
            this.deserializeEntityID(detonationPduType.getMunitionID(), dataInputStream);
            this.deserializeEventID(detonationPduType.getEventID(), dataInputStream);
            this.deserializeVector3Float(detonationPduType.getVelocity(), dataInputStream);
            this.deserializeVector3Double(detonationPduType.getLocationInWorldCoordinates(), dataInputStream);
            this.deserializeBurstDescriptor(detonationPduType.getBurstDescriptor(), dataInputStream);
            this.deserializeVector3Float(detonationPduType.getLocationInEntityCoordinates(), dataInputStream);
            detonationPduType.setDetonationResult(dataInputStream.readByte());
            detonationPduType.setNumberOfArticulationParameters(dataInputStream.readByte());
            dataInputStream.readShort();
        }
        catch (Exception exception) {
            System.out.println("Problem unmarshalling detonation pdu " + exception);
        }
        return (DetonationPdu)detonationPduType;
    }

    public CollisionPdu unmarshallCollisionPdu(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        PduFactory pduFactory = new PduFactory();
        CollisionPduType collisionPduType = pduFactory.getCollisionPdu();
        try {
            this.deserializePduHeader(collisionPduType.getPduHeader(), dataInputStream);
            this.deserializeEntityID(collisionPduType.getIssuingEntityID(), dataInputStream);
            this.deserializeEntityID(collisionPduType.getCollidingEntityID(), dataInputStream);
            this.deserializeEventID(collisionPduType.getEventID(), dataInputStream);
            collisionPduType.setCollisionType(dataInputStream.readByte());
            collisionPduType.setPadding(dataInputStream.readByte());
            this.deserializeVector3Float(collisionPduType.getVelocity(), dataInputStream);
            collisionPduType.setMass(dataInputStream.readFloat());
            this.deserializeVector3Float(collisionPduType.getLocationWithRespectToEntity(), dataInputStream);
        }
        catch (Exception exception) {
            System.out.println("Problem unmarshalling detonation pdu " + exception);
        }
        return (CollisionPdu)collisionPduType;
    }

    private void deserializePduHeader(HeaderType headerType, DataInputStream dataInputStream) {
        try {
            headerType.setProtocolVersion(dataInputStream.readByte());
            headerType.setExerciseID(dataInputStream.readByte());
            headerType.setPduType(dataInputStream.readByte());
            headerType.setProtocolFamily(dataInputStream.readByte());
            headerType.setTimestamp(dataInputStream.readInt());
            headerType.setLength(dataInputStream.readShort());
            headerType.setPadding((short)0);
            dataInputStream.readShort();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void deserializeEntityID(EntityIDType entityIDType, DataInputStream dataInputStream) {
        try {
            entityIDType.setSite(dataInputStream.readShort());
            entityIDType.setApplication(dataInputStream.readShort());
            entityIDType.setEntity(dataInputStream.readShort());
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void deserializeEventID(EventIDType eventIDType, DataInputStream dataInputStream) {
        try {
            eventIDType.setSite(dataInputStream.readShort());
            eventIDType.setApplication(dataInputStream.readShort());
            eventIDType.setEventNumber(dataInputStream.readShort());
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void deserializeEntityType(EntityType entityType, DataInputStream dataInputStream) {
        try {
            entityType.setEntityKind(dataInputStream.readByte());
            entityType.setDomain(dataInputStream.readByte());
            entityType.setCountry(dataInputStream.readShort());
            entityType.setCategory(dataInputStream.readByte());
            entityType.setSubCategory(dataInputStream.readByte());
            entityType.setSpecific(dataInputStream.readByte());
            entityType.setExtra(dataInputStream.readByte());
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private void deserializeVector3Float(Vector3Float vector3Float, DataInputStream dataInputStream) {
        try {
            vector3Float.setX(dataInputStream.readFloat());
            vector3Float.setY(dataInputStream.readFloat());
            vector3Float.setX(dataInputStream.readFloat());
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private void deserializeVector3Double(Vector3Double vector3Double, DataInputStream dataInputStream) {
        try {
            vector3Double.setX(dataInputStream.readDouble());
            vector3Double.setY(dataInputStream.readDouble());
            vector3Double.setZ(dataInputStream.readDouble());
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private void deserializeEulerAnglesType(EulerAnglesType eulerAnglesType, DataInputStream dataInputStream) {
        try {
            eulerAnglesType.setPsi(dataInputStream.readFloat());
            eulerAnglesType.setTheta(dataInputStream.readFloat());
            eulerAnglesType.setPhi(dataInputStream.readFloat());
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private void deserializeDeadReckoningParameters(DeadReckoningParametersType deadReckoningParametersType, DataInputStream dataInputStream) {
        try {
            deadReckoningParametersType.setDeadReckoningAlgorithm(dataInputStream.readByte());
            byte[] byArray = deadReckoningParametersType.getOtherParameters();
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = dataInputStream.readByte();
            }
            this.deserializeVector3Float(deadReckoningParametersType.getEntityLinearAcceleration(), dataInputStream);
            this.deserializeVector3Float(deadReckoningParametersType.getEntityAngularVelocity(), dataInputStream);
        }
        catch (IOException iOException) {
            System.out.println(iOException + " in deserializeDeadReckoningParameters");
        }
    }

    private void deserializeBurstDescriptor(BurstDescriptorType burstDescriptorType, DataInputStream dataInputStream) {
        try {
            this.deserializeEntityType(burstDescriptorType.getMunition(), dataInputStream);
            burstDescriptorType.setWarhead(dataInputStream.readShort());
            burstDescriptorType.setFuse(dataInputStream.readShort());
            burstDescriptorType.setQuantity(dataInputStream.readShort());
            burstDescriptorType.setRate(dataInputStream.readShort());
        }
        catch (Exception exception) {
            System.out.println("Problem reading burst description " + exception);
        }
    }
}

