/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.xmsf.x3dsai.impl.runtime;

import com.sun.xml.bind.DatatypeConverterImpl;
import com.sun.xml.bind.JAXBAssertionError;
import com.sun.xml.bind.marshaller.CharacterEscapeHandler;
import com.sun.xml.bind.marshaller.DataWriter;
import com.sun.xml.bind.marshaller.DumbEscapeHandler;
import com.sun.xml.bind.marshaller.Messages;
import com.sun.xml.bind.marshaller.MinimumEscapeHandler;
import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import com.sun.xml.bind.marshaller.NioEscapeHandler;
import com.sun.xml.bind.marshaller.SAX2DOMEx;
import com.sun.xml.bind.marshaller.SchemaLocationFilter;
import com.sun.xml.bind.marshaller.XMLWriter;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.helpers.AbstractMarshallerImpl;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.web3d.xmsf.x3dsai.impl.runtime.DefaultJAXBContextImpl;
import org.web3d.xmsf.x3dsai.impl.runtime.SAXMarshaller;
import org.web3d.xmsf.x3dsai.impl.runtime.XMLSerializable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

public class MarshallerImpl
extends AbstractMarshallerImpl {
    private String indent = "    ";
    private NamespacePrefixMapper prefixMapper = null;
    private CharacterEscapeHandler escapeHandler = null;
    private boolean printXmlDeclaration = true;
    private String header = null;
    final DefaultJAXBContextImpl context;
    private static final String INDENT_STRING = "com.sun.xml.bind.indentString";
    private static final String PREFIX_MAPPER = "com.sun.xml.bind.namespacePrefixMapper";
    private static final String ENCODING_HANDLER = "com.sun.xml.bind.characterEscapeHandler";
    private static final String XMLDECLARATION = "com.sun.xml.bind.xmlDeclaration";
    private static final String XML_HEADERS = "com.sun.xml.bind.xmlHeaders";

    public MarshallerImpl(DefaultJAXBContextImpl defaultJAXBContextImpl) {
        DatatypeConverter.setDatatypeConverter((DatatypeConverterInterface)DatatypeConverterImpl.theInstance);
        this.context = defaultJAXBContextImpl;
    }

    public void marshal(Object object, Result result) throws JAXBException {
        XMLSerializable xMLSerializable = this.context.getGrammarInfo().castToXMLSerializable(object);
        if (xMLSerializable == null) {
            throw new MarshalException(Messages.format((String)"MarshallerImpl.NotMarshallable"));
        }
        if (result instanceof SAXResult) {
            this.write(xMLSerializable, ((SAXResult)result).getHandler());
            return;
        }
        if (result instanceof DOMResult) {
            Node node = ((DOMResult)result).getNode();
            if (node == null) {
                try {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setNamespaceAware(true);
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.newDocument();
                    ((DOMResult)result).setNode(document);
                    this.write(xMLSerializable, (ContentHandler)new SAX2DOMEx((Node)document));
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new JAXBAssertionError((Throwable)parserConfigurationException);
                }
            } else {
                this.write(xMLSerializable, (ContentHandler)new SAX2DOMEx(node));
            }
            return;
        }
        if (result instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)result;
            XMLWriter xMLWriter = null;
            if (streamResult.getWriter() != null) {
                xMLWriter = this.createWriter(streamResult.getWriter());
            } else if (streamResult.getOutputStream() != null) {
                xMLWriter = this.createWriter(streamResult.getOutputStream());
            } else if (streamResult.getSystemId() != null) {
                String string = streamResult.getSystemId();
                if (string.startsWith("file:///")) {
                    string = string.substring(8).indexOf(":") > 0 ? string.substring(8) : string.substring(7);
                }
                try {
                    xMLWriter = this.createWriter(new FileOutputStream(string));
                }
                catch (IOException iOException) {
                    throw new MarshalException((Throwable)iOException);
                }
            }
            if (xMLWriter == null) {
                throw new IllegalArgumentException();
            }
            this.write(xMLSerializable, (ContentHandler)xMLWriter);
            return;
        }
        throw new MarshalException(Messages.format((String)"MarshallerImpl.UnsupportedResult"));
    }

    private void write(XMLSerializable xMLSerializable, ContentHandler contentHandler) throws JAXBException {
        try {
            if (this.getSchemaLocation() != null || this.getNoNSSchemaLocation() != null) {
                contentHandler = new SchemaLocationFilter(this.getSchemaLocation(), this.getNoNSSchemaLocation(), contentHandler);
            }
            SAXMarshaller sAXMarshaller = new SAXMarshaller(contentHandler, this.prefixMapper, this);
            contentHandler.setDocumentLocator(new LocatorImpl());
            contentHandler.startDocument();
            xMLSerializable.serializeBody(sAXMarshaller);
            contentHandler.endDocument();
            sAXMarshaller.reconcileID();
        }
        catch (SAXException sAXException) {
            throw new MarshalException((Throwable)sAXException);
        }
    }

    protected CharacterEscapeHandler createEscapeHandler(String string) {
        if (this.escapeHandler != null) {
            return this.escapeHandler;
        }
        if (string.startsWith("UTF")) {
            return MinimumEscapeHandler.theInstance;
        }
        try {
            return new NioEscapeHandler(this.getJavaEncoding(string));
        }
        catch (Throwable throwable) {
            return DumbEscapeHandler.theInstance;
        }
    }

    public XMLWriter createWriter(Writer writer, String string) throws JAXBException {
        XMLWriter xMLWriter;
        writer = new BufferedWriter(writer);
        CharacterEscapeHandler characterEscapeHandler = this.createEscapeHandler(string);
        if (this.isFormattedOutput()) {
            DataWriter dataWriter = new DataWriter(writer, string, characterEscapeHandler);
            dataWriter.setIndentStep(this.indent);
            xMLWriter = dataWriter;
        } else {
            xMLWriter = new XMLWriter(writer, string, characterEscapeHandler);
        }
        xMLWriter.setXmlDecl(this.printXmlDeclaration);
        xMLWriter.setHeader(this.header);
        return xMLWriter;
    }

    public XMLWriter createWriter(Writer writer) throws JAXBException {
        return this.createWriter(writer, this.getEncoding());
    }

    public XMLWriter createWriter(OutputStream outputStream) throws JAXBException {
        return this.createWriter(outputStream, this.getEncoding());
    }

    public XMLWriter createWriter(OutputStream outputStream, String string) throws JAXBException {
        try {
            return this.createWriter(new OutputStreamWriter(outputStream, this.getJavaEncoding(string)), string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MarshalException(Messages.format((String)"MarshallerImpl.UnsupportedEncoding", (Object)string), (Throwable)unsupportedEncodingException);
        }
    }

    public Object getProperty(String string) throws PropertyException {
        if (INDENT_STRING.equals(string)) {
            return this.indent;
        }
        if (ENCODING_HANDLER.equals(string)) {
            return this.escapeHandler;
        }
        if (PREFIX_MAPPER.equals(string)) {
            return this.prefixMapper;
        }
        if (XMLDECLARATION.equals(string)) {
            return this.printXmlDeclaration ? Boolean.TRUE : Boolean.FALSE;
        }
        if (XML_HEADERS.equals(string)) {
            return this.header;
        }
        return super.getProperty(string);
    }

    public void setProperty(String string, Object object) throws PropertyException {
        if (INDENT_STRING.equals(string) && object instanceof String) {
            this.indent = (String)object;
            return;
        }
        if (ENCODING_HANDLER.equals(string)) {
            this.escapeHandler = (CharacterEscapeHandler)object;
            return;
        }
        if (PREFIX_MAPPER.equals(string)) {
            this.prefixMapper = (NamespacePrefixMapper)object;
            return;
        }
        if (XMLDECLARATION.equals(string)) {
            this.printXmlDeclaration = (Boolean)object;
            return;
        }
        if (XML_HEADERS.equals(string)) {
            this.header = (String)object;
            return;
        }
        super.setProperty(string, object);
    }
}

