/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.xmsf.x3dsai.impl.runtime;

import com.sun.xml.bind.validator.Messages;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationException;
import javax.xml.bind.Validator;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import org.web3d.xmsf.x3dsai.impl.runtime.DefaultJAXBContextImpl;
import org.web3d.xmsf.x3dsai.impl.runtime.ValidatableObject;
import org.web3d.xmsf.x3dsai.impl.runtime.ValidationContext;
import org.xml.sax.SAXException;

public class ValidatorImpl
implements Validator {
    private ValidationEventHandler eventHandler = new DefaultValidationEventHandler();
    final DefaultJAXBContextImpl jaxbContext;

    public ValidatorImpl(DefaultJAXBContextImpl defaultJAXBContextImpl) {
        this.jaxbContext = defaultJAXBContextImpl;
    }

    public boolean validateRoot(Object object) throws ValidationException {
        if (object == null) {
            throw new IllegalArgumentException(Messages.format((String)"Shared.MustNotBeNull", (Object)"rootObj"));
        }
        return this.validate(object, true);
    }

    public boolean validate(Object object) throws ValidationException {
        if (object == null) {
            throw new IllegalArgumentException(Messages.format((String)"Shared.MustNotBeNull", (Object)"subrootObj"));
        }
        return this.validate(object, false);
    }

    private boolean validate(Object object, boolean bl) throws ValidationException {
        try {
            ValidatableObject validatableObject = this.jaxbContext.getGrammarInfo().castToValidatableObject(object);
            if (validatableObject == null) {
                throw new ValidationException(Messages.format((String)"Validator.NotValidatable"));
            }
            EventInterceptor eventInterceptor = new EventInterceptor(this.eventHandler);
            ValidationContext validationContext = new ValidationContext(this.jaxbContext, eventInterceptor, bl);
            validationContext.validate(validatableObject);
            validationContext.reconcileIDs();
            return !eventInterceptor.hadError();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception != null) {
                throw new ValidationException((Throwable)exception);
            }
            throw new ValidationException((Throwable)sAXException);
        }
    }

    public ValidationEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void setEventHandler(ValidationEventHandler validationEventHandler) {
        this.eventHandler = validationEventHandler == null ? new DefaultValidationEventHandler() : validationEventHandler;
    }

    public void setProperty(String string, Object object) throws PropertyException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.format((String)"Shared.MustNotBeNull", (Object)"name"));
        }
        throw new PropertyException(string, object);
    }

    public Object getProperty(String string) throws PropertyException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.format((String)"Shared.MustNotBeNull", (Object)"name"));
        }
        throw new PropertyException(string);
    }

    private static class EventInterceptor
    implements ValidationEventHandler {
        private boolean hadError = false;
        private final ValidationEventHandler next;

        EventInterceptor(ValidationEventHandler validationEventHandler) {
            this.next = validationEventHandler;
        }

        public boolean hadError() {
            return this.hadError;
        }

        public boolean handleEvent(ValidationEvent validationEvent) {
            boolean bl;
            this.hadError = true;
            if (this.next != null) {
                try {
                    bl = this.next.handleEvent(validationEvent);
                }
                catch (RuntimeException runtimeException) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            return bl;
        }
    }
}

