/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.sai;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.w3c.dom.Node;
import org.web3d.x3d.sai.ComponentInfo;
import org.web3d.x3d.sai.InvalidBrowserException;
import org.web3d.x3d.sai.InvalidDocumentException;
import org.web3d.x3d.sai.InvalidOperationTimingException;
import org.web3d.x3d.sai.InvalidURLException;
import org.web3d.x3d.sai.InvalidX3DException;
import org.web3d.x3d.sai.NotSupportedException;
import org.web3d.x3d.sai.ProfileInfo;
import org.web3d.x3d.sai.X3DExecutionContext;
import org.web3d.x3d.sai.X3DScene;

public interface Browser {
    public String getName() throws InvalidBrowserException;

    public String getVersion() throws InvalidBrowserException;

    public ProfileInfo[] getSupportedProfiles() throws InvalidBrowserException;

    public ProfileInfo getProfile(String var1) throws InvalidBrowserException, NotSupportedException;

    public ComponentInfo[] getSupportedComponents() throws InvalidBrowserException;

    public ComponentInfo getComponent(String var1, int var2) throws InvalidBrowserException, NotSupportedException;

    public X3DExecutionContext getExecutionContext() throws InvalidBrowserException;

    public X3DScene createScene(ProfileInfo var1, ComponentInfo[] var2) throws InvalidBrowserException, IllegalArgumentException;

    public float getCurrentSpeed() throws InvalidBrowserException;

    public float getCurrentFrameRate() throws InvalidBrowserException;

    public void replaceWorld(X3DScene var1) throws InvalidBrowserException;

    public void loadURL(String[] var1, Map var2) throws InvalidBrowserException, InvalidURLException;

    public String getDescription() throws InvalidBrowserException;

    public void setDescription(String var1) throws InvalidBrowserException;

    public X3DScene createX3DFromString(String var1) throws InvalidBrowserException, InvalidX3DException;

    public X3DScene createX3DFromStream(InputStream var1) throws InvalidBrowserException, InvalidX3DException, IOException;

    public X3DScene createX3DFromURL(String[] var1) throws InvalidBrowserException, InvalidURLException, InvalidX3DException;

    public X3DScene importDocument(Node var1) throws InvalidBrowserException, InvalidDocumentException, NotSupportedException;

    public void print(Object var1) throws InvalidBrowserException;

    public void println(Object var1) throws InvalidBrowserException;

    public void nextViewpoint() throws InvalidBrowserException;

    public void previousViewpoint() throws InvalidBrowserException;

    public void firstViewpoint() throws InvalidBrowserException;

    public void lastViewpoint() throws InvalidBrowserException;

    public Map getRenderingProperties() throws InvalidBrowserException, InvalidOperationTimingException;

    public Map getBrowserProperties() throws InvalidBrowserException, InvalidOperationTimingException;
}

