/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.sai;

import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import org.web3d.x3d.sai.BrowserFactoryImpl;
import org.web3d.x3d.sai.ConnectionException;
import org.web3d.x3d.sai.ExternalBrowser;
import org.web3d.x3d.sai.NoSuchBrowserException;
import org.web3d.x3d.sai.NotSupportedException;
import org.web3d.x3d.sai.X3DComponent;
import org.web3d.x3d.sai.X3DException;

public class BrowserFactory {
    private static final String PROPERTIES_FILE_NAME = "x3d.properties";
    private static final String FACTORY_CLASS = "x3d.sai.factory.class";
    private static final String XJ3D_PROPERTIES_FILE = "config/3.0/spec/x3d.properties";
    private static final String DEFAULT_FACTORY_CLASS = "org.web3d.x3d.sai.DefaultBrowserImpl";
    private static BrowserFactoryImpl factory = null;
    private static Properties vrml_properties = null;
    static /* synthetic */ Class class$org$web3d$x3d$sai$BrowserFactory;

    private BrowserFactory() {
    }

    public static synchronized void setBrowserFactoryImpl(BrowserFactoryImpl browserFactoryImpl) throws IllegalArgumentException, X3DException, SecurityException {
        if (browserFactoryImpl == null) {
            throw new IllegalArgumentException("Provided factory is null");
        }
        if (factory != null) {
            throw new X3DException("Factory already defined");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        factory = browserFactoryImpl;
    }

    public static X3DComponent createX3DComponent(Map map) throws NotSupportedException {
        if (factory == null) {
            BrowserFactory.loadFactoryImpl();
        }
        X3DComponent x3DComponent = factory.createComponent(map);
        return x3DComponent;
    }

    public static ExternalBrowser getBrowser(Applet applet) throws NotSupportedException, NoSuchBrowserException, ConnectionException {
        if (factory == null) {
            BrowserFactory.loadFactoryImpl();
        }
        return factory.getBrowser(applet);
    }

    public static ExternalBrowser getBrowser(Applet applet, String string, int n) throws NotSupportedException, NoSuchBrowserException, ConnectionException {
        if (factory == null) {
            BrowserFactory.loadFactoryImpl();
        }
        return factory.getBrowser(applet, string, n);
    }

    public static ExternalBrowser getBrowser(InetAddress inetAddress, int n) throws NotSupportedException, NoSuchBrowserException, UnknownHostException, ConnectionException {
        if (factory == null) {
            BrowserFactory.loadFactoryImpl();
        }
        return factory.getBrowser(inetAddress, n);
    }

    private static void loadFactoryImpl() {
        try {
            String string = vrml_properties.getProperty(FACTORY_CLASS, DEFAULT_FACTORY_CLASS);
            Class<?> clazz = Class.forName(string);
            factory = (BrowserFactoryImpl)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Unable to find X3D browser factory implementation\n" + classNotFoundException);
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            System.out.println("Error instantiating the vrml browser factory " + instantiationException);
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println(illegalAccessException);
            illegalAccessException.printStackTrace();
        }
        catch (ClassCastException classCastException) {
            System.out.println("The nominated browser factory is not an instance of org.web3d.x3d.sai.BrowserFactoryImpl");
            classCastException.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        vrml_properties = new Properties();
        try {
            InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ClassLoader.getSystemResourceAsStream(BrowserFactory.PROPERTIES_FILE_NAME);
                }
            });
            if (inputStream == null) {
                inputStream = (class$org$web3d$x3d$sai$BrowserFactory == null ? (class$org$web3d$x3d$sai$BrowserFactory = BrowserFactory.class$("org.web3d.x3d.sai.BrowserFactory")) : class$org$web3d$x3d$sai$BrowserFactory).getClassLoader().getResourceAsStream(PROPERTIES_FILE_NAME);
            }
            if (inputStream == null) {
                inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return ClassLoader.getSystemResourceAsStream(BrowserFactory.XJ3D_PROPERTIES_FILE);
                    }
                });
            }
            if (inputStream == null) {
                inputStream = (class$org$web3d$x3d$sai$BrowserFactory == null ? (class$org$web3d$x3d$sai$BrowserFactory = BrowserFactory.class$("org.web3d.x3d.sai.BrowserFactory")) : class$org$web3d$x3d$sai$BrowserFactory).getClassLoader().getResourceAsStream(XJ3D_PROPERTIES_FILE);
            }
            if (inputStream == null) {
                vrml_properties.put(FACTORY_CLASS, DEFAULT_FACTORY_CLASS);
            } else {
                vrml_properties.load(inputStream);
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }
}

