/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput;

import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.dinopolis.gpstool.gpsinput.GPSDataProcessor;
import org.dinopolis.gpstool.gpsinput.GPSDevice;
import org.dinopolis.gpstool.gpsinput.GPSException;
import org.dinopolis.gpstool.gpsinput.GPSPosition;
import org.dinopolis.gpstool.gpsinput.GPSRawDataListener;
import org.dinopolis.util.ProgressListener;

public abstract class GPSGeneralDataProcessor
implements GPSDataProcessor {
    protected GPSDevice gps_device_ = null;
    protected Map gps_data_ = new HashMap();
    protected Object gps_data_lock_ = new Object();
    protected PropertyChangeSupport property_change_support_;
    protected Vector raw_data_listener_;
    protected Vector progress_listener_;
    private static Logger logger_ = Logger.getLogger((Class)GPSGeneralDataProcessor.class);

    public abstract void open() throws GPSException;

    public abstract void close() throws GPSException;

    public void setGPSDevice(GPSDevice gps_device) {
        this.gps_device_ = gps_device;
    }

    public GPSDevice getGPSDevice() {
        return this.gps_device_;
    }

    public abstract GPSPosition getGPSPosition();

    public abstract float getHeading();

    public abstract String[] getGPSInfo();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getGPSData(String key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("The key must not be <null>.");
        }
        Object object = this.gps_data_lock_;
        synchronized (object) {
            return this.gps_data_.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getGPSData() {
        Object object = this.gps_data_lock_;
        synchronized (object) {
            return (Map)((HashMap)this.gps_data_).clone();
        }
    }

    public List getWaypoints() throws UnsupportedOperationException, GPSException {
        throw new UnsupportedOperationException("operation not supported by the device/protocol");
    }

    public void setWaypoints(List waypoints) throws UnsupportedOperationException, GPSException {
        throw new UnsupportedOperationException("operation not supported by the device/protocol");
    }

    public List getRoutes() throws UnsupportedOperationException, GPSException {
        System.out.println("GeneralDataProcessor.getRoutes()");
        throw new UnsupportedOperationException("operation not supported by the device/protocol");
    }

    public void setRoutes(List routes) throws UnsupportedOperationException, GPSException {
        throw new UnsupportedOperationException("operation not supported by the device/protocol");
    }

    public List getTracks() throws UnsupportedOperationException, GPSException {
        throw new UnsupportedOperationException("operation not supported by the device/protocol");
    }

    public void setTracks(List tracks) throws UnsupportedOperationException, GPSException {
        throw new UnsupportedOperationException("operation not supported by the device/protocol");
    }

    public BufferedImage getScreenShot() throws UnsupportedOperationException, GPSException {
        throw new UnsupportedOperationException("operation not supported by the device/protocol");
    }

    public void addGPSDataChangeListener(String key, PropertyChangeListener listener) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("The key must not be <null>.");
        }
        if (listener == null) {
            throw new IllegalArgumentException("The listener must not be <null>.");
        }
        if (this.property_change_support_ == null) {
            this.property_change_support_ = new PropertyChangeSupport(this);
        }
        this.property_change_support_.addPropertyChangeListener(key, listener);
    }

    public void addGPSDataChangeListener(PropertyChangeListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("The listener must not be <null>.");
        }
        if (this.property_change_support_ == null) {
            this.property_change_support_ = new PropertyChangeSupport(this);
        }
        this.property_change_support_.addPropertyChangeListener(listener);
    }

    public void removeGPSDataChangeListener(String key, PropertyChangeListener listener) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("The key must not be <null>.");
        }
        if (listener == null) {
            throw new IllegalArgumentException("The listener must not be <null>.");
        }
        if (this.property_change_support_ != null) {
            this.property_change_support_.removePropertyChangeListener(key, listener);
        }
    }

    public void removeGPSDataChangeListener(PropertyChangeListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("The listener must not be <null>.");
        }
        if (this.property_change_support_ != null) {
            this.property_change_support_.removePropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeGPSData(String key, Object value) throws IllegalArgumentException {
        Object old_value;
        if (key == null) {
            throw new IllegalArgumentException("The key must not be <null>!");
        }
        Object object = this.gps_data_lock_;
        synchronized (object) {
            old_value = this.gps_data_.get(key);
            if (value == null) {
                this.gps_data_.remove(key);
            } else {
                this.gps_data_.put(key, value);
            }
        }
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("fire event for key " + key + " oldvalue=" + old_value + " new=" + value));
        }
        if (this.property_change_support_ != null) {
            this.property_change_support_.firePropertyChange(key, old_value, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRawDataReceived(char[] raw_data, int offset, int length) {
        Iterator listeners;
        if (this.raw_data_listener_ == null) {
            return;
        }
        Vector vector = this.raw_data_listener_;
        synchronized (vector) {
            listeners = ((Vector)this.raw_data_listener_.clone()).iterator();
        }
        while (listeners.hasNext()) {
            ((GPSRawDataListener)listeners.next()).gpsRawDataReceived(raw_data, offset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGPSRawDataListener(GPSRawDataListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("The listener must not be <null>.");
        }
        if (this.raw_data_listener_ == null) {
            this.raw_data_listener_ = new Vector();
        }
        Vector vector = this.raw_data_listener_;
        synchronized (vector) {
            this.raw_data_listener_.addElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGPSRawDataListener(GPSRawDataListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("The listener must not be <null>.");
        }
        if (this.raw_data_listener_ == null) {
            return;
        }
        Vector vector = this.raw_data_listener_;
        synchronized (vector) {
            this.raw_data_listener_.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressListener(ProgressListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("The listener must not be <null>.");
        }
        if (this.progress_listener_ == null) {
            this.progress_listener_ = new Vector();
        }
        Vector vector = this.progress_listener_;
        synchronized (vector) {
            this.progress_listener_.addElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressListener(ProgressListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("The listener must not be <null>.");
        }
        if (this.progress_listener_ == null) {
            return;
        }
        Vector vector = this.progress_listener_;
        synchronized (vector) {
            this.progress_listener_.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireProgressActionStart(String action_id, int min_value, int max_value) {
        Iterator listeners;
        if (this.progress_listener_ == null) {
            return;
        }
        Vector vector = this.progress_listener_;
        synchronized (vector) {
            listeners = ((Vector)this.progress_listener_.clone()).iterator();
        }
        while (listeners.hasNext()) {
            ((ProgressListener)listeners.next()).actionStart(action_id, min_value, max_value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireProgressActionProgress(String action_id, int current_value) {
        Iterator listeners;
        if (this.progress_listener_ == null) {
            return;
        }
        Vector vector = this.progress_listener_;
        synchronized (vector) {
            listeners = ((Vector)this.progress_listener_.clone()).iterator();
        }
        while (listeners.hasNext()) {
            ((ProgressListener)listeners.next()).actionProgress(action_id, current_value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireProgressActionEnd(String action_id) {
        Iterator listeners;
        if (this.progress_listener_ == null) {
            return;
        }
        Vector vector = this.progress_listener_;
        synchronized (vector) {
            listeners = ((Vector)this.progress_listener_.clone()).iterator();
        }
        while (listeners.hasNext()) {
            ((ProgressListener)listeners.next()).actionEnd(action_id);
        }
    }
}

