/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput;

public class GPSPoint
implements Cloneable {
    protected double latitude_ = 0.0;
    protected double longitude_ = 0.0;
    protected double altitude_ = Double.NaN;

    protected Object clone() throws CloneNotSupportedException {
        Object o = null;
        o = super.clone();
        return o;
    }

    public double getLatitude() {
        return this.latitude_;
    }

    public void setLatitude(double latitude) {
        if (latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("out of range latitude");
        }
        this.latitude_ = latitude;
    }

    public double getLongitude() {
        return this.longitude_;
    }

    public void setLongitude(double longitude) {
        if (longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("out of range longitude");
        }
        this.longitude_ = longitude;
    }

    public double getAltitude() {
        return this.altitude_;
    }

    public void setAltitude(double altitude) {
        this.altitude_ = altitude;
    }

    public boolean hasValidAltitude() {
        return !Double.isNaN(this.altitude_);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("GPSPoint[");
        buffer.append("lat=").append(this.latitude_).append(", ");
        buffer.append("lon=").append(this.longitude_);
        if (this.hasValidAltitude()) {
            buffer.append(", alt=").append(this.altitude_);
        }
        buffer.append("]");
        return buffer.toString();
    }
}

