/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput.garmin;

import java.util.HashSet;
import java.util.Vector;
import org.dinopolis.gpstool.gpsinput.GPSException;
import org.dinopolis.gpstool.gpsinput.garmin.GarminDataConverter;
import org.dinopolis.gpstool.gpsinput.garmin.GarminPacket;
import org.dinopolis.gpstool.gpsinput.garmin.GarminProduct;

public class GarminCapabilities {
    Vector product_capabilities_ = new Vector();
    HashSet capabilities_ = new HashSet();

    public GarminCapabilities(int[] buffer) {
        for (int i = 0; i < buffer[1] / 3; ++i) {
            String letter = GarminDataConverter.getGarminString(buffer, 2 + 3 * i, 1);
            int number = GarminDataConverter.getGarminWord(buffer, 3 + 3 * i);
            String full_name = letter + number;
            this.capabilities_.add(full_name);
            this.product_capabilities_.add(full_name);
        }
    }

    public GarminCapabilities(GarminPacket pack) {
        for (int i = 0; i < pack.getPacketSize() / 3; ++i) {
            String letter = pack.getNextAsString(1);
            int number = pack.getNextAsWord();
            String full_name = letter + number;
            this.capabilities_.add(full_name);
            this.product_capabilities_.add(full_name);
        }
    }

    public GarminCapabilities(GarminProduct info) throws GPSException {
        int i;
        String[] alm;
        String[] prx;
        String[] trk;
        String[] dta;
        String[] lnk;
        String[] all = new String[]{"P0", "A100", "A200"};
        String[] lnk1 = new String[]{"L1", "A10"};
        String[] lnk2 = new String[]{"L2", "A11"};
        String[] dta1 = new String[]{"D100", "D200"};
        String[] dta2 = new String[]{"D100", "D201"};
        String[] dta3 = new String[]{"D101", "D201"};
        String[] dta4 = new String[]{"D102", "D201"};
        String[] dta13 = new String[]{"D103", "D201"};
        String[] dta5 = new String[]{"D104", "D201"};
        String[] dta6 = new String[]{"D150", "D201"};
        String[] dta7 = new String[]{"D151", "D200"};
        String[] dta8 = new String[]{"D151", "D201"};
        String[] dta9 = new String[]{"D152", "D200"};
        String[] dta10 = new String[]{"D152", "D201"};
        String[] dta11 = new String[]{"D154", "D201"};
        String[] dta12 = new String[]{"D155", "D201"};
        String[] trk1 = new String[]{"A300", "D300"};
        String[] prx1 = new String[]{"A400"};
        String[] prx2 = new String[]{"A400", "D400"};
        String[] prx3 = new String[]{"A400", "D450"};
        String[] prx4 = new String[]{"A400", "D403"};
        String[] alm1 = new String[]{"A500", "D500"};
        String[] alm2 = new String[]{"A500", "D501"};
        String[] alm3 = new String[]{"A500", "D550"};
        String[] alm4 = new String[]{"A500", "D551"};
        switch (info.getProductId()) {
            case 7: {
                lnk = lnk1;
                dta = dta1;
                trk = null;
                prx = null;
                alm = alm1;
                break;
            }
            case 13: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 35: 
            case 42: {
                lnk = lnk1;
                dta = dta1;
                trk = trk1;
                prx = prx2;
                alm = alm1;
                break;
            }
            case 14: {
                lnk = lnk1;
                dta = dta1;
                trk = null;
                prx = prx2;
                alm = alm1;
                break;
            }
            case 15: {
                lnk = lnk1;
                dta = dta7;
                trk = null;
                prx = prx1;
                alm = alm1;
                break;
            }
            case 20: 
            case 33: 
            case 34: 
            case 52: {
                lnk = lnk2;
                dta = dta6;
                trk = null;
                prx = prx3;
                alm = alm3;
                break;
            }
            case 22: {
                lnk = lnk1;
                dta = dta9;
                trk = trk1;
                prx = prx1;
                alm = alm1;
                break;
            }
            case 36: {
                if (info.getProductSoftware() < 300) {
                    lnk = lnk1;
                    dta = dta9;
                    trk = trk1;
                    prx = prx1;
                    alm = alm1;
                    break;
                }
                lnk = lnk1;
                dta = dta9;
                trk = trk1;
                prx = null;
                alm = alm1;
                break;
            }
            case 45: {
                lnk = lnk1;
                dta = dta10;
                trk = trk1;
                prx = null;
                alm = alm1;
                break;
            }
            case 29: {
                if (info.getProductSoftware() < 400) {
                    lnk = lnk1;
                    dta = dta3;
                    trk = trk1;
                    prx = prx1;
                    alm = alm1;
                    break;
                }
                lnk = lnk1;
                dta = dta4;
                trk = trk1;
                prx = null;
                alm = alm1;
                break;
            }
            case 44: {
                lnk = lnk1;
                dta = dta3;
                trk = trk1;
                prx = prx1;
                alm = alm1;
                break;
            }
            case 31: 
            case 41: 
            case 47: 
            case 55: 
            case 56: 
            case 59: 
            case 61: 
            case 62: 
            case 74: {
                lnk = lnk1;
                dta = dta2;
                trk = trk1;
                prx = null;
                alm = alm1;
                break;
            }
            case 39: {
                lnk = lnk1;
                dta = dta8;
                trk = trk1;
                prx = null;
                alm = alm1;
                break;
            }
            case 48: {
                lnk = lnk1;
                dta = dta11;
                trk = trk1;
                prx = null;
                alm = alm2;
                break;
            }
            case 49: 
            case 76: 
            case 88: {
                lnk = lnk1;
                dta = dta4;
                trk = trk1;
                prx = prx1;
                alm = alm2;
                break;
            }
            case 50: 
            case 53: 
            case 112: {
                lnk = lnk1;
                dta = dta10;
                trk = trk1;
                prx = null;
                alm = alm2;
                break;
            }
            case 64: 
            case 98: {
                lnk = lnk2;
                dta = dta6;
                trk = null;
                prx = prx3;
                alm = alm4;
                break;
            }
            case 71: {
                lnk = lnk1;
                dta = dta12;
                trk = trk1;
                prx = null;
                alm = alm2;
                break;
            }
            case 72: {
                lnk = lnk1;
                dta = dta5;
                trk = trk1;
                prx = null;
                alm = alm2;
                break;
            }
            case 77: {
                if (info.getProductSoftware() < 301) {
                    lnk = lnk1;
                    dta = dta2;
                    trk = trk1;
                    prx = prx1;
                    alm = alm2;
                    break;
                }
                if (info.getProductSoftware() < 350 || info.getProductSoftware() >= 361) {
                    lnk = lnk1;
                    dta = dta13;
                    trk = trk1;
                    prx = prx4;
                    alm = alm2;
                    break;
                }
                lnk = lnk1;
                dta = dta13;
                trk = trk1;
                prx = null;
                alm = alm2;
                break;
            }
            case 73: 
            case 97: {
                lnk = lnk1;
                dta = dta13;
                trk = trk1;
                prx = null;
                alm = alm2;
                break;
            }
            case 87: 
            case 95: 
            case 96: 
            case 100: 
            case 105: 
            case 106: {
                lnk = lnk1;
                dta = dta13;
                trk = trk1;
                prx = prx4;
                alm = alm2;
                break;
            }
            default: {
                throw new GPSException("Garmin GPS not supported for default capabilities, GPS Id is " + info.getProductId());
            }
        }
        for (i = 0; i < all.length; ++i) {
            this.capabilities_.add(all[i]);
            this.product_capabilities_.add(all[i]);
        }
        for (i = 0; i < lnk.length; ++i) {
            this.capabilities_.add(lnk[i]);
            this.product_capabilities_.add(lnk[i]);
        }
        for (i = 0; i < dta.length; ++i) {
            this.capabilities_.add(dta[i]);
            this.product_capabilities_.add(dta[i]);
        }
        if (trk != null) {
            for (i = 0; i < trk.length; ++i) {
                this.capabilities_.add(trk[i]);
                this.product_capabilities_.add(trk[i]);
            }
        }
        if (prx != null) {
            for (i = 0; i < prx.length; ++i) {
                this.capabilities_.add(prx[i]);
                this.product_capabilities_.add(prx[i]);
            }
        }
        for (i = 0; i < alm.length; ++i) {
            this.capabilities_.add(alm[i]);
            this.product_capabilities_.add(alm[i]);
        }
    }

    public String toString() {
        return this.product_capabilities_.toString();
    }

    public Vector getProductCapabilities() {
        return this.product_capabilities_;
    }

    public boolean hasCapability(String name) {
        return this.capabilities_.contains(name);
    }
}

