/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput.garmin;

import org.dinopolis.gpstool.gpsinput.GPSWaypoint;
import org.dinopolis.gpstool.gpsinput.garmin.GarminDataConverter;
import org.dinopolis.gpstool.gpsinput.garmin.GarminPacket;
import org.dinopolis.gpstool.gpsinput.garmin.GarminWaypointBase;
import org.dinopolis.gpstool.gpsinput.garmin.GarminWaypointSymbols;

public class GarminWaypointD102
extends GarminWaypointBase {
    protected long symbol_;
    protected float distance_;
    protected static final byte WAYPOINT_TYPE = 102;

    public GarminWaypointD102() {
    }

    public GarminWaypointD102(int[] buffer) {
        this.identification_ = GarminDataConverter.getGarminString(buffer, 2, 6).trim();
        this.latitude_ = GarminDataConverter.getGarminSemicircleDegrees(buffer, 8);
        this.longitude_ = GarminDataConverter.getGarminSemicircleDegrees(buffer, 12);
        this.comment_ = GarminDataConverter.getGarminString(buffer, 20, 40).trim();
        this.distance_ = GarminDataConverter.getGarminFloat(buffer, 60);
        this.symbol_ = GarminDataConverter.getGarminLongWord(buffer, 64);
        this.symbol_name_ = GarminWaypointSymbols.getSymbolName(this.symbol_);
    }

    public GarminWaypointD102(GarminPacket pack) {
        this.identification_ = pack.getNextAsString(6).trim();
        this.latitude_ = pack.getNextAsSemicircleDegrees();
        this.longitude_ = pack.getNextAsSemicircleDegrees();
        pack.getNextAsLongWord();
        this.comment_ = pack.getNextAsString(40).trim();
        this.distance_ = pack.getNextAsFloat();
        this.symbol_ = pack.getNextAsLongWord();
        this.symbol_name_ = GarminWaypointSymbols.getSymbolName(this.symbol_);
    }

    public GarminWaypointD102(GPSWaypoint waypoint) {
        this.identification_ = waypoint.getIdentification();
        this.latitude_ = waypoint.getLatitude();
        this.longitude_ = waypoint.getLongitude();
        this.comment_ = waypoint.getComment();
        this.distance_ = 0.0f;
        this.symbol_ = (short)GarminWaypointSymbols.getSymbolId(waypoint.getSymbolName());
        if (this.symbol_ < 0L) {
            this.symbol_ = 18L;
        }
        this.symbol_name_ = GarminWaypointSymbols.getSymbolName(this.symbol_);
    }

    public GarminPacket toGarminPacket(int packet_id) {
        int data_length = 66;
        GarminPacket pack = new GarminPacket(packet_id, data_length);
        pack.setNextAsString(this.identification_, 6, false);
        pack.setNextAsSemicircleDegrees(this.latitude_);
        pack.setNextAsSemicircleDegrees(this.longitude_);
        pack.setNextAsLongWord(0L);
        pack.setNextAsString(this.comment_, 40, false);
        pack.setNextAsFloat(this.distance_);
        pack.setNextAsLongWord(this.symbol_);
        return pack;
    }

    public byte getType() {
        return 102;
    }
}

