/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.web;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.JMenuItem;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mystate.MyState;
import pt.lsts.neptus.plugins.web.IConsoleMenuItemServlet;
import pt.lsts.neptus.plugins.web.NeptusServlet;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.StreamUtil;

@NeptusServlet(name="Local State", path="/localstate/*", author="Paulo Dias")
public class LocalStateServlet
extends HttpServlet
implements IConsoleMenuItemServlet {
    public boolean allowConsoleExposure = false;
    private File console = null;
    private long consoleLastRTime = -1L;
    protected JMenuItem exposuredMenuItem;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getPathInfo().equals("/location")) {
            resp.setContentType("application/neptus+xml");
            PrintWriter page = resp.getWriter();
            LocationType start = MyState.getLocation();
            page.write(start.asXML(ImcMsgManager.getManager().getLocalId() + " Location"));
            page.close();
            return;
        }
        if (req.getPathInfo().equals("/console") || req.getPathInfo().equals("/console.png")) {
            if (System.currentTimeMillis() - this.consoleLastRTime > 10000L) {
                File logImages = new File("log/images");
                File[] fileList = logImages.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isFile() && "png".equalsIgnoreCase(FileUtil.getFileExtension((File)pathname));
                    }
                });
                Vector<File> fileVec = new Vector<File>();
                for (File f : fileList) {
                    fileVec.add(f);
                }
                Collections.sort(fileVec);
                this.console = fileVec.size() > 0 ? (File)fileVec.lastElement() : null;
                this.consoleLastRTime = System.currentTimeMillis();
            }
            if (req.getPathInfo().equals("/console.png")) {
                if (this.console != null && this.console.exists() && this.allowConsoleExposure) {
                    resp.setContentType("image/png");
                    FileInputStream fxStream = new FileInputStream(this.console);
                    StreamUtil.copyStreamToStream((InputStream)fxStream, (OutputStream)resp.getOutputStream());
                    fxStream.close();
                }
                resp.getOutputStream().close();
            } else {
                resp.setContentType("text/html;charset=UTF-8");
                resp.getWriter().write("<html><head><meta http-equiv='refresh' content='30'></head><body>");
                if (this.console != null && this.console.exists() && this.allowConsoleExposure) {
                    resp.getWriter().write("<img src=\"/localstate/console.png\" alt=\"" + this.console.getName() + "\" " + "id=\"" + this.console.getName() + " border=\"0\">");
                } else {
                    resp.getWriter().write("No consoles active.");
                }
                resp.getWriter().write("</body></html>");
                resp.getWriter().close();
            }
        } else if (req.getPathInfo().equals("/")) {
            resp.setContentType("text/html;charset=UTF-8");
            if (!ImcMsgManager.getManager().isRunning()) {
                resp.getWriter().write("<html><head><meta http-equiv='refresh' content='30'><body>Comms are not running.</body></html>");
                resp.getWriter().close();
                return;
            }
            ImcId16 idImc = ImcMsgManager.getManager().getLocalId();
            String ret = "<html>";
            ret = ret + "<h2>Location</h2><blockquote>";
            LocationType home = MyState.getLocation();
            String homeLoc = home.getLatitudeAsPrettyString() + ", " + home.getLongitudeAsPrettyString();
            ret = ret + "<a href='/localstate/location'>" + homeLoc + "</a><br/>";
            ret = ret + "</blockquote><br>";
            ret = ret + "<h2>State</h2>";
            ret = ret + "<b>ID:</b> " + idImc + "<br>";
            ret = ret + "<b>Services:</b> " + ImcMsgManager.getManager().getAllServicesString().replaceAll(";", ";<br>") + "<br><br>";
            ret = ret + "<b>Comms info:</b><br>" + ImcMsgManager.getManager().getCommStatusAsHtmlFragment();
            if (System.currentTimeMillis() - ImcMsgManager.getManager().getAnnounceLastArriveTime() > 300000L) {
                ret = ret + "<b color='red'>Announce not arriving for some time</b><br>";
            }
            ret = ret + "</html>";
            resp.getWriter().write(ret);
            resp.getWriter().close();
        }
    }

    @Override
    public IConsoleMenuItemServlet.ConsoleMenuItem[] getConsoleMenuItems() {
        return new IConsoleMenuItemServlet.ConsoleMenuItem[]{new IConsoleMenuItemServlet.ConsoleMenuItem(I18n.text((String)"Allow console exposure to the outside"), null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LocalStateServlet.this.exposuredMenuItem.getText().equals(I18n.text((String)"Allow console exposure to the outside"))) {
                    LocalStateServlet.this.allowConsoleExposure = true;
                    LocalStateServlet.this.exposuredMenuItem.setText(I18n.text((String)"Disallow console exposure to the outside"));
                } else {
                    LocalStateServlet.this.allowConsoleExposure = false;
                    LocalStateServlet.this.exposuredMenuItem.setText(I18n.text((String)"Allow console exposure to the outside"));
                }
            }
        })};
    }

    @Override
    public void informCreatedConsoleMenuItem(Hashtable<String, JMenuItem> consoleMenuItems) {
        for (String path : consoleMenuItems.keySet()) {
            if (!I18n.text((String)"Allow console exposure to the outside").equalsIgnoreCase(path)) continue;
            this.exposuredMenuItem = consoleMenuItems.get(path);
        }
    }
}

