/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.security.Credential;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.plugins.web.NeptusServlet;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.StreamUtil;
import pt.lsts.neptus.util.ZipUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

@NeptusServlet(name="Logs", path="/log/*")
public class LogsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getPathInfo().equals("/")) {
            resp.setContentType("text/html");
            resp.getWriter().write("<html><head><title>Recorded Logs</title></head><body>");
            File f = new File("log");
            Vector<File> logs = new Vector<File>();
            this.listLogs(f, logs);
            for (File logDir : logs) {
                String shorter = FileUtil.relativizeFilePath((String)f.getAbsolutePath(), (String)logDir.getAbsolutePath()).replaceAll("\\\\", "/");
                resp.getWriter().write("<li><a href='" + shorter + ".zip'>" + logDir.getName() + "</a>");
            }
            resp.getWriter().close();
        } else if (req.getPathInfo().endsWith(".zip")) {
            String dir = req.getPathInfo().substring(0, req.getPathInfo().length() - 4);
            File temp = new File(ConfigFetch.getNeptusTmpDir() + "/" + Credential.MD5.digest((String)dir).substring(4));
            if (req.getHeader("pragma") != null && req.getHeader("pragma").equalsIgnoreCase("no-cache") || req.getHeader("cacheControl") != null && req.getHeader("cacheControl").equalsIgnoreCase("no-store") || !temp.exists()) {
                NeptusLog.pub().info((Object)("<###>zipping " + new File("log", dir).getAbsolutePath() + " to " + temp));
                ZipUtils.zipDir((String)temp.getAbsolutePath(), (String)new File("log", dir).getAbsolutePath());
            }
            resp.setContentType("application/zip");
            StreamUtil.copyStreamToStream((InputStream)new FileInputStream(temp), (OutputStream)resp.getOutputStream());
            resp.getOutputStream().close();
        }
    }

    protected void listLogs(File parent, Vector<File> logs) {
        for (File f : parent.listFiles()) {
            if (f.isDirectory()) {
                this.listLogs(f, logs);
                continue;
            }
            if (!f.getName().equalsIgnoreCase("Data.lsf") && !f.getName().equalsIgnoreCase("EstimatedState.llf")) continue;
            logs.add(parent);
        }
    }
}

