/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.web;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.plugins.web.IConsoleServlet;
import pt.lsts.neptus.plugins.web.NeptusServlet;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.TransponderElement;
import pt.lsts.neptus.types.mission.HomeReference;
import pt.lsts.neptus.types.mission.MapMission;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.StreamUtil;

@NeptusServlet(path="/mission/*", name="Mission Elements")
public class MissionServlet
extends HttpServlet
implements IConsoleServlet {
    private static final long serialVersionUID = 1L;
    protected ConsoleLayout myConsole = null;

    @Override
    public void setConsole(ConsoleLayout c) {
        this.myConsole = c;
    }

    protected void sendHomeRef(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.myConsole == null || this.myConsole.getMission() == null) {
            resp.setContentType("text/html");
            PrintWriter page = resp.getWriter();
            page.write("<p><font color='red'>ERROR: </font>No mission has been set in the console.<p></body></html>");
            page.close();
            return;
        }
        resp.setContentType("application/neptus+xml");
        PrintWriter page = resp.getWriter();
        HomeReference homeRef = this.myConsole.getMission().getHomeRef();
        page.write(homeRef.asXML("home-reference"));
        page.close();
    }

    protected void sendStart(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.myConsole == null || this.myConsole.getMission() == null) {
            resp.setContentType("text/html");
            PrintWriter page = resp.getWriter();
            page.write("<p><font color='red'>ERROR: </font>No mission has been set in the console.<p></body></html>");
            page.close();
            return;
        }
        resp.setContentType("application/neptus+xml");
        PrintWriter page = resp.getWriter();
        LocationType start = IMCUtils.lookForStartPosition((MissionType)this.myConsole.getMission());
        page.write(start.asXML("StartLocation"));
        page.close();
    }

    protected void sendMission(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.myConsole == null || this.myConsole.getMission() == null) {
            resp.setContentType("text/html");
            PrintWriter page = resp.getWriter();
            page.write("<p><font color='red'>ERROR: </font>No mission has been set in the console.<p></body></html>");
            page.close();
            return;
        }
        resp.setContentType("application/zip+nmis");
        StreamUtil.copyStreamToStream((InputStream)new FileInputStream(this.myConsole.getMission().getMissionFile()), (OutputStream)resp.getOutputStream());
        resp.getOutputStream().close();
    }

    protected void sendTransponder(String id, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.myConsole == null || this.myConsole.getMission() == null) {
            resp.setContentType("text/html");
            PrintWriter page = resp.getWriter();
            page.write("<p><font color='red'>ERROR: </font>No mission has been set in the console.<p></body></html>");
            page.close();
            return;
        }
        PrintWriter page = resp.getWriter();
        try {
            TransponderElement el = (TransponderElement)MapGroup.getMapGroupInstance((MissionType)this.myConsole.getMission()).getMapObjectsByID(id)[0];
            resp.setContentType("application/neptus+xml");
            page.write(el.asXML("Transponder"));
        }
        catch (Exception e) {
            throw new ServletException("Invalid transponder id");
        }
        page.close();
    }

    protected void sendPlan(String id, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.myConsole == null || this.myConsole.getMission() == null) {
            resp.setContentType("text/html");
            PrintWriter page = resp.getWriter();
            page.write("<p><font color='red'>ERROR: </font>No mission has been set in the console.<p></body></html>");
            page.close();
            return;
        }
        PlanType plan = (PlanType)this.myConsole.getMission().getIndividualPlansList().get(id);
        if (plan == null) {
            throw new ServletException("Invalid plan id");
        }
        PrintWriter page = resp.getWriter();
        resp.setContentType("application/neptus+xml");
        page.write(plan.asXML("Plan"));
        page.close();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getPathInfo().equals("/homeRef")) {
            this.sendHomeRef(req, resp);
            return;
        }
        if (req.getPathInfo().equals("/startLoc")) {
            this.sendStart(req, resp);
            return;
        }
        if (req.getPathInfo().startsWith("/download")) {
            this.sendMission(req, resp);
            return;
        }
        if (req.getPathInfo().startsWith("/transponder/")) {
            this.sendTransponder(req.getPathInfo().substring(13), req, resp);
            return;
        }
        if (req.getPathInfo().startsWith("/plan/")) {
            this.sendPlan(req.getPathInfo().substring(6), req, resp);
            return;
        }
        if (this.myConsole == null || this.myConsole.getMission() == null) {
            resp.setContentType("text/html");
            PrintWriter page = resp.getWriter();
            page.write("<p><font color='red'>ERROR: </font>No mission has been set in the console.<p></body></html>");
            page.close();
            return;
        }
        resp.setContentType("text/html");
        PrintWriter page = resp.getWriter();
        page.write("<html><head><title>Loaded Mission</title></head><body><h1>Loaded Mission</h1>");
        MissionType mission = this.myConsole.getMission();
        page.write("<h2>Mission Information</h2><blockquote>");
        page.write("<b>Mission ID: </b>" + mission.getId() + "<br/>");
        page.write("<b>Mission Name: </b>" + mission.getName() + "<br/>");
        page.write("<b>Mission Description: </b>" + mission.getDescription() + "<br/>");
        page.write("<b>Mission Filename: </b>" + mission.getMissionFile().getAbsolutePath() + "<br/>");
        page.write("<a href='/mission/download/" + this.myConsole.getMission().getMissionFile().getName() + "'>Download</a></blockquote>");
        page.write("<h2>Map</h2><blockquote>");
        LocationType home = new LocationType((LocationType)mission.getHomeRef());
        LocationType start = IMCUtils.lookForStartPosition((MissionType)mission);
        String homeLoc = home.getLatitudeAsPrettyString() + ", " + home.getLongitudeAsPrettyString();
        String startLoc = start != null ? start.getLatitudeAsPrettyString() + ", " + start.getLongitudeAsPrettyString() : "";
        page.write("<b>Home Reference: </b><a href='/mission/homeRef'>" + homeLoc + "</a><br/>");
        page.write("<b>Start Location: </b><a href='/mission/startLoc'>" + startLoc + "</a><br/>");
        for (MapMission mpm : mission.getMapsList().values()) {
            LinkedHashMap transList = mpm.getMap().getTranspondersList();
            for (TransponderElement tmp : transList.values()) {
                String tLoc = tmp.getCenterLocation().getLatitudeAsPrettyString() + ", " + tmp.getCenterLocation().getLongitudeAsPrettyString() + ", " + tmp.getCenterLocation().getAllZ();
                page.write("<b>Transponder " + tmp.getId() + ":</b> <a href='/mission/transponder/" + tmp.getId() + "'>" + tLoc + "</a><br/>");
            }
        }
        page.write("</blockquote><h2>Plans</h2><blockquote>");
        for (PlanType plan : mission.getIndividualPlansList().values()) {
            page.write("<b><a href='/mission/plan/" + plan.getId() + "'>" + plan.getId() + "</a></b> (" + plan.getVehicle() + ")<br/>");
        }
        page.write("</blockquote></body></html>");
        page.close();
    }
}

