/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.web;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.state.ImcSysState;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsoleSystem;
import pt.lsts.neptus.plugins.web.IConsoleServlet;
import pt.lsts.neptus.plugins.web.NeptusServlet;

@NeptusServlet(path="/state/*", name="Current State")
public class StateServlet
extends HttpServlet
implements IConsoleServlet {
    private static final long serialVersionUID = 1L;
    private ConsoleLayout console = null;

    @Override
    public void setConsole(ConsoleLayout c) {
        this.console = c;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.console == null) {
            throw new ServletException("Console is null");
        }
        if (req.getPathInfo().equals("/")) {
            resp.setContentType("text/html");
            PrintWriter page = resp.getWriter();
            page.write("<html><head><title>Current Neptus State</title></head><body><h1>Current Neptus State</h1><blockquote>");
            for (ConsoleSystem v : this.console.getSystems().values()) {
                page.write("<h2><a href='/state/" + v.getVehicleId() + "'>" + v.getVehicleId() + "</a></h2>");
            }
            page.write("</blockquote></body></html>");
            page.close();
        } else {
            String[] parts = req.getPathInfo().split("/");
            String vehicle = parts[1];
            ImcSysState state = this.console.getImcState(vehicle);
            if (state != null && parts.length < 3) {
                resp.setContentType("text/html");
                PrintWriter page = resp.getWriter();
                page.write("<html><head><title>" + vehicle + " data</title></head><body><h1>" + vehicle + " data</h1><blockquote>");
                for (String msg : state.availableMessages()) {
                    page.write("<li><a href=/state/" + vehicle + "/" + msg + ">" + msg + "</a></li>");
                }
                page.write("</body></html>");
                page.close();
            } else {
                String variable = parts[2];
                resp.setContentType("text/html");
                PrintWriter page = resp.getWriter();
                try {
                    page.write("<html><head><title>" + variable + " data</title>");
                    page.write("<meta http-equiv='refresh' content='3'>");
                    String html = IMCUtils.getAsHtml((IMCMessage)state.get(variable));
                    page.write(html.substring("<html>".length()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                page.close();
            }
        }
    }
}

