/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.web;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.URL;
import java.util.LinkedHashMap;
import javax.servlet.Servlet;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.plugins.web.NeptusServlet;
import pt.lsts.neptus.util.ReflectionUtil;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class WebServer {
    private static int counter = 0;
    private static Server server = null;
    static Integer port = 8080;
    protected static LinkedHashMap<String, Servlet> installedServlets = new LinkedHashMap();

    public static Servlet addServlet(String path, Class<?> servletClass) {
        try {
            Servlet s = (Servlet)servletClass.newInstance();
            installedServlets.put(path, s);
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Servlet install(Class<?> servlet) {
        String path = "/" + servlet.getSimpleName();
        NeptusServlet s = servlet.getAnnotation(NeptusServlet.class);
        if (s != null && !s.path().equals("")) {
            path = s.path();
        }
        return WebServer.addServlet(path, servlet);
    }

    public static void restart() {
        NeptusLog.pub().info((Object)("<###>Restarting Neptus Web Server Request (was " + (WebServer.isRunning() ? "" : "not ") + "running)..."));
        WebServer.start(port);
    }

    public static void start(int port) {
        if (server != null) {
            WebServer.stop();
            try {
                Thread.sleep(300L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        WebServer.port = port;
        Thread serverThread = new Thread(WebServer.class.getSimpleName() + " :: Start Thread :: " + counter++){

            @Override
            public void run() {
                while (!WebServer.available(port)) {
                    Integer n = port;
                    Integer n2 = port = Integer.valueOf(port + 1);
                }
                server = new Server(port.intValue());
                Context root = new Context((HandlerContainer)server, "/", 1);
                WebServer.registerUnregisterPath(true, "");
                for (String path : installedServlets.keySet()) {
                    root.addServlet(new ServletHolder(installedServlets.get(path)), path);
                    WebServer.registerUnregisterPath(true, path);
                }
                try {
                    System.out.print("Starting Neptus Web Server...");
                    server.start();
                    NeptusLog.pub().info((Object)("<###>DONE.\nNeptus Web Server listening on port " + port + "."));
                    server.join();
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)("Error while binding web server to port " + port));
                }
            }
        };
        serverThread.start();
    }

    public static void stop() {
        System.out.print("Stopping Neptus Web Server... ");
        if (server != null) {
            try {
                server.stop();
                WebServer.registerUnregisterPath(false, "");
                for (String path : installedServlets.keySet()) {
                    WebServer.registerUnregisterPath(false, path);
                }
                NeptusLog.pub().info((Object)"<###>DONE.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            NeptusLog.pub().info((Object)"<###>NO SERVER RUNNING.");
        }
        server = null;
    }

    public static boolean isRunning() {
        if (server == null) {
            return false;
        }
        return server.isRunning();
    }

    public static int getPort() {
        return port;
    }

    public static void setPort(int port) {
        WebServer.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean available(int port) {
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    protected static void registerUnregisterPath(boolean registerOrUnregister, String path) {
        try {
            URL serURL = new URL("http://localhost:" + port + (path.startsWith("/") ? "" : "/") + (path.endsWith("*") ? path.replaceAll("\\*$", "") : path));
            if (registerOrUnregister) {
                ImcMsgManager.getManager().registerService(serURL);
            } else {
                ImcMsgManager.getManager().unRegisterService(serURL);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        ConfigFetch.initialize();
        for (Class c : ReflectionUtil.getClassesForPackage((String)WebServer.class.getPackage().getName())) {
            if (c.getAnnotation(NeptusServlet.class) == null) continue;
            WebServer.install(c);
        }
        WebServer.restart();
    }
}

