/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.web;

import com.l2fprod.common.propertysheet.DefaultProperty;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.swing.JMenuItem;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.web.IConsoleMenuItemServlet;
import pt.lsts.neptus.plugins.web.IConsoleServlet;
import pt.lsts.neptus.plugins.web.NeptusServlet;
import pt.lsts.neptus.plugins.web.WebServer;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.ReflectionUtil;

@PluginDescription(name="Web Server", author="zp", icon="pt/lsts/neptus/plugins/web/internet.png")
public class WebServerPlugin
extends ConsolePanel
implements ConfigurationListener {
    @NeptusProperty(name="Web Server Port")
    public int port = WebServer.port;
    @NeptusProperty(name="Web Server Enabled")
    public boolean enabled = true;
    JMenuItem enabledMenuItem = null;
    protected boolean alreadyStarted = false;

    public void initSubPanel() {
        if (this.alreadyStarted) {
            return;
        }
        this.alreadyStarted = true;
        String menuPrefixStr = I18n.text((String)"Settings") + ">" + I18n.text((String)"Web Server") + ">";
        try {
            this.enabledMenuItem = this.addMenuItem(menuPrefixStr + I18n.text((String)"Disable"), ImageUtils.getIcon((String)PluginUtils.getPluginIcon(((Object)((Object)this)).getClass())), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (WebServerPlugin.this.enabledMenuItem.getText().equals(I18n.text((String)"Disable"))) {
                        WebServer.stop();
                        WebServerPlugin.this.enabledMenuItem.setText(I18n.text((String)"Enable"));
                    } else {
                        WebServer.restart();
                        WebServerPlugin.this.enabledMenuItem.setText(I18n.text((String)"Disable"));
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Vector<String> alreadyLoaded = new Vector<String>();
        try {
            for (Class c : ReflectionUtil.getClassesForPackage((String)WebServer.class.getPackage().getName())) {
                if (c.getAnnotation(NeptusServlet.class) == null || alreadyLoaded.contains(c.getCanonicalName())) continue;
                alreadyLoaded.add(c.getCanonicalName());
                Servlet s = WebServer.install(c);
                if (s instanceof IConsoleServlet) {
                    ((IConsoleServlet)s).setConsole(this.getConsole());
                }
                if (!(s instanceof IConsoleMenuItemServlet)) continue;
                String pathName = c.getSimpleName();
                NeptusServlet sa = c.getAnnotation(NeptusServlet.class);
                if (sa != null && !sa.name().equals("")) {
                    pathName = sa.name();
                }
                Hashtable<String, JMenuItem> mht = new Hashtable<String, JMenuItem>();
                for (IConsoleMenuItemServlet.ConsoleMenuItem cmi : ((IConsoleMenuItemServlet)s).getConsoleMenuItems()) {
                    JMenuItem jmi = this.addMenuItem(menuPrefixStr + I18n.text((String)pathName) + ">" + cmi.getItemSubPath(), cmi.getIcon(), cmi.getActionListener());
                    if (jmi == null) continue;
                    mht.put(cmi.getItemSubPath(), jmi);
                }
                ((IConsoleMenuItemServlet)s).informCreatedConsoleMenuItem(mht);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.launchServer();
    }

    public WebServerPlugin(ConsoleLayout console) {
        super(console);
        this.setVisibility(false);
    }

    public void propertiesChanged() {
        new Thread(((Object)((Object)this)).getClass().getSimpleName() + "[" + Integer.toHexString(((Object)((Object)this)).hashCode()) + "]"){

            @Override
            public void run() {
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                WebServerPlugin.this.launchServer();
            }
        }.start();
    }

    public DefaultProperty[] getProperties() {
        this.port = WebServer.port;
        return super.getProperties();
    }

    public void cleanSubPanel() {
        WebServer.stop();
    }

    private void launchServer() {
        WebServer.setPort(this.port);
        if (this.enabled) {
            if (WebServer.isRunning()) {
                WebServer.restart();
            } else if (!WebServer.isRunning()) {
                WebServer.start(this.port);
            }
            if (this.enabledMenuItem != null) {
                this.enabledMenuItem.setText(I18n.text((String)"Disable"));
            }
        } else {
            WebServer.stop();
            if (this.enabledMenuItem != null) {
                this.enabledMenuItem.setText(I18n.text((String)"Enable"));
            }
        }
    }
}

