/*
 * Decompiled with CFR 0.152.
 */
package org.alternativevision.gpx;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.alternativevision.gpx.beans.GPX;
import org.alternativevision.gpx.beans.Route;
import org.alternativevision.gpx.beans.Track;
import org.alternativevision.gpx.beans.Waypoint;
import org.alternativevision.gpx.extensions.IExtensionParser;
import org.alternativevision.gpx.types.FixType;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GPXParser {
    private ArrayList<IExtensionParser> extensionParsers = new ArrayList();
    private Logger logger = Logger.getLogger((String)this.getClass().getName());

    public void addExtensionParser(IExtensionParser iExtensionParser) {
        this.extensionParsers.add(iExtensionParser);
    }

    public void removeExtensionParser(IExtensionParser iExtensionParser) {
        this.extensionParsers.remove(iExtensionParser);
    }

    public GPX parseGPX(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        Node node = document.getFirstChild();
        if (node != null && "gpx".equals(node.getNodeName())) {
            GPX gPX = new GPX();
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                if ("version".equals(node2.getNodeName())) {
                    gPX.setVersion(node2.getNodeValue());
                    continue;
                }
                if (!"creator".equals(node2.getNodeName())) continue;
                gPX.setCreator(node2.getNodeValue());
            }
            NodeList nodeList = node.getChildNodes();
            this.logger.debug((Object)("Found " + nodeList.getLength() + " child nodes. Start parsing ..."));
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Object object;
                Node node3 = nodeList.item(i);
                if ("wpt".equals(node3.getNodeName())) {
                    this.logger.debug((Object)"Found waypoint node. Start parsing...");
                    object = this.parseWaypoint(node3);
                    if (object == null) continue;
                    this.logger.info((Object)("Add waypoint to gpx data. [waypointName=" + ((Waypoint)object).getName() + "]"));
                    gPX.addWaypoint((Waypoint)object);
                    continue;
                }
                if ("trk".equals(node3.getNodeName())) {
                    this.logger.debug((Object)"Found track node. Start parsing...");
                    object = this.parseTrack(node3);
                    if (object == null) continue;
                    this.logger.info((Object)("Add track to gpx data. [trackName=" + ((Track)object).getName() + "]"));
                    gPX.addTrack((Track)object);
                    continue;
                }
                if ("extensions".equals(node3.getNodeName())) {
                    this.logger.debug((Object)"Found extensions node. Start parsing...");
                    for (IExtensionParser iExtensionParser : this.extensionParsers) {
                        Object object2 = iExtensionParser.parseGPXExtension(node3);
                        gPX.addExtensionData(iExtensionParser.getId(), object2);
                    }
                    continue;
                }
                if (!"rte".equals(node3.getNodeName())) continue;
                this.logger.debug((Object)"Found route node. Start parsing...");
                object = this.parseRoute(node3);
                if (object == null) continue;
                this.logger.info((Object)("Add route to gpx data. [routeName=" + ((Route)object).getName() + "]"));
                gPX.addRoute((Route)object);
            }
            return gPX;
        }
        this.logger.error((Object)"FATAL!! - Root node is not gpx.");
        return null;
    }

    private Waypoint parseWaypoint(Node node) {
        Object object;
        Object object2;
        if (node == null) {
            this.logger.error((Object)"null node received");
            return null;
        }
        Waypoint waypoint = new Waypoint();
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("lat");
        if (node2 != null) {
            object2 = null;
            try {
                object2 = Double.parseDouble(node2.getNodeValue());
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.error((Object)("bad lat value in waypoint data: " + node2.getNodeValue()));
            }
            waypoint.setLatitude((Double)object2);
        } else {
            this.logger.warn((Object)"no lat value in waypoint data.");
        }
        object2 = namedNodeMap.getNamedItem("lon");
        if (object2 != null) {
            object = null;
            try {
                object = Double.parseDouble(object2.getNodeValue());
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.error((Object)("bad lon value in waypoint data: " + object2.getNodeValue()));
            }
            waypoint.setLongitude((Double)object);
        } else {
            this.logger.warn((Object)"no lon value in waypoint data.");
        }
        object = node.getChildNodes();
        if (object != null) {
            for (int i = 0; i < object.getLength(); ++i) {
                Node node3 = object.item(i);
                if ("ele".equals(node3.getNodeName())) {
                    this.logger.debug((Object)"found ele node in waypoint data");
                    waypoint.setElevation(this.getNodeValueAsDouble(node3));
                    continue;
                }
                if ("time".equals(node3.getNodeName())) {
                    this.logger.debug((Object)"found time node in waypoint data");
                    waypoint.setTime(this.getNodeValueAsDate(node3));
                    continue;
                }
                if ("name".equals(node3.getNodeName())) {
                    this.logger.debug((Object)"found name node in waypoint data");
                    waypoint.setName(this.getNodeValueAsString(node3));
                    continue;
                }
                if ("cmt".equals(node3.getNodeName())) {
                    this.logger.debug((Object)"found cmt node in waypoint data");
                    waypoint.setComment(this.getNodeValueAsString(node3));
                    continue;
                }
                if ("desc".equals(node3.getNodeName())) {
                    this.logger.debug((Object)"found desc node in waypoint data");
                    waypoint.setDescription(this.getNodeValueAsString(node3));
                    continue;
                }
                if ("src".equals(node3.getNodeName())) {
                    this.logger.debug((Object)"found src node in waypoint data");
                    waypoint.setSrc(this.getNodeValueAsString(node3));
                    continue;
                }
                if ("magvar".equals(node3.getNodeName())) {
                    this.logger.debug((Object)"found magvar node in waypoint data");
                    waypoint.setMagneticDeclination(this.getNodeValueAsDouble(node3));
                    continue;
                }
                if ("geoidheight".equals(node3.getNodeName())) {
                    this.logger.debug((Object)"found geoidheight node in waypoint data");
                    waypoint.setGeoidHeight(this.getNodeValueAsDouble(node3));
                    continue;
                }
                if ("link".equals(node3.getNodeName())) {
                    this.logger.debug((Object)"found link node in waypoint data");
                    continue;
                }
                if ("sym".equals(node3.getNodeName())) {
                    this.logger.debug((Object)"found sym node in waypoint data");
                    waypoint.setSym(this.getNodeValueAsString(node3));
                    continue;
                }
                if ("fix".equals(node3.getNodeName())) {
                    this.logger.debug((Object)"found fix node in waypoint data");
                    waypoint.setFix(this.getNodeValueAsFixType(node3));
                    continue;
                }
                if ("type".equals(node3.getNodeName())) {
                    this.logger.debug((Object)"found type node in waypoint data");
                    waypoint.setType(this.getNodeValueAsString(node3));
                    continue;
                }
                if ("sat".equals(node3.getNodeName())) {
                    this.logger.debug((Object)"found sat node in waypoint data");
                    waypoint.setSat(this.getNodeValueAsInteger(node3));
                    continue;
                }
                if ("hdop".equals(node3.getNodeName())) {
                    this.logger.debug((Object)"found hdop node in waypoint data");
                    waypoint.setHdop(this.getNodeValueAsDouble(node3));
                    continue;
                }
                if ("vdop".equals(node3.getNodeName())) {
                    this.logger.debug((Object)"found vdop node in waypoint data");
                    waypoint.setVdop(this.getNodeValueAsDouble(node3));
                    continue;
                }
                if ("pdop".equals(node3.getNodeName())) {
                    this.logger.debug((Object)"found pdop node in waypoint data");
                    waypoint.setPdop(this.getNodeValueAsDouble(node3));
                    continue;
                }
                if ("ageofdgpsdata".equals(node3.getNodeName())) {
                    this.logger.debug((Object)"found ageofgpsdata node in waypoint data");
                    waypoint.setAgeOfGPSData(this.getNodeValueAsDouble(node3));
                    continue;
                }
                if ("dgpsid".equals(node3.getNodeName())) {
                    this.logger.debug((Object)"found dgpsid node in waypoint data");
                    waypoint.setDgpsid(this.getNodeValueAsInteger(node3));
                    continue;
                }
                if (!"extensions".equals(node3.getNodeName())) continue;
                this.logger.debug((Object)"found extensions node in waypoint data");
                for (IExtensionParser iExtensionParser : this.extensionParsers) {
                    Object object3 = iExtensionParser.parseWaypointExtension(node3);
                    waypoint.addExtensionData(iExtensionParser.getId(), object3);
                }
            }
        } else {
            this.logger.debug((Object)"no child nodes found in waypoint");
        }
        return waypoint;
    }

    private Track parseTrack(Node node) {
        if (node == null) {
            this.logger.error((Object)"null node received");
            return null;
        }
        Track track = new Track();
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if ("name".equals(node2.getNodeName())) {
                    this.logger.debug((Object)"node name found");
                    track.setName(this.getNodeValueAsString(node2));
                    continue;
                }
                if ("cmt".equals(node2.getNodeName())) {
                    this.logger.debug((Object)"node cmt found");
                    track.setComment(this.getNodeValueAsString(node2));
                    continue;
                }
                if ("desc".equals(node2.getNodeName())) {
                    this.logger.debug((Object)"node desc found");
                    track.setDescription(this.getNodeValueAsString(node2));
                    continue;
                }
                if ("src".equals(node2.getNodeName())) {
                    this.logger.debug((Object)"node src found");
                    track.setSrc(this.getNodeValueAsString(node2));
                    continue;
                }
                if ("link".equals(node2.getNodeName())) {
                    this.logger.debug((Object)"node link found");
                    continue;
                }
                if ("number".equals(node2.getNodeName())) {
                    this.logger.debug((Object)"node number found");
                    track.setNumber(this.getNodeValueAsInteger(node2));
                    continue;
                }
                if ("type".equals(node2.getNodeName())) {
                    this.logger.debug((Object)"node type found");
                    track.setType(this.getNodeValueAsString(node2));
                    continue;
                }
                if ("trkseg".equals(node2.getNodeName())) {
                    this.logger.debug((Object)"node trkseg found");
                    track.setTrackPoints(this.parseTrackSeg(node2));
                    continue;
                }
                if (!"extensions".equals(node2.getNodeName())) continue;
                Iterator<IExtensionParser> iterator = this.extensionParsers.iterator();
                while (iterator.hasNext()) {
                    this.logger.debug((Object)"node extensions found");
                    while (iterator.hasNext()) {
                        IExtensionParser iExtensionParser = iterator.next();
                        Object object = iExtensionParser.parseTrackExtension(node2);
                        track.addExtensionData(iExtensionParser.getId(), object);
                    }
                }
            }
        }
        return track;
    }

    private Route parseRoute(Node node) {
        if (node == null) {
            this.logger.error((Object)"null node received");
            return null;
        }
        Route route = new Route();
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Object object;
                Node node2 = nodeList.item(i);
                if ("name".equals(node2.getNodeName())) {
                    this.logger.debug((Object)"node name found");
                    route.setName(this.getNodeValueAsString(node2));
                    continue;
                }
                if ("cmt".equals(node2.getNodeName())) {
                    this.logger.debug((Object)"node cmt found");
                    route.setComment(this.getNodeValueAsString(node2));
                    continue;
                }
                if ("desc".equals(node2.getNodeName())) {
                    this.logger.debug((Object)"node desc found");
                    route.setDescription(this.getNodeValueAsString(node2));
                    continue;
                }
                if ("src".equals(node2.getNodeName())) {
                    this.logger.debug((Object)"node src found");
                    route.setSrc(this.getNodeValueAsString(node2));
                    continue;
                }
                if ("link".equals(node2.getNodeName())) {
                    this.logger.debug((Object)"node link found");
                    continue;
                }
                if ("number".equals(node2.getNodeName())) {
                    this.logger.debug((Object)"node number found");
                    route.setNumber(this.getNodeValueAsInteger(node2));
                    continue;
                }
                if ("type".equals(node2.getNodeName())) {
                    this.logger.debug((Object)"node type found");
                    route.setType(this.getNodeValueAsString(node2));
                    continue;
                }
                if ("rtept".equals(node2.getNodeName())) {
                    this.logger.debug((Object)"node rtept found");
                    object = this.parseWaypoint(node2);
                    if (object == null) continue;
                    route.addRoutePoint((Waypoint)object);
                    continue;
                }
                if (!"extensions".equals(node2.getNodeName())) continue;
                object = this.extensionParsers.iterator();
                while (object.hasNext()) {
                    this.logger.debug((Object)"node extensions found");
                    while (object.hasNext()) {
                        IExtensionParser iExtensionParser = (IExtensionParser)object.next();
                        Object object2 = iExtensionParser.parseRouteExtension(node2);
                        route.addExtensionData(iExtensionParser.getId(), object2);
                    }
                }
            }
        }
        return route;
    }

    private ArrayList<Waypoint> parseTrackSeg(Node node) {
        if (node == null) {
            this.logger.error((Object)"null node received");
            return null;
        }
        ArrayList<Waypoint> arrayList = new ArrayList<Waypoint>();
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if ("trkpt".equals(node2.getNodeName())) {
                    this.logger.debug((Object)"node name found");
                    Waypoint waypoint = this.parseWaypoint(node2);
                    if (waypoint == null) continue;
                    arrayList.add(waypoint);
                    continue;
                }
                if (!"extensions".equals(node2.getNodeName())) continue;
                this.logger.debug((Object)"node extensions found");
            }
        }
        return arrayList;
    }

    private Double getNodeValueAsDouble(Node node) {
        Double d = null;
        try {
            d = Double.parseDouble(node.getFirstChild().getNodeValue());
        }
        catch (Exception exception) {
            this.logger.error((Object)("error parsing Double value form node. val=" + node.getNodeValue()), (Throwable)exception);
        }
        return d;
    }

    private Date getNodeValueAsDate(Node node) {
        Date date = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'kk:mm:ss");
            date = simpleDateFormat.parse(node.getFirstChild().getNodeValue());
        }
        catch (Exception exception) {
            this.logger.error((Object)("error parsing Date value form node. val=" + node.getNodeName()), (Throwable)exception);
        }
        return date;
    }

    private String getNodeValueAsString(Node node) {
        String string = null;
        try {
            string = node.getFirstChild().getNodeValue();
        }
        catch (Exception exception) {
            this.logger.error((Object)("error getting String value form node. val=" + node.getNodeName()), (Throwable)exception);
        }
        return string;
    }

    private FixType getNodeValueAsFixType(Node node) {
        FixType fixType = null;
        try {
            fixType = FixType.returnType(node.getFirstChild().getNodeValue());
        }
        catch (Exception exception) {
            this.logger.error((Object)("error getting FixType value form node. val=" + node.getNodeName()), (Throwable)exception);
        }
        return fixType;
    }

    private Integer getNodeValueAsInteger(Node node) {
        Integer n = null;
        try {
            n = Integer.parseInt(node.getFirstChild().getNodeValue());
        }
        catch (Exception exception) {
            this.logger.error((Object)("error parsing Integer value form node. val=" + node.getNodeValue()), (Throwable)exception);
        }
        return n;
    }

    public void writeGPX(GPX gPX, OutputStream outputStream) throws ParserConfigurationException, TransformerException {
        Object object;
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("gpx");
        this.addBasicGPXInfoToNode(gPX, element, document);
        if (gPX.getWaypoints() != null) {
            object = gPX.getWaypoints().iterator();
            while (object.hasNext()) {
                this.addWaypointToGPXNode((Waypoint)object.next(), element, document);
            }
        }
        if (gPX.getTracks() != null) {
            object = gPX.getTracks().iterator();
            while (object.hasNext()) {
                this.addTrackToGPXNode((Track)object.next(), element, document);
            }
        }
        if (gPX.getRoutes() != null) {
            object = gPX.getRoutes().iterator();
            while (object.hasNext()) {
                this.addRouteToGPXNode((Route)object.next(), element, document);
            }
        }
        document.appendChild(element);
        object = TransformerFactory.newInstance();
        Transformer transformer = ((TransformerFactory)object).newTransformer();
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(outputStream);
        transformer.transform(dOMSource, streamResult);
    }

    private void addWaypointToGPXNode(Waypoint waypoint, Node node, Document document) {
        this.addGenericWaypointToGPXNode("wpt", waypoint, node, document);
    }

    private void addGenericWaypointToGPXNode(String string, Waypoint waypoint, Node node, Document document) {
        Object object;
        Node node2;
        Element element = document.createElement(string);
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (waypoint.getLatitude() != null) {
            node2 = document.createAttribute("lat");
            node2.setNodeValue(waypoint.getLatitude().toString());
            namedNodeMap.setNamedItem(node2);
        }
        if (waypoint.getLongitude() != null) {
            node2 = document.createAttribute("lon");
            node2.setNodeValue(waypoint.getLongitude().toString());
            namedNodeMap.setNamedItem(node2);
        }
        if (waypoint.getElevation() != null) {
            node2 = document.createElement("ele");
            node2.appendChild(document.createTextNode(waypoint.getElevation().toString()));
            element.appendChild(node2);
        }
        if (waypoint.getTime() != null) {
            node2 = document.createElement("time");
            object = new SimpleDateFormat("yyyy-MM-dd'T'kk:mm:ss'Z'");
            node2.appendChild(document.createTextNode(((DateFormat)object).format(waypoint.getTime())));
            element.appendChild(node2);
        }
        if (waypoint.getMagneticDeclination() != null) {
            node2 = document.createElement("magvar");
            node2.appendChild(document.createTextNode(waypoint.getMagneticDeclination().toString()));
            element.appendChild(node2);
        }
        if (waypoint.getGeoidHeight() != null) {
            node2 = document.createElement("geoidheight");
            node2.appendChild(document.createTextNode(waypoint.getGeoidHeight().toString()));
            element.appendChild(node2);
        }
        if (waypoint.getName() != null) {
            node2 = document.createElement("name");
            node2.appendChild(document.createTextNode(waypoint.getName()));
            element.appendChild(node2);
        }
        if (waypoint.getComment() != null) {
            node2 = document.createElement("cmt");
            node2.appendChild(document.createTextNode(waypoint.getComment()));
            element.appendChild(node2);
        }
        if (waypoint.getDescription() != null) {
            node2 = document.createElement("desc");
            node2.appendChild(document.createTextNode(waypoint.getDescription()));
            element.appendChild(node2);
        }
        if (waypoint.getSrc() != null) {
            node2 = document.createElement("src");
            node2.appendChild(document.createTextNode(waypoint.getSrc()));
            element.appendChild(node2);
        }
        if (waypoint.getSym() != null) {
            node2 = document.createElement("sym");
            node2.appendChild(document.createTextNode(waypoint.getSym()));
            element.appendChild(node2);
        }
        if (waypoint.getType() != null) {
            node2 = document.createElement("type");
            node2.appendChild(document.createTextNode(waypoint.getType()));
            element.appendChild(node2);
        }
        if (waypoint.getFix() != null) {
            node2 = document.createElement("fix");
            node2.appendChild(document.createTextNode(waypoint.getFix().toString()));
            element.appendChild(node2);
        }
        if (waypoint.getSat() != null) {
            node2 = document.createElement("sat");
            node2.appendChild(document.createTextNode(waypoint.getSat().toString()));
            element.appendChild(node2);
        }
        if (waypoint.getHdop() != null) {
            node2 = document.createElement("hdop");
            node2.appendChild(document.createTextNode(waypoint.getHdop().toString()));
            element.appendChild(node2);
        }
        if (waypoint.getVdop() != null) {
            node2 = document.createElement("vdop");
            node2.appendChild(document.createTextNode(waypoint.getVdop().toString()));
            element.appendChild(node2);
        }
        if (waypoint.getPdop() != null) {
            node2 = document.createElement("pdop");
            node2.appendChild(document.createTextNode(waypoint.getPdop().toString()));
            element.appendChild(node2);
        }
        if (waypoint.getAgeOfGPSData() != null) {
            node2 = document.createElement("ageofdgpsdata");
            node2.appendChild(document.createTextNode(waypoint.getAgeOfGPSData().toString()));
            element.appendChild(node2);
        }
        if (waypoint.getDgpsid() != null) {
            node2 = document.createElement("dgpsid");
            node2.appendChild(document.createTextNode(waypoint.getDgpsid().toString()));
            element.appendChild(node2);
        }
        if (waypoint.getExtensionsParsed() > 0) {
            node2 = document.createElement("extensions");
            object = this.extensionParsers.iterator();
            while (object.hasNext()) {
                ((IExtensionParser)object.next()).writeWaypointExtensionData(node2, waypoint, document);
            }
            element.appendChild(node2);
        }
        node.appendChild(element);
    }

    private void addTrackToGPXNode(Track track, Node node, Document document) {
        Iterator<Object> iterator;
        Element element;
        Element element2 = document.createElement("trk");
        if (track.getName() != null) {
            element = document.createElement("name");
            element.appendChild(document.createTextNode(track.getName()));
            element2.appendChild(element);
        }
        if (track.getComment() != null) {
            element = document.createElement("cmt");
            element.appendChild(document.createTextNode(track.getComment()));
            element2.appendChild(element);
        }
        if (track.getDescription() != null) {
            element = document.createElement("desc");
            element.appendChild(document.createTextNode(track.getDescription()));
            element2.appendChild(element);
        }
        if (track.getSrc() != null) {
            element = document.createElement("src");
            element.appendChild(document.createTextNode(track.getSrc()));
            element2.appendChild(element);
        }
        if (track.getNumber() != null) {
            element = document.createElement("number");
            element.appendChild(document.createTextNode(track.getNumber().toString()));
            element2.appendChild(element);
        }
        if (track.getType() != null) {
            element = document.createElement("type");
            element.appendChild(document.createTextNode(track.getType()));
            element2.appendChild(element);
        }
        if (track.getExtensionsParsed() > 0) {
            element = document.createElement("extensions");
            iterator = this.extensionParsers.iterator();
            while (iterator.hasNext()) {
                ((IExtensionParser)iterator.next()).writeTrackExtensionData(element, track, document);
            }
            element2.appendChild(element);
        }
        if (track.getTrackPoints() != null) {
            element = document.createElement("trkseg");
            iterator = track.getTrackPoints().iterator();
            while (iterator.hasNext()) {
                this.addGenericWaypointToGPXNode("trkpt", (Waypoint)iterator.next(), element, document);
            }
            element2.appendChild(element);
        }
        node.appendChild(element2);
    }

    private void addRouteToGPXNode(Route route, Node node, Document document) {
        Object object;
        Element element = document.createElement("rte");
        if (route.getName() != null) {
            object = document.createElement("name");
            object.appendChild(document.createTextNode(route.getName()));
            element.appendChild((Node)object);
        }
        if (route.getComment() != null) {
            object = document.createElement("cmt");
            object.appendChild(document.createTextNode(route.getComment()));
            element.appendChild((Node)object);
        }
        if (route.getDescription() != null) {
            object = document.createElement("desc");
            object.appendChild(document.createTextNode(route.getDescription()));
            element.appendChild((Node)object);
        }
        if (route.getSrc() != null) {
            object = document.createElement("src");
            object.appendChild(document.createTextNode(route.getSrc()));
            element.appendChild((Node)object);
        }
        if (route.getNumber() != null) {
            object = document.createElement("number");
            object.appendChild(document.createTextNode(route.getNumber().toString()));
            element.appendChild((Node)object);
        }
        if (route.getType() != null) {
            object = document.createElement("type");
            object.appendChild(document.createTextNode(route.getType()));
            element.appendChild((Node)object);
        }
        if (route.getExtensionsParsed() > 0) {
            object = document.createElement("extensions");
            Iterator<IExtensionParser> iterator = this.extensionParsers.iterator();
            while (iterator.hasNext()) {
                iterator.next().writeRouteExtensionData((Node)object, route, document);
            }
            element.appendChild((Node)object);
        }
        if (route.getRoutePoints() != null) {
            object = route.getRoutePoints().iterator();
            while (object.hasNext()) {
                this.addGenericWaypointToGPXNode("rtept", (Waypoint)object.next(), element, document);
            }
        }
        node.appendChild(element);
    }

    private void addBasicGPXInfoToNode(GPX gPX, Node node, Document document) {
        Node node2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (gPX.getVersion() != null) {
            node2 = document.createAttribute("version");
            node2.setNodeValue(gPX.getVersion());
            namedNodeMap.setNamedItem(node2);
        }
        if (gPX.getCreator() != null) {
            node2 = document.createAttribute("creator");
            node2.setNodeValue(gPX.getCreator());
            namedNodeMap.setNamedItem(node2);
        }
        if (gPX.getExtensionsParsed() > 0) {
            node2 = document.createElement("extensions");
            Iterator<IExtensionParser> iterator = this.extensionParsers.iterator();
            while (iterator.hasNext()) {
                iterator.next().writeGPXExtensionData(node2, gPX, document);
            }
            node.appendChild(node2);
        }
    }
}

