/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.sai;

import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.ROUTE;
import org.web3d.vrml.lang.SceneMetaData;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.lang.VRMLNodeTemplate;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLExternProtoDeclare;
import org.web3d.vrml.nodes.VRMLExternalNodeType;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLInlineNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoDeclare;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLWorldRootNodeType;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.scripting.sai.BaseNode;
import org.web3d.vrml.scripting.sai.FieldAccessListener;
import org.web3d.vrml.scripting.sai.FieldFactory;
import org.web3d.vrml.scripting.sai.SAIComponentInfo;
import org.web3d.vrml.scripting.sai.SAIExternProtoDeclaration;
import org.web3d.vrml.scripting.sai.SAIProtoDeclaration;
import org.web3d.vrml.scripting.sai.SAIProtoInstanceImpl;
import org.web3d.vrml.scripting.sai.SAIRoute;
import org.web3d.x3d.sai.ComponentInfo;
import org.web3d.x3d.sai.InvalidBrowserException;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidNodeException;
import org.web3d.x3d.sai.InvalidReadableFieldException;
import org.web3d.x3d.sai.InvalidWritableFieldException;
import org.web3d.x3d.sai.ProfileInfo;
import org.web3d.x3d.sai.X3DExecutionContext;
import org.web3d.x3d.sai.X3DExternProtoDeclaration;
import org.web3d.x3d.sai.X3DNode;
import org.web3d.x3d.sai.X3DProtoDeclaration;
import org.web3d.x3d.sai.X3DProtoInstance;
import org.web3d.x3d.sai.X3DRoute;

public class BaseExecutionContext
implements X3DExecutionContext {
    protected final String specVersion;
    protected final int encoding;
    protected final ProfileInfo profile;
    protected ComponentInfo[] components;
    protected ErrorReporter errorReporter;
    protected final String url;
    protected BaseNode[] rootNodes;
    protected X3DProtoDeclaration[] protos;
    protected X3DExternProtoDeclaration[] externprotos;
    protected X3DRoute[] routes;
    private VRMLNodeFactory nodeFactory;
    protected VRMLExecutionSpace executionSpace;
    protected BasicScene scene;
    protected RouteManager routeManager;
    protected FrameStateManager stateManager;
    protected ArrayList nodeWrapperList;
    protected HashMap nodeWrapperMap;
    protected HashMap routeWrapperMap;
    private HashMap protoObjectMap;
    private HashMap externObjectMap;
    private ReferenceQueue fieldQueue;
    private FieldFactory fieldFactory;
    private FieldAccessListener fieldAccessListener;

    public BaseExecutionContext(VRMLExecutionSpace vRMLExecutionSpace, RouteManager routeManager, FrameStateManager frameStateManager, ProfileInfo profileInfo, ComponentInfo[] componentInfoArray, ReferenceQueue referenceQueue, FieldFactory fieldFactory, FieldAccessListener fieldAccessListener) {
        this.profile = profileInfo;
        this.routeManager = routeManager;
        this.executionSpace = vRMLExecutionSpace;
        this.fieldQueue = referenceQueue;
        this.fieldFactory = fieldFactory;
        this.stateManager = frameStateManager;
        this.fieldAccessListener = fieldAccessListener;
        this.components = componentInfoArray;
        this.scene = this.executionSpace.getContainedScene();
        this.nodeFactory = this.scene.getNodeFactory();
        this.nodeWrapperList = new ArrayList();
        this.nodeWrapperMap = new HashMap();
        this.routeWrapperMap = new HashMap();
        this.protoObjectMap = new HashMap();
        this.externObjectMap = new HashMap();
        SceneMetaData sceneMetaData = this.scene.getMetaData();
        this.specVersion = sceneMetaData.getVersion();
        this.url = this.scene.getWorldRootURL();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        switch (sceneMetaData.getEncoding()) {
            case 0: {
                this.encoding = 1;
                break;
            }
            case 1: {
                this.encoding = 2;
                break;
            }
            case 2: {
                this.encoding = 3;
                break;
            }
            case 3: {
                this.encoding = 4;
                break;
            }
            case 4: {
                this.encoding = 5;
                break;
            }
            case 5: {
                this.encoding = 6;
                break;
            }
            default: {
                this.encoding = 0;
            }
        }
    }

    public BaseExecutionContext(VRMLExecutionSpace vRMLExecutionSpace, RouteManager routeManager, FrameStateManager frameStateManager, ProfileInfo profileInfo, ReferenceQueue referenceQueue, FieldFactory fieldFactory, FieldAccessListener fieldAccessListener) {
        this(vRMLExecutionSpace, routeManager, frameStateManager, profileInfo, null, referenceQueue, fieldFactory, fieldAccessListener);
        int n;
        SceneMetaData sceneMetaData = this.scene.getMetaData();
        org.web3d.vrml.lang.ComponentInfo[] componentInfoArray = sceneMetaData.getComponents();
        if (componentInfoArray != null) {
            this.components = new ComponentInfo[componentInfoArray.length];
            for (int i = 0; i < componentInfoArray.length; ++i) {
                this.components[i] = new SAIComponentInfo(componentInfoArray[i]);
            }
        } else {
            this.components = null;
        }
        ArrayList arrayList = this.scene.getNodeTemplates();
        int n2 = 0;
        int n3 = 0;
        int n4 = arrayList.size();
        for (n = 0; n < n4; ++n) {
            if (arrayList.get(n) instanceof VRMLProtoDeclare) {
                ++n2;
                continue;
            }
            ++n3;
        }
        this.protos = new X3DProtoDeclaration[n2];
        this.externprotos = new X3DExternProtoDeclaration[n3];
        n2 = 0;
        n3 = 0;
        for (n = 0; n < n4; ++n) {
            VRMLNodeTemplate vRMLNodeTemplate = (VRMLNodeTemplate)arrayList.get(n);
            if (vRMLNodeTemplate instanceof VRMLProtoDeclare) {
                this.protos[n2] = new SAIProtoDeclaration((VRMLProtoDeclare)vRMLNodeTemplate, this.executionSpace, this.fieldQueue, this.fieldFactory, this.fieldAccessListener);
                this.protoObjectMap.put(vRMLNodeTemplate.getVRMLNodeName(), this.protos[n2]);
                ++n2;
                continue;
            }
            this.externprotos[n3] = new SAIExternProtoDeclaration((VRMLExternProtoDeclare)vRMLNodeTemplate, this.executionSpace, this.fieldQueue, this.fieldFactory, this.fieldAccessListener);
            this.externObjectMap.put(vRMLNodeTemplate.getVRMLNodeName(), this.externprotos[n3]);
            ++n3;
        }
    }

    public String getSpecificationVersion() {
        return this.specVersion;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public ProfileInfo getProfile() {
        return this.profile;
    }

    public ComponentInfo[] getComponents() {
        return this.components;
    }

    public String getWorldURL() throws InvalidBrowserException {
        return this.url;
    }

    public X3DRoute[] getRoutes() {
        ArrayList arrayList = this.scene.getRoutes();
        int n = arrayList.size();
        X3DRoute[] x3DRouteArray = new X3DRoute[n];
        for (int i = 0; i < n; ++i) {
            ROUTE rOUTE = (ROUTE)arrayList.get(i);
            x3DRouteArray[i] = (X3DRoute)this.routeWrapperMap.get(rOUTE);
            if (x3DRouteArray[i] != null) continue;
            VRMLNodeType vRMLNodeType = (VRMLNodeType)rOUTE.getSourceNode();
            int n2 = rOUTE.getSourceIndex();
            VRMLFieldDeclaration vRMLFieldDeclaration = vRMLNodeType.getFieldDeclaration(n2);
            BaseNode baseNode = (BaseNode)this.nodeWrapperMap.get(vRMLNodeType);
            if (baseNode == null) {
                baseNode = new BaseNode(vRMLNodeType, this.fieldQueue, this.fieldFactory, this.fieldAccessListener);
                baseNode.setAccessValid(true);
                this.nodeWrapperMap.put(vRMLNodeType, baseNode);
            }
            VRMLNodeType vRMLNodeType2 = (VRMLNodeType)rOUTE.getDestinationNode();
            n2 = rOUTE.getDestinationIndex();
            VRMLFieldDeclaration vRMLFieldDeclaration2 = vRMLNodeType2.getFieldDeclaration(n2);
            BaseNode baseNode2 = (BaseNode)this.nodeWrapperMap.get(vRMLNodeType2);
            if (baseNode2 == null) {
                baseNode2 = new BaseNode(vRMLNodeType, this.fieldQueue, this.fieldFactory, this.fieldAccessListener);
                baseNode2.setAccessValid(true);
                this.nodeWrapperMap.put(vRMLNodeType, baseNode2);
            }
            x3DRouteArray[i] = new SAIRoute(baseNode, vRMLFieldDeclaration.getName(), baseNode2, vRMLFieldDeclaration2.getName());
            this.routeWrapperMap.put(rOUTE, x3DRouteArray);
        }
        return x3DRouteArray;
    }

    public X3DRoute addRoute(X3DNode x3DNode, String string, X3DNode x3DNode2, String string2) throws InvalidBrowserException, InvalidReadableFieldException, InvalidWritableFieldException, InvalidNodeException {
        BaseNode baseNode = (BaseNode)x3DNode;
        BaseNode baseNode2 = (BaseNode)x3DNode2;
        VRMLNodeType vRMLNodeType = baseNode.getImplNode();
        VRMLNodeType vRMLNodeType2 = baseNode2.getImplNode();
        int n = vRMLNodeType.getFieldIndex(string);
        int n2 = vRMLNodeType2.getFieldIndex(string2);
        SAIRoute sAIRoute = null;
        try {
            this.routeManager.addRoute(this.executionSpace, vRMLNodeType, n, vRMLNodeType2, n2);
            sAIRoute = new SAIRoute(baseNode, string, baseNode2, string2);
        }
        catch (InvalidFieldException invalidFieldException) {
            this.errorReporter.errorReport(null, (Exception)((Object)invalidFieldException));
        }
        return sAIRoute;
    }

    public void removeRoute(X3DRoute x3DRoute) throws InvalidBrowserException {
        SAIRoute sAIRoute = (SAIRoute)x3DRoute;
        VRMLNodeType vRMLNodeType = sAIRoute.srcNode.getImplNode();
        VRMLNodeType vRMLNodeType2 = sAIRoute.destNode.getImplNode();
        int n = vRMLNodeType.getFieldIndex(sAIRoute.destField);
        int n2 = vRMLNodeType2.getFieldIndex(sAIRoute.srcField);
        this.routeManager.removeRoute(this.executionSpace, vRMLNodeType, n, vRMLNodeType2, n2);
    }

    public String[] getProtosNames() {
        String[] stringArray = null;
        if (!this.protoObjectMap.isEmpty()) {
            Set set = this.protoObjectMap.keySet();
            stringArray = new String[set.size()];
            set.toArray(stringArray);
        }
        return stringArray;
    }

    public X3DProtoDeclaration getProtoDeclaration(String string) {
        return (X3DProtoDeclaration)this.protoObjectMap.get(string);
    }

    public void updateProtoDeclaration(String string, X3DProtoDeclaration x3DProtoDeclaration) {
        VRMLNodeTemplate vRMLNodeTemplate;
        SAIProtoDeclaration sAIProtoDeclaration = (SAIProtoDeclaration)this.protoObjectMap.put(string, x3DProtoDeclaration);
        if (sAIProtoDeclaration != null) {
            vRMLNodeTemplate = sAIProtoDeclaration.getInternalDecl();
            this.scene.removeTemplate(vRMLNodeTemplate);
        }
        vRMLNodeTemplate = ((SAIProtoDeclaration)x3DProtoDeclaration).getInternalDecl();
        this.scene.addTemplate(vRMLNodeTemplate);
    }

    public void removeProtoDeclaration(String string) {
        SAIProtoDeclaration sAIProtoDeclaration = (SAIProtoDeclaration)this.protoObjectMap.remove(string);
        if (sAIProtoDeclaration != null) {
            VRMLNodeTemplate vRMLNodeTemplate = sAIProtoDeclaration.getInternalDecl();
            this.scene.removeTemplate(vRMLNodeTemplate);
        }
    }

    public String[] getExternProtoNames() {
        String[] stringArray = null;
        if (!this.externObjectMap.isEmpty()) {
            Set set = this.externObjectMap.keySet();
            stringArray = new String[set.size()];
            set.toArray(stringArray);
        }
        return stringArray;
    }

    public X3DExternProtoDeclaration getExternProtoDeclaration(String string) {
        return (X3DExternProtoDeclaration)this.externObjectMap.get(string);
    }

    public void updateExternProtoDeclaration(String string, X3DExternProtoDeclaration x3DExternProtoDeclaration) {
        VRMLNodeTemplate vRMLNodeTemplate;
        SAIProtoDeclaration sAIProtoDeclaration = (SAIProtoDeclaration)this.externObjectMap.put(string, x3DExternProtoDeclaration);
        if (sAIProtoDeclaration != null) {
            vRMLNodeTemplate = sAIProtoDeclaration.getInternalDecl();
            this.scene.removeTemplate(vRMLNodeTemplate);
        }
        vRMLNodeTemplate = ((SAIProtoDeclaration)x3DExternProtoDeclaration).getInternalDecl();
        this.scene.addTemplate(vRMLNodeTemplate);
    }

    public void removeExternProtoDeclaration(String string) {
        SAIProtoDeclaration sAIProtoDeclaration = (SAIProtoDeclaration)this.externObjectMap.remove(string);
        if (sAIProtoDeclaration != null) {
            VRMLNodeTemplate vRMLNodeTemplate = sAIProtoDeclaration.getInternalDecl();
            this.scene.removeTemplate(vRMLNodeTemplate);
        }
    }

    public String[] getNamedNodes() {
        Map map = this.scene.getDEFNodes();
        Set set = map.keySet();
        String[] stringArray = new String[set.size()];
        set.toArray(stringArray);
        return stringArray;
    }

    public X3DNode getNamedNode(String string) {
        Map map = this.scene.getDEFNodes();
        if (string == null || !map.containsKey(string)) {
            return null;
        }
        VRMLNodeType vRMLNodeType = (VRMLNodeType)map.get(string);
        X3DNode x3DNode = (X3DNode)this.nodeWrapperMap.get(vRMLNodeType);
        if (x3DNode == null) {
            x3DNode = new BaseNode(vRMLNodeType, this.fieldQueue, this.fieldFactory, this.fieldAccessListener);
            ((BaseNode)x3DNode).setAccessValid(true);
            this.nodeWrapperMap.put(vRMLNodeType, x3DNode);
            this.nodeWrapperList.add(x3DNode);
        }
        return x3DNode;
    }

    public void removeNamedNode(String string) {
        this.scene.getDEFNodes().remove(string);
    }

    public void updateNamedNode(String string, X3DNode x3DNode) {
        BaseNode baseNode = (BaseNode)x3DNode;
        this.scene.getDEFNodes().put(string, baseNode);
    }

    public X3DNode getImportedNode(String string) {
        VRMLNodeType vRMLNodeType = (VRMLNodeType)this.scene.getDEFNodes().get(string);
        if (vRMLNodeType == null) {
            throw new InvalidNodeException(string);
        }
        X3DNode x3DNode = (X3DNode)this.nodeWrapperMap.get(vRMLNodeType);
        if (x3DNode == null) {
            x3DNode = new BaseNode(vRMLNodeType, this.fieldQueue, this.fieldFactory, this.fieldAccessListener);
            ((BaseNode)x3DNode).setAccessValid(true);
            this.nodeWrapperMap.put(vRMLNodeType, x3DNode);
            this.nodeWrapperList.add(x3DNode);
        }
        return x3DNode;
    }

    public void removeImportedNode(String string) {
        this.scene.getImports().remove(string);
    }

    public void updateImportedNode(String string, String string2, X3DNode x3DNode) {
        VRMLNodeType vRMLNodeType;
        VRMLScene vRMLScene;
        VRMLNodeType vRMLNodeType2 = ((BaseNode)x3DNode).getImplNode();
        while (vRMLNodeType2 instanceof VRMLProtoInstance) {
            vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
        }
        if (vRMLNodeType2 instanceof VRMLInlineNodeType) {
            VRMLInlineNodeType vRMLInlineNodeType = (VRMLInlineNodeType)vRMLNodeType2;
            vRMLScene = (VRMLScene)vRMLInlineNodeType.getContainedScene();
            vRMLNodeType = (VRMLNodeType)((Object)vRMLScene.getExports());
            if (vRMLNodeType == null) {
                throw new InvalidNodeException(string + " not found in target scene.");
            }
        } else {
            throw new IllegalArgumentException("Designated node is not an Inline node");
        }
        vRMLScene.getImports().put(string2, vRMLNodeType);
    }

    public X3DNode[] getRootNodes() {
        VRMLNodeType[] vRMLNodeTypeArray;
        int n;
        VRMLNodeType vRMLNodeType;
        VRMLNode vRMLNode = this.scene.getRootNode();
        if (vRMLNode instanceof VRMLGroupingNodeType) {
            vRMLNodeType = (VRMLGroupingNodeType)vRMLNode;
            n = vRMLNodeType.getChildrenSize();
            vRMLNodeTypeArray = vRMLNodeType.getChildren();
        } else {
            vRMLNodeType = (VRMLWorldRootNodeType)vRMLNode;
            n = vRMLNodeType.getChildrenSize();
            vRMLNodeTypeArray = vRMLNodeType.getChildren();
        }
        vRMLNodeType = new X3DNode[n];
        for (int i = 0; i < n; ++i) {
            vRMLNodeType[i] = (X3DNode)this.nodeWrapperMap.get(vRMLNodeTypeArray[i]);
            if (vRMLNodeType[i] != null) continue;
            vRMLNodeType[i] = new BaseNode(vRMLNodeTypeArray[i], this.fieldQueue, this.fieldFactory, this.fieldAccessListener);
            ((BaseNode)((Object)vRMLNodeType[i])).setAccessValid(true);
            this.nodeWrapperMap.put(vRMLNodeTypeArray[i], vRMLNodeType[i]);
        }
        return vRMLNodeType;
    }

    public X3DNode createNode(String string) {
        VRMLNodeType vRMLNodeType = (VRMLNodeType)this.nodeFactory.createVRMLNode(string, false);
        if (vRMLNodeType == null) {
            throw new InvalidNodeException("The node \"" + string + "\" is not " + "valid for X3D, given the declared profile and components");
        }
        vRMLNodeType.setErrorReporter(this.errorReporter);
        if (vRMLNodeType instanceof VRMLExternalNodeType) {
            ((VRMLExternalNodeType)((Object)vRMLNodeType)).setWorldUrl(this.url);
        }
        vRMLNodeType.setFrameStateManager(this.stateManager);
        BaseNode baseNode = new BaseNode(vRMLNodeType, this.fieldQueue, this.fieldFactory, this.fieldAccessListener);
        baseNode.setAccessValid(true);
        return baseNode;
    }

    public X3DProtoInstance createProto(String string) {
        VRMLNodeTemplate vRMLNodeTemplate = this.scene.getNodeTemplate(string);
        if (vRMLNodeTemplate == null) {
            throw new InvalidNodeException("The PROTO declaration \"" + string + "\"is not found in this scene");
        }
        VRMLNodeType vRMLNodeType = (VRMLNodeType)vRMLNodeTemplate.createNewInstance(this.scene.getRootNode(), false);
        if (vRMLNodeType == null) {
            return null;
        }
        vRMLNodeType.setFrameStateManager(this.stateManager);
        SAIProtoInstanceImpl sAIProtoInstanceImpl = new SAIProtoInstanceImpl(vRMLNodeType, this.fieldQueue, this.fieldFactory, this.fieldAccessListener);
        sAIProtoInstanceImpl.setAccessValid(true);
        return sAIProtoInstanceImpl;
    }

    BasicScene getInternalScene() {
        return this.scene;
    }

    void updateEventOuts() {
        int n = this.nodeWrapperList.size();
        for (int i = 0; i < n; ++i) {
            BaseNode baseNode = (BaseNode)this.nodeWrapperList.get(i);
            baseNode.updateFields();
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }
}

