/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.sai;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.sai.BaseField;
import org.web3d.vrml.scripting.sai.FieldAccessListener;
import org.web3d.vrml.scripting.sai.FieldFactory;
import org.web3d.vrml.scripting.sai.NodeField;
import org.web3d.vrml.scripting.sai.SAIFieldDefinition;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidNodeException;
import org.web3d.x3d.sai.InvalidOperationTimingException;
import org.web3d.x3d.sai.X3DField;
import org.web3d.x3d.sai.X3DFieldDefinition;
import org.web3d.x3d.sai.X3DMetadataObject;
import org.web3d.x3d.sai.X3DNode;

class BaseNode
implements X3DNode {
    private static final String NODE_DISPOSED_MSG = "The node has been disposed. No valid handle exists";
    private static final String INVALID_TIMING_ERR = "You are attempting to access a node when not permitted by the specification. Please see 19775 Part 2, 4.8.3.7 User code lifecycle for more information";
    protected VRMLNodeType realNode;
    protected HashMap fieldRefMap;
    protected ReferenceQueue fieldQueue;
    protected boolean accessPermitted;
    private HashSet accessedFieldsSet;
    private String[] accessedFieldsList;
    private FieldFactory fieldFactory;
    private FieldAccessListener fieldAccessListener;
    private X3DFieldDefinition[] fieldList;

    public BaseNode(VRMLNodeType vRMLNodeType, ReferenceQueue referenceQueue, FieldFactory fieldFactory, FieldAccessListener fieldAccessListener) {
        this.realNode = vRMLNodeType;
        this.fieldQueue = referenceQueue;
        this.fieldFactory = fieldFactory;
        this.fieldAccessListener = fieldAccessListener;
        this.accessedFieldsSet = new HashSet();
        this.fieldRefMap = new HashMap();
        this.accessedFieldsList = new String[1];
        this.accessPermitted = false;
        this.realNode.updateRefCount(true);
    }

    public void setMetadata(X3DMetadataObject x3DMetadataObject) throws InvalidNodeException {
        this.checkAccess();
    }

    public X3DMetadataObject getMetadata() throws InvalidNodeException {
        this.checkAccess();
        return null;
    }

    public String getNodeName() throws InvalidNodeException {
        this.checkAccess();
        return this.realNode.getVRMLNodeName();
    }

    public X3DFieldDefinition[] getFieldDefinitions() throws InvalidNodeException {
        this.checkAccess();
        if (this.fieldList == null) {
            VRMLFieldDeclaration vRMLFieldDeclaration;
            ArrayList<SAIFieldDefinition> arrayList = new ArrayList<SAIFieldDefinition>();
            int n = 0;
            while ((vRMLFieldDeclaration = this.realNode.getFieldDeclaration(n)) != null) {
                arrayList.add(new SAIFieldDefinition(vRMLFieldDeclaration.getName(), vRMLFieldDeclaration.getAccessType(), vRMLFieldDeclaration.getFieldType()));
                ++n;
            }
            this.fieldList = new SAIFieldDefinition[arrayList.size()];
            arrayList.toArray(this.fieldList);
        }
        return this.fieldList;
    }

    public void realize() throws InvalidNodeException {
        this.checkAccess();
        this.updateNodeAndChildren();
        this.realNode.setupFinished();
    }

    public boolean isRealized() throws InvalidNodeException {
        if (this.realNode == null) {
            throw new InvalidNodeException(NODE_DISPOSED_MSG);
        }
        return this.realNode.isSetupFinished();
    }

    public int[] getNodeType() throws InvalidNodeException {
        this.checkAccess();
        System.out.println("SAI X3DNode.getNodeType() not implemented yet");
        return null;
    }

    public X3DField getField(String string) throws InvalidFieldException, InvalidNodeException {
        BaseField baseField = null;
        SoftReference<BaseField> softReference = (SoftReference<BaseField>)this.fieldRefMap.get(string);
        if (softReference != null) {
            baseField = (BaseField)softReference.get();
        }
        if (baseField == null) {
            baseField = this.fieldFactory.createField(this.realNode, string, true, false, this.fieldQueue);
            if (baseField == null) {
                throw new InvalidFieldException(this.realNode.getVRMLNodeName() + " does not have a field named " + string);
            }
            baseField.setFieldAccessListener(this.fieldAccessListener);
            softReference = new SoftReference<BaseField>(baseField, this.fieldQueue);
            this.fieldRefMap.put(string, softReference);
            this.accessedFieldsSet.add(string);
        }
        baseField.updateField();
        baseField.setAccessValid(this.accessPermitted);
        int n = this.accessedFieldsSet.size();
        if (this.accessedFieldsList.length < n) {
            this.accessedFieldsList = new String[n + 1];
        }
        this.accessedFieldsSet.toArray(this.accessedFieldsList);
        return baseField;
    }

    public void dispose() throws InvalidNodeException {
        this.checkAccess();
        this.realNode.updateRefCount(false);
        this.realNode = null;
        this.fieldList = null;
        this.fieldRefMap = null;
        this.fieldQueue = null;
        this.fieldFactory = null;
    }

    public int hashCode() {
        return this.realNode.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof BaseNode)) {
            return false;
        }
        return ((BaseNode)object).realNode == this.realNode;
    }

    public String toString() throws InvalidNodeException {
        StringBuffer stringBuffer = new StringBuffer(this.realNode.getVRMLNodeName());
        stringBuffer.append(" {");
        stringBuffer.append("\n}");
        return stringBuffer.toString();
    }

    protected void checkAccess() {
        if (this.realNode == null) {
            throw new InvalidNodeException(NODE_DISPOSED_MSG);
        }
        if (!this.accessPermitted) {
            throw new InvalidOperationTimingException(INVALID_TIMING_ERR);
        }
    }

    VRMLNodeType getImplNode() {
        return this.realNode;
    }

    void updateNodeAndChildren() {
        int n = this.accessedFieldsSet.size();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            String string = this.accessedFieldsList[i];
            SoftReference softReference = (SoftReference)this.fieldRefMap.get(string);
            if (softReference == null) continue;
            BaseField baseField = (BaseField)softReference.get();
            if (baseField == null) {
                this.fieldRefMap.remove(string);
                continue;
            }
            if (baseField instanceof NodeField) {
                ((NodeField)((Object)baseField)).updateNodeAndChildren();
                continue;
            }
            if (!baseField.hasChanged()) continue;
            baseField.updateNode();
        }
    }

    void updateFields() {
        int n = this.accessedFieldsSet.size();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            String string = this.accessedFieldsList[i];
            SoftReference softReference = (SoftReference)this.fieldRefMap.get(string);
            if (softReference == null) continue;
            BaseField baseField = (BaseField)softReference.get();
            if (baseField == null) {
                this.fieldRefMap.remove(string);
                continue;
            }
            if (baseField instanceof NodeField) {
                ((NodeField)((Object)baseField)).updateFieldAndChildren();
                continue;
            }
            baseField.updateField();
        }
    }

    void setAccessValid(boolean bl) {
        this.accessPermitted = bl;
        int n = this.accessedFieldsSet.size();
        if (n == 0) {
            return;
        }
        if (this.accessedFieldsList.length < n) {
            this.accessedFieldsList = new String[n + 1];
            this.accessedFieldsSet.toArray(this.accessedFieldsList);
        }
        for (int i = 0; i < n; ++i) {
            String string = this.accessedFieldsList[i];
            SoftReference softReference = (SoftReference)this.fieldRefMap.get(string);
            if (softReference == null) continue;
            BaseField baseField = (BaseField)softReference.get();
            if (baseField == null) {
                this.fieldRefMap.remove(string);
                continue;
            }
            baseField.setAccessValid(bl);
        }
    }
}

