/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.sai;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;
import org.web3d.browser.BrowserCore;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.SceneMetaData;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.lang.WriteableSceneMetaData;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLWorldRootNodeType;
import org.web3d.vrml.nodes.loader.WorldLoaderManager;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.nodes.runtime.ViewpointManager;
import org.web3d.vrml.scripting.browser.X3DCommonBrowser;
import org.web3d.vrml.scripting.sai.BaseExecutionContext;
import org.web3d.vrml.scripting.sai.FieldAccessListener;
import org.web3d.vrml.scripting.sai.FieldFactory;
import org.web3d.vrml.scripting.sai.SAIComponentInfo;
import org.web3d.vrml.scripting.sai.SAIProfileInfo;
import org.web3d.vrml.scripting.sai.SAIVRMLScene;
import org.web3d.vrml.scripting.sai.WorldScene;
import org.web3d.x3d.sai.Browser;
import org.web3d.x3d.sai.ComponentInfo;
import org.web3d.x3d.sai.InvalidBrowserException;
import org.web3d.x3d.sai.InvalidDocumentException;
import org.web3d.x3d.sai.InvalidOperationTimingException;
import org.web3d.x3d.sai.InvalidURLException;
import org.web3d.x3d.sai.InvalidX3DException;
import org.web3d.x3d.sai.NotSupportedException;
import org.web3d.x3d.sai.ProfileInfo;
import org.web3d.x3d.sai.X3DExecutionContext;
import org.web3d.x3d.sai.X3DScene;

class InternalBrowser
implements Browser {
    private static final String INVALID_BROWSER_MSG = "Cannot access the Browser object. It has been disposed of";
    private static final String NULL_CREATE_SCENE_ARGS_MSG = "Both arguments are null. 19775-2, 6.3.11 requires that one or other argument is to be non-null.";
    private static final String DEFAULT_PROFILE = "Core";
    private ErrorReporter errorReporter;
    private FieldFactory fieldFactory;
    private ReferenceQueue fieldQueue;
    private VRMLExecutionSpace execSpace;
    private X3DCommonBrowser realBrowser;
    private BasicScene internalScene;
    private BaseExecutionContext saiScene;
    private RouteManager routeManager;
    private FrameStateManager stateManager;
    private ProfileInfo[] profileListing;
    private ComponentInfo[] componentListing;
    private HashMap nameToProfileMap;
    private HashMap nameToComponentMap;
    private FieldAccessListener fieldAccessListener;
    private Map renderingProperties;
    private Map browserProperties;
    private BrowserCore browserCore;

    InternalBrowser(VRMLExecutionSpace vRMLExecutionSpace, BrowserCore browserCore, ViewpointManager viewpointManager, RouteManager routeManager, FrameStateManager frameStateManager, WorldLoaderManager worldLoaderManager, ReferenceQueue referenceQueue, FieldFactory fieldFactory, FieldAccessListener fieldAccessListener) {
        this.execSpace = vRMLExecutionSpace;
        this.browserCore = browserCore;
        this.fieldQueue = referenceQueue;
        this.fieldFactory = fieldFactory;
        this.stateManager = frameStateManager;
        this.fieldAccessListener = fieldAccessListener;
        this.internalScene = vRMLExecutionSpace.getContainedScene();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.realBrowser = new X3DCommonBrowser(browserCore, viewpointManager, routeManager, frameStateManager, worldLoaderManager);
        this.realBrowser.setErrorReporter(this.errorReporter);
        this.nameToProfileMap = new HashMap();
        this.nameToComponentMap = new HashMap();
        HashMap hashMap = new HashMap();
        this.browserProperties = Collections.unmodifiableMap(hashMap);
        HashMap hashMap2 = new HashMap();
        this.renderingProperties = Collections.unmodifiableMap(hashMap2);
        VRMLNodeFactory vRMLNodeFactory = this.internalScene.getNodeFactory();
        org.web3d.vrml.lang.ComponentInfo[] componentInfoArray = vRMLNodeFactory.getAvailableComponents();
        this.componentListing = new ComponentInfo[componentInfoArray.length];
        for (int i = 0; i < componentInfoArray.length; ++i) {
            this.componentListing[i] = new SAIComponentInfo(componentInfoArray[i]);
            this.nameToComponentMap.put(componentInfoArray[i].getName(), this.componentListing[i]);
        }
        org.web3d.vrml.lang.ProfileInfo[] profileInfoArray = vRMLNodeFactory.getAvailableProfiles();
        this.profileListing = new ProfileInfo[profileInfoArray.length];
        ProfileInfo profileInfo = null;
        SceneMetaData sceneMetaData = this.internalScene.getMetaData();
        String string = sceneMetaData.getProfileName();
        for (int i = 0; i < profileInfoArray.length; ++i) {
            this.profileListing[i] = new SAIProfileInfo(profileInfoArray[i]);
            String string2 = profileInfoArray[i].getName();
            if (string2.equals(string)) {
                profileInfo = this.profileListing[i];
            }
            this.nameToProfileMap.put(string2, this.profileListing[i]);
        }
        this.saiScene = this.internalScene instanceof VRMLScene ? new WorldScene(vRMLExecutionSpace, routeManager, this.stateManager, profileInfo, this.fieldQueue, this.fieldFactory, this.fieldAccessListener) : new BaseExecutionContext(vRMLExecutionSpace, routeManager, this.stateManager, profileInfo, this.fieldQueue, this.fieldFactory, this.fieldAccessListener);
    }

    public String getName() throws InvalidBrowserException {
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return this.realBrowser.getName();
    }

    public String getVersion() throws InvalidBrowserException {
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return this.realBrowser.getVersion();
    }

    public ProfileInfo[] getSupportedProfiles() throws InvalidBrowserException {
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return this.profileListing;
    }

    public ProfileInfo getProfile(String string) throws InvalidBrowserException, NotSupportedException {
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        ProfileInfo profileInfo = (ProfileInfo)this.nameToProfileMap.get(string);
        if (profileInfo == null) {
            throw new NotSupportedException("Profile not supported by Xj3D: " + string);
        }
        return profileInfo;
    }

    public ComponentInfo[] getSupportedComponents() throws InvalidBrowserException {
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return this.componentListing;
    }

    public ComponentInfo getComponent(String string, int n) throws InvalidBrowserException, NotSupportedException {
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        ComponentInfo componentInfo = (ComponentInfo)this.nameToComponentMap.get(string);
        if (componentInfo == null) {
            throw new NotSupportedException("Component not supported by Xj3D: " + string);
        }
        if (n <= componentInfo.getLevel()) {
            throw new NotSupportedException("Component level higher than that supported: " + string + ":" + n);
        }
        componentInfo = new SAIComponentInfo(componentInfo, n);
        return componentInfo;
    }

    public X3DExecutionContext getExecutionContext() throws InvalidBrowserException {
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return this.saiScene;
    }

    public X3DScene createScene(ProfileInfo profileInfo, ComponentInfo[] componentInfoArray) throws InvalidBrowserException {
        VRMLNodeFactory vRMLNodeFactory;
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        if (profileInfo == null && (componentInfoArray == null || componentInfoArray.length == 0)) {
            throw new IllegalArgumentException(NULL_CREATE_SCENE_ARGS_MSG);
        }
        VRMLNodeFactory vRMLNodeFactory2 = this.internalScene.getNodeFactory();
        try {
            vRMLNodeFactory = (VRMLNodeFactory)vRMLNodeFactory2.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InvalidBrowserException("Error cloning node factory");
        }
        String string = profileInfo == null ? DEFAULT_PROFILE : profileInfo.getName();
        vRMLNodeFactory.setProfile(string);
        int n = componentInfoArray == null ? 0 : componentInfoArray.length;
        for (int i = 0; i < n; ++i) {
            vRMLNodeFactory.addComponent(componentInfoArray[i].getName(), componentInfoArray[i].getLevel());
        }
        VRMLWorldRootNodeType vRMLWorldRootNodeType = (VRMLWorldRootNodeType)vRMLNodeFactory.createVRMLNode("WorldRoot", false);
        vRMLWorldRootNodeType.setFrameStateManager(this.stateManager);
        vRMLWorldRootNodeType.setErrorReporter(this.errorReporter);
        vRMLWorldRootNodeType.setupFinished();
        WorldScene worldScene = new WorldScene(vRMLWorldRootNodeType, this.routeManager, this.stateManager, profileInfo, componentInfoArray, this.fieldQueue, this.fieldFactory, this.fieldAccessListener);
        WriteableSceneMetaData writeableSceneMetaData = new WriteableSceneMetaData("3.0", false, 0);
        SAIVRMLScene sAIVRMLScene = new SAIVRMLScene(writeableSceneMetaData);
        sAIVRMLScene.setNodeFactory(vRMLNodeFactory);
        sAIVRMLScene.setWorldRootURL(this.realBrowser.getWorldURL());
        sAIVRMLScene.setRootNode(vRMLWorldRootNodeType);
        vRMLWorldRootNodeType.setContainedScene(sAIVRMLScene);
        return worldScene;
    }

    public float getCurrentSpeed() throws InvalidBrowserException {
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return this.realBrowser.getCurrentSpeed();
    }

    public float getCurrentFrameRate() throws InvalidBrowserException {
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return this.realBrowser.getCurrentFrameRate();
    }

    public void replaceWorld(X3DScene x3DScene) throws InvalidBrowserException {
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        VRMLScene vRMLScene = (VRMLScene)((WorldScene)x3DScene).getInternalScene();
        this.realBrowser.replaceWorld(vRMLScene);
    }

    public void loadURL(String[] stringArray, Map map) throws InvalidBrowserException, InvalidURLException {
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.realBrowser.loadURL(stringArray, map);
    }

    public String getDescription() throws InvalidBrowserException {
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return this.realBrowser.getDescription();
    }

    public void setDescription(String string) throws InvalidBrowserException {
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.realBrowser.setDescription(string);
    }

    public X3DScene createX3DFromString(String string) throws InvalidBrowserException, InvalidX3DException {
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        WorldScene worldScene = null;
        try {
            VRMLScene vRMLScene = this.realBrowser.createX3DFromString(string);
            VRMLExecutionSpace vRMLExecutionSpace = (VRMLExecutionSpace)((Object)vRMLScene.getRootNode());
            SceneMetaData sceneMetaData = vRMLScene.getMetaData();
            String string2 = sceneMetaData.getProfileName();
            ProfileInfo profileInfo = (ProfileInfo)this.nameToProfileMap.get(string2);
            worldScene = new WorldScene(vRMLExecutionSpace, this.routeManager, this.stateManager, profileInfo, this.fieldQueue, this.fieldFactory, this.fieldAccessListener);
        }
        catch (Exception exception) {
            this.errorReporter.errorReport("Error parsing string", exception);
        }
        return worldScene;
    }

    public X3DScene createX3DFromStream(InputStream inputStream) throws InvalidBrowserException, InvalidX3DException, IOException {
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        WorldScene worldScene = null;
        try {
            VRMLScene vRMLScene = this.realBrowser.createX3DFromStream(inputStream);
            VRMLExecutionSpace vRMLExecutionSpace = (VRMLExecutionSpace)((Object)vRMLScene.getRootNode());
            SceneMetaData sceneMetaData = vRMLScene.getMetaData();
            String string = sceneMetaData.getProfileName();
            ProfileInfo profileInfo = (ProfileInfo)this.nameToProfileMap.get(string);
            worldScene = new WorldScene(vRMLExecutionSpace, this.routeManager, this.stateManager, profileInfo, this.fieldQueue, this.fieldFactory, this.fieldAccessListener);
        }
        catch (Exception exception) {
            this.errorReporter.errorReport("Error parsing string", exception);
        }
        return worldScene;
    }

    public X3DScene createX3DFromURL(String[] stringArray) throws InvalidBrowserException, InvalidURLException, InvalidX3DException {
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        WorldScene worldScene = null;
        try {
            VRMLScene vRMLScene = this.realBrowser.createX3DFromURL(stringArray);
            VRMLExecutionSpace vRMLExecutionSpace = (VRMLExecutionSpace)((Object)vRMLScene.getRootNode());
            SceneMetaData sceneMetaData = vRMLScene.getMetaData();
            String string = sceneMetaData.getProfileName();
            ProfileInfo profileInfo = (ProfileInfo)this.nameToProfileMap.get(string);
            worldScene = new WorldScene(vRMLExecutionSpace, this.routeManager, this.stateManager, profileInfo, this.fieldQueue, this.fieldFactory, this.fieldAccessListener);
        }
        catch (Exception exception) {
            this.errorReporter.errorReport("Error parsing string", exception);
        }
        return worldScene;
    }

    public X3DScene importDocument(Node node) throws InvalidBrowserException, InvalidDocumentException, NotSupportedException {
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        VRMLScene vRMLScene = this.realBrowser.importDocument(node);
        VRMLExecutionSpace vRMLExecutionSpace = (VRMLExecutionSpace)((Object)vRMLScene.getRootNode());
        SceneMetaData sceneMetaData = vRMLScene.getMetaData();
        String string = sceneMetaData.getProfileName();
        ProfileInfo profileInfo = (ProfileInfo)this.nameToProfileMap.get(string);
        WorldScene worldScene = new WorldScene(vRMLExecutionSpace, this.routeManager, this.stateManager, profileInfo, this.fieldQueue, this.fieldFactory, this.fieldAccessListener);
        return worldScene;
    }

    public void print(Object object) throws InvalidBrowserException {
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        if (object != null) {
            this.errorReporter.partialReport(object.toString());
        }
    }

    public void println(Object object) throws InvalidBrowserException {
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        if (object != null) {
            this.errorReporter.messageReport(object.toString());
        }
    }

    public void nextViewpoint() throws InvalidBrowserException {
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.realBrowser.nextViewpoint();
    }

    public void previousViewpoint() throws InvalidBrowserException {
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.realBrowser.previousViewpoint();
    }

    public void firstViewpoint() throws InvalidBrowserException {
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.realBrowser.firstViewpoint();
    }

    public void lastViewpoint() throws InvalidBrowserException {
        if (this.realBrowser == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.realBrowser.lastViewpoint();
    }

    public Map getRenderingProperties() throws InvalidBrowserException, InvalidOperationTimingException {
        return this.renderingProperties;
    }

    public Map getBrowserProperties() throws InvalidBrowserException, InvalidOperationTimingException {
        return this.browserProperties;
    }

    void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
        this.realBrowser.setErrorReporter(this.errorReporter);
    }

    void updateEventOuts() {
        this.saiScene.updateEventOuts();
    }

    FieldFactory getFieldFactory() {
        return this.fieldFactory;
    }

    ReferenceQueue getSharedFieldQueue() {
        return this.fieldQueue;
    }
}

