/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.sai;

import java.lang.ref.ReferenceQueue;
import java.util.WeakHashMap;
import org.web3d.browser.BrowserCore;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.loader.WorldLoaderManager;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.nodes.runtime.ViewpointManager;
import org.web3d.vrml.scripting.sai.DefaultFieldFactory;
import org.web3d.vrml.scripting.sai.FieldAccessListener;
import org.web3d.vrml.scripting.sai.FieldFactory;
import org.web3d.vrml.scripting.sai.InternalBrowser;

class JavaSAIScriptBrowserFactory {
    private ErrorReporter errorReporter;
    private BrowserCore core;
    private RouteManager routeManager;
    private ViewpointManager viewpointManager;
    private FrameStateManager stateManager;
    private WeakHashMap browsers;
    private WorldLoaderManager loadManager;
    private FieldFactory fieldFactory;

    JavaSAIScriptBrowserFactory(BrowserCore browserCore, ViewpointManager viewpointManager, RouteManager routeManager, WorldLoaderManager worldLoaderManager, FrameStateManager frameStateManager) {
        this.core = browserCore;
        this.routeManager = routeManager;
        this.loadManager = worldLoaderManager;
        this.stateManager = frameStateManager;
        this.viewpointManager = viewpointManager;
        this.browsers = new WeakHashMap();
        this.fieldFactory = new DefaultFieldFactory();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public InternalBrowser getBrowser(VRMLExecutionSpace vRMLExecutionSpace, FieldAccessListener fieldAccessListener) {
        InternalBrowser internalBrowser = (InternalBrowser)this.browsers.get(vRMLExecutionSpace);
        if (internalBrowser == null) {
            internalBrowser = new InternalBrowser(vRMLExecutionSpace, this.core, this.viewpointManager, this.routeManager, this.stateManager, this.loadManager, new ReferenceQueue(), this.fieldFactory, fieldAccessListener);
            internalBrowser.setErrorReporter(this.errorReporter);
            this.browsers.put(vRMLExecutionSpace, internalBrowser);
        }
        return internalBrowser;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }
}

