/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.sai;

import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.sai.BaseMField;
import org.web3d.x3d.sai.MFBool;

class SAIMFBool
extends BaseMField
implements MFBool {
    private static final int ARRAY_INC = 8;
    private boolean[] localValue;

    SAIMFBool(VRMLNodeType vRMLNodeType, int n, boolean bl) {
        super(vRMLNodeType, n, bl);
    }

    public void append(boolean bl) {
        this.checkAccess(true);
        if (this.localValue == null || this.localValue.length == this.numElements) {
            boolean[] blArray = new boolean[this.numElements + 8];
            System.arraycopy(this.localValue, 0, blArray, 0, this.numElements);
            this.localValue = blArray;
        }
        this.localValue[this.numElements] = bl;
        ++this.numElements;
        this.dataChanged = true;
    }

    public void insertValue(int n, boolean bl) throws ArrayIndexOutOfBoundsException {
        this.checkAccess(true);
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Attempting to insert a value past the end of the existing number of elements.");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("The provided index is negative.");
        }
        if (this.localValue == null || this.localValue.length == this.numElements) {
            boolean[] blArray = new boolean[this.numElements + 8];
            System.arraycopy(this.localValue, 0, blArray, 0, this.numElements);
            this.localValue = blArray;
        }
        System.arraycopy(this.localValue, n, this.localValue, n + 1, this.numElements - n);
        this.localValue[n] = bl;
        ++this.numElements;
        this.dataChanged = true;
    }

    public void removeValue(int n) throws ArrayIndexOutOfBoundsException {
        this.checkAccess(true);
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Attempting to remove a value past the end of the existing number of elements.");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("The provided index is negative.");
        }
        System.arraycopy(this.localValue, n, this.localValue, n - 1, this.numElements - n + 1);
        --this.numElements;
        this.dataChanged = true;
    }

    public void getValue(boolean[] blArray) {
        this.checkAccess(false);
        if (this.localValue != null) {
            System.arraycopy(this.localValue, 0, blArray, 0, this.numElements);
        }
    }

    public boolean get1Value(int n) {
        this.checkAccess(false);
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Attempting to fetch a value past the end of the existing number of elements.");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("The provided index is negative.");
        }
        return this.localValue[n];
    }

    public void setValue(int n, boolean[] blArray) {
        this.checkAccess(true);
        if (this.localValue == null || this.localValue.length < n) {
            this.localValue = new boolean[n];
        }
        this.numElements = n;
        System.arraycopy(blArray, 0, this.localValue, 0, n);
        this.dataChanged = true;
    }

    public void set1Value(int n, boolean bl) throws ArrayIndexOutOfBoundsException {
        this.checkAccess(true);
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Attempting to set a value past the end of the existing number of elements.");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("The provided index is negative.");
        }
        this.localValue[n] = bl;
        this.dataChanged = true;
    }

    void updateNode() {
        this.node.setValue(this.fieldIndex, this.localValue, this.numElements);
        this.dataChanged = false;
    }

    void updateField() {
        if (!this.isReadable()) {
            return;
        }
        VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
        if (this.localValue == null || this.localValue.length < vRMLFieldData.numElements) {
            this.localValue = new boolean[vRMLFieldData.numElements];
        }
        this.numElements = vRMLFieldData.numElements;
        if (this.numElements != 0) {
            System.arraycopy(vRMLFieldData.booleanArrayValue, 0, this.localValue, 0, this.numElements);
        }
        this.dataChanged = false;
    }
}

