/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.sai;

import java.lang.ref.ReferenceQueue;
import java.util.Iterator;
import java.util.List;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.lang.VRMLNodeTemplate;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.scripting.sai.FieldAccessListener;
import org.web3d.vrml.scripting.sai.FieldFactory;
import org.web3d.vrml.scripting.sai.SAIFieldDefinition;
import org.web3d.vrml.scripting.sai.SAIProtoInstanceImpl;
import org.web3d.x3d.sai.InvalidNodeException;
import org.web3d.x3d.sai.X3DFieldDefinition;
import org.web3d.x3d.sai.X3DProtoDeclaration;
import org.web3d.x3d.sai.X3DProtoInstance;

class SAIProtoDeclaration
implements X3DProtoDeclaration {
    private static final String DISPOSED_MSG = "This proto instance has been disposed of";
    private final String name;
    private final X3DFieldDefinition[] fields;
    private VRMLExecutionSpace executionSpace;
    private VRMLNodeTemplate protoDecl;
    private ReferenceQueue fieldQueue;
    private FieldFactory fieldFactory;
    private FieldAccessListener fieldAccessListener;

    SAIProtoDeclaration(VRMLNodeTemplate vRMLNodeTemplate, VRMLExecutionSpace vRMLExecutionSpace, ReferenceQueue referenceQueue, FieldFactory fieldFactory, FieldAccessListener fieldAccessListener) {
        this.protoDecl = vRMLNodeTemplate;
        this.executionSpace = vRMLExecutionSpace;
        this.fieldQueue = referenceQueue;
        this.fieldFactory = fieldFactory;
        this.fieldAccessListener = fieldAccessListener;
        this.name = vRMLNodeTemplate.getVRMLNodeName();
        List list = vRMLNodeTemplate.getAllFields();
        Iterator iterator = list.iterator();
        int n = 0;
        this.fields = new X3DFieldDefinition[list.size()];
        while (iterator.hasNext()) {
            VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)iterator.next();
            this.fields[n] = new SAIFieldDefinition(vRMLFieldDeclaration.getName(), vRMLFieldDeclaration.getAccessType(), vRMLFieldDeclaration.getFieldType());
            ++n;
        }
    }

    public String getProtoName() throws InvalidNodeException {
        if (this.protoDecl == null) {
            throw new InvalidNodeException(DISPOSED_MSG);
        }
        return this.name;
    }

    public int[] getNodeType() throws InvalidNodeException {
        if (this.protoDecl == null) {
            throw new InvalidNodeException(DISPOSED_MSG);
        }
        return null;
    }

    public X3DFieldDefinition[] getFieldDefinitions() throws InvalidNodeException {
        if (this.protoDecl == null) {
            throw new InvalidNodeException(DISPOSED_MSG);
        }
        return this.fields;
    }

    public X3DProtoInstance createInstance() throws InvalidNodeException {
        if (this.protoDecl == null) {
            throw new InvalidNodeException(DISPOSED_MSG);
        }
        BasicScene basicScene = this.executionSpace.getContainedScene();
        VRMLNode vRMLNode = basicScene.getRootNode();
        VRMLNodeType vRMLNodeType = (VRMLNodeType)this.protoDecl.createNewInstance(vRMLNode, false);
        if (vRMLNodeType == null) {
            return null;
        }
        SAIProtoInstanceImpl sAIProtoInstanceImpl = new SAIProtoInstanceImpl((VRMLProtoInstance)vRMLNodeType, this.fieldQueue, this.fieldFactory, this.fieldAccessListener);
        sAIProtoInstanceImpl.setAccessValid(true);
        return sAIProtoInstanceImpl;
    }

    public void dispose() throws InvalidNodeException {
        this.protoDecl = null;
        this.executionSpace = null;
    }

    VRMLNodeTemplate getInternalDecl() {
        return this.protoDecl;
    }
}

