/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.position;

import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.position.DisplayPanel;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.util.coord.egm96.EGM96Util;

@PluginDescription(name="Absolute Location Display", icon="pt/lsts/neptus/plugins/position/position.png", description="Displays the current vehicle's absolute location (WGS84 coordinates)")
public class AbsLatLonDepth
extends ConsolePanel
implements ConfigurationListener,
IPeriodicUpdates,
NeptusMessageListener {
    private long lastUpdate = 0L;
    @NeptusProperty(name="Update interval", description="Interval between updates in milliseconds")
    public long millisBetweenUpdates = 100L;
    @NeptusProperty(name="Orientation", description="How to show the displays")
    public EnOrientation orientation = EnOrientation.Vertical;
    @NeptusProperty(name="Show Seconds", description="Also display seconds in coordinates")
    public boolean showSeconds = false;
    @NeptusProperty(name="Z mode", description="How to show the Z coordinate")
    public EnZMode zmode = EnZMode.Depth;
    @NeptusProperty(name="Z relative mode", description="If the Z is relative to the HomeRef")
    public EnZRel isZRel = EnZRel.HomeRef;
    @NeptusProperty(name="Font Size", description="The font size. Use '0' for automatic.")
    public int fontSize = 16;
    private final DisplayPanel displayLat;
    private final DisplayPanel displayLon;
    private final DisplayPanel displayDepth;
    private final DecimalFormat formatter = new DecimalFormat("0.00");
    private IMCMessage estimatedState = null;
    boolean connected = true;

    public AbsLatLonDepth(ConsoleLayout console) {
        super(console);
        this.displayLat = new DisplayPanel(I18n.text((String)"latitude"));
        this.displayLon = new DisplayPanel(I18n.text((String)"longitude"));
        this.displayDepth = new DisplayPanel(I18n.text((String)"altitude"));
        this.displayLat.setFontSize(this.fontSize);
        this.displayLon.setFontSize(this.fontSize);
        this.displayDepth.setFontSize(this.fontSize);
        this.removeAll();
        if (this.orientation == EnOrientation.Horizontal) {
            this.setLayout(new GridLayout(1, 0));
        } else {
            this.setLayout(new GridLayout(0, 1));
        }
        this.add((Component)((Object)this.displayLat));
        this.add((Component)((Object)this.displayLon));
        this.add((Component)((Object)this.displayDepth));
    }

    public String[] getObservedMessages() {
        return new String[]{"EstimatedState"};
    }

    public void messageArrived(IMCMessage message) {
        this.estimatedState = message.cloneMessage();
    }

    public void propertiesChanged() {
        this.removeAll();
        if (this.orientation == EnOrientation.Horizontal) {
            this.setLayout(new GridLayout(1, 0));
        } else {
            this.setLayout(new GridLayout(0, 1));
        }
        this.displayLat.setFontSize(this.fontSize);
        this.displayLon.setFontSize(this.fontSize);
        this.displayDepth.setFontSize(this.fontSize);
        this.add((Component)((Object)this.displayLat));
        this.add((Component)((Object)this.displayLon));
        if (this.zmode != EnZMode.Invisible) {
            this.add((Component)((Object)this.displayDepth));
        }
        switch (this.zmode) {
            case Depth: {
                if (this.isZRel == EnZRel.WGS84) {
                    this.displayDepth.setTitle(I18n.text((String)"depth"));
                    break;
                }
                if (this.isZRel == EnZRel.ASL) {
                    this.displayDepth.setTitle(I18n.text((String)"depth (ASL)"));
                    this.displayDepth.setToolTipText(I18n.text((String)"ASL"));
                    break;
                }
                this.displayDepth.setTitle(I18n.text((String)"depth (Home)"));
                this.displayDepth.setToolTipText(I18n.text((String)"Relative to HomeRef"));
                break;
            }
            case Altitude: {
                if (this.isZRel == EnZRel.WGS84) {
                    this.displayDepth.setTitle(I18n.text((String)"altitude"));
                    break;
                }
                if (this.isZRel == EnZRel.ASL) {
                    this.displayDepth.setTitle(I18n.text((String)"altitude (ASL)"));
                    this.displayDepth.setToolTipText(I18n.text((String)"ASL"));
                    break;
                }
                this.displayDepth.setTitle(I18n.text((String)"altitude (Home)"));
                this.displayDepth.setToolTipText(I18n.text((String)"Relative to HomeRef"));
                break;
            }
        }
        this.invalidate();
        this.revalidate();
    }

    public long millisBetweenUpdates() {
        return this.millisBetweenUpdates;
    }

    public boolean update() {
        if (this.connected && System.currentTimeMillis() - this.lastUpdate > 3000L) {
            this.displayDepth.setFontColor(Color.red.darker());
            this.displayLat.setFontColor(Color.red.darker());
            this.displayLon.setFontColor(Color.red.darker());
            this.connected = false;
        }
        if (!this.connected && System.currentTimeMillis() - this.lastUpdate < 3000L) {
            this.displayDepth.setFontColor(Color.black);
            this.displayLat.setFontColor(Color.black);
            this.displayLon.setFontColor(Color.black);
            this.connected = true;
        }
        try {
            ImcSystem sys = ImcSystemsHolder.lookupSystemByName((String)this.getMainVehicleId());
            if (sys != null) {
                LocationType loc = sys.getLocation();
                long locMillis = sys.getLocationTimeMillis();
                int SYS = 0;
                int EST_STATE = 1;
                int NONE = -1;
                int mode = -1;
                IMCMessage tmpEState = this.estimatedState;
                if (loc == null && tmpEState == null) {
                    mode = NONE;
                } else if (loc != null && tmpEState == null) {
                    mode = SYS;
                } else if (loc != null && tmpEState != null) {
                    mode = locMillis >= tmpEState.getTimestampMillis() ? SYS : EST_STATE;
                }
                double lat = 0.0;
                double lon = 0.0;
                double depth = 0.0;
                if (mode == SYS) {
                    lat = loc.getLatitudeRads();
                    lon = loc.getLongitudeRads();
                    depth = loc.getDepth();
                }
                if (mode != NONE) {
                    switch (this.isZRel) {
                        case ASL: {
                            double alt = -depth;
                            double heightBase = EGM96Util.calcHeight((double)Math.toDegrees(lat), (double)Math.toDegrees(lon));
                            depth = -1.0 * (alt - heightBase);
                            break;
                        }
                        default: {
                            MissionType miss = this.getConsole().getMission();
                            if (miss == null) break;
                            LocationType homeRef = miss.getHomeRef().getNewAbsoluteLatLonDepth();
                            depth -= homeRef.getDepth();
                        }
                    }
                    switch (this.zmode) {
                        case Altitude: {
                            depth = -depth;
                            break;
                        }
                        case Auto: {
                            if (depth < 0.0) {
                                if (this.isZRel == EnZRel.WGS84) {
                                    this.displayDepth.setTitle(I18n.text((String)"altitude"));
                                } else if (this.isZRel == EnZRel.ASL) {
                                    this.displayDepth.setTitle(I18n.text((String)"altitude (ASL)"));
                                    this.displayDepth.setToolTipText(I18n.text((String)"ASL"));
                                } else {
                                    this.displayDepth.setTitle(I18n.text((String)"altitude (Home)"));
                                    this.displayDepth.setToolTipText(I18n.text((String)"Relative to HomeRef"));
                                }
                                depth = -depth;
                                break;
                            }
                            if (this.isZRel == EnZRel.WGS84) {
                                this.displayDepth.setTitle(I18n.text((String)"depth"));
                                break;
                            }
                            if (this.isZRel == EnZRel.ASL) {
                                this.displayDepth.setTitle(I18n.text((String)"depth (ASL)"));
                                this.displayDepth.setToolTipText(I18n.text((String)"ASL"));
                                break;
                            }
                            this.displayDepth.setTitle(I18n.text((String)"depth (Home)"));
                            this.displayDepth.setToolTipText(I18n.text((String)"Relative to HomeRef"));
                            break;
                        }
                    }
                    this.displayLat.setText(CoordinateUtil.latitudeAsPrettyString((double)Math.toDegrees(lat), (boolean)this.showSeconds));
                    this.displayLon.setText(CoordinateUtil.longitudeAsPrettyString((double)Math.toDegrees(lon), (boolean)this.showSeconds));
                    this.displayDepth.setText(this.formatter.format(depth));
                    this.lastUpdate = locMillis;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Subscribe
    public void mainVehicleChangeNotification(ConsoleEventMainSystemChange change) {
        this.estimatedState = null;
    }

    public void cleanSubPanel() {
        this.estimatedState = null;
    }

    public void initSubPanel() {
    }

    public static enum EnZRel {
        HomeRef,
        WGS84,
        ASL;

    }

    public static enum EnZMode {
        Depth,
        Altitude,
        Auto,
        Invisible;

    }

    public static enum EnOrientation {
        Horizontal,
        Vertical;

    }
}

