/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.position;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.console.plugins.BackVehiclePanel;
import pt.lsts.neptus.console.plugins.SideVehiclePanel;
import pt.lsts.neptus.gui.tablelayout.TableLayout;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.replay.LogReplayComponent;
import pt.lsts.neptus.mra.replay.LogReplayPanel;
import pt.lsts.neptus.plugins.PluginDescription;

@PluginDescription(icon="pt/lsts/neptus/plugins/position/position.png")
public class AttitudeReplayPanel
extends JPanel
implements LogReplayPanel {
    private static final long serialVersionUID = -7574942224715046138L;
    private LinkedHashMap<String, SideVehiclePanel> sidePanels = new LinkedHashMap();
    private LinkedHashMap<String, BackVehiclePanel> backPanels = new LinkedHashMap();

    public JComponent getComponent() {
        this.setLayout(new BoxLayout(this, 3));
        this.setPreferredSize(new Dimension(500, 200));
        return this;
    }

    public boolean canBeApplied(IMraLogGroup source, LogReplayComponent.Context context) {
        return source.getLsfIndex().containsMessagesOfType(new String[]{"EstimatedState"});
    }

    public void parse(IMraLogGroup source) {
        EstimatedState pivot = (EstimatedState)source.getLsfIndex().getFirst(EstimatedState.class);
        this.onMessage((IMCMessage)pivot);
    }

    public String[] getObservedMessages() {
        return new String[]{"EstimatedState"};
    }

    @Override
    public String getName() {
        return "Attitude Replay Panel";
    }

    public void onMessage(IMCMessage message) {
        String id = message.getSourceName();
        if (!this.sidePanels.containsKey(id)) {
            SideVehiclePanel sp = new SideVehiclePanel();
            sp.setVehicle(id);
            sp.setSize((int)((double)this.getWidth() * 0.666), this.getHeight() / (1 + this.sidePanels.size()));
            sp.setBorder(BorderFactory.createLineBorder(Color.red));
            this.sidePanels.put(id, sp);
            BackVehiclePanel bp = new BackVehiclePanel();
            bp.setVehicle(id);
            bp.setSize((int)((double)this.getWidth() * 0.333), this.getHeight() / (1 + this.sidePanels.size()));
            bp.setBorder(BorderFactory.createLineBorder(Color.red));
            this.backPanels.put(id, bp);
            JPanel p = new JPanel((LayoutManager)new TableLayout(new double[]{0.666, 0.333}, new double[]{-1.0}));
            p.add((Component)sp, "0,0");
            p.add((Component)bp, "1,0");
            this.add(p);
            this.invalidate();
            this.revalidate();
        }
        this.sidePanels.get(id).setPitch(message.getFloat("theta"));
        this.sidePanels.get(id).setDepth(message.getFloat("depth"));
        this.backPanels.get(id).setRoll(message.getFloat("phi"));
        this.repaint();
    }

    public boolean getVisibleByDefault() {
        return false;
    }

    public void cleanup() {
    }

    public static void main(String[] args) {
    }
}

