/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.position;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import pt.lsts.imc.CcuEvent;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.MapFeature;
import pt.lsts.imc.MapPoint;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.console.plugins.SubPanelChangeEvent;
import pt.lsts.neptus.console.plugins.SubPanelChangeListener;
import pt.lsts.neptus.gui.LocationPanel;
import pt.lsts.neptus.gui.MenuScroller;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.planeditor.IEditorMenuExtension;
import pt.lsts.neptus.planeditor.IMapPopup;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.MarkElement;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.ReflectionUtil;

@PluginDescription(author="Paulo Dias, ZP", name="Contact Marker", version="1.6.0", description="Mark a contact on the map from a system location.", documentation="contact-maker/contact-maker.html")
public class ContactMarker
extends ConsolePanel
implements IEditorMenuExtension,
ConfigurationListener,
SubPanelChangeListener,
MainVehicleChangeListener {
    @NeptusProperty(name="Use Single Mark Addition Mode", userLevel=NeptusProperty.LEVEL.ADVANCED, description="Hability to only add marks by inputing the location or using an active system")
    public boolean useSingleMarkAdditionMode = true;
    private Vector<IMapPopup> renderersPopups = new Vector();

    public ContactMarker(ConsoleLayout console) {
        super(console);
        this.setVisibility(false);
    }

    public void initSubPanel() {
        this.renderersPopups = this.getConsole().getSubPanelsOfInterface(IMapPopup.class);
        for (IMapPopup str2d : this.renderersPopups) {
            str2d.addMenuExtension((IEditorMenuExtension)this);
        }
    }

    private void placeLocationOnMap(LocationType locContact, String markerName, long tstamp) {
        if (this.getConsole().getMission() == null) {
            return;
        }
        String id = markerName + "_" + DateTimeUtil.timeFormaterNoMillis.format(new Date(tstamp));
        boolean validId = false;
        while (!validId) {
            id = JOptionPane.showInputDialog((Component)this.getConsole(), I18n.text((String)"Please enter new mark name"), id);
            if (id == null) {
                return;
            }
            AbstractElement[] elems = MapGroup.getMapGroupInstance((MissionType)this.getConsole().getMission()).getMapObjectsByID(id);
            if (elems.length > 0) {
                GuiUtils.errorMessage((Component)this.getConsole(), (String)I18n.text((String)"Add mark"), (String)I18n.text((String)"The given ID already exists in the map. Please choose a different one"));
                continue;
            }
            validId = true;
        }
        MissionType mission = this.getConsole().getMission();
        LinkedHashMap mapList = mission.getMapsList();
        if (mapList == null) {
            return;
        }
        if (mapList.size() == 0) {
            return;
        }
        MapGroup.resetMissionInstance((MissionType)this.getConsole().getMission());
        MapType mapType = MapGroup.getMapGroupInstance((MissionType)this.getConsole().getMission()).getMaps()[0];
        MarkElement contact = new MarkElement(mapType.getMapGroup(), mapType);
        contact.setId(id);
        contact.setCenterLocation(locContact);
        mapType.addObject((AbstractElement)contact);
        mission.save(false);
        MapPoint point = new MapPoint();
        point.setLat(locContact.getLatitudeRads());
        point.setLon(locContact.getLongitudeRads());
        point.setAlt(locContact.getHeight());
        MapFeature feature = new MapFeature();
        feature.setFeatureType(MapFeature.FEATURE_TYPE.POI);
        feature.setFeature(Arrays.asList(point));
        CcuEvent event = new CcuEvent();
        event.setType(CcuEvent.TYPE.MAP_FEATURE_ADDED);
        event.setId(id);
        event.setArg((IMCMessage)feature);
        ImcMsgManager.getManager().broadcastToCCUs((IMCMessage)event);
    }

    public Collection<JMenuItem> getApplicableItems(final LocationType loc, IMapPopup source) {
        Vector marks;
        Vector<JMenuItem> menus = new Vector<JMenuItem>();
        JMenuItem add = new JMenuItem(I18n.text((String)"Add mark"));
        if (this.useSingleMarkAdditionMode) {
            menus.add(add);
        }
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                loc.convertToAbsoluteLatLonDepth();
                LocationType locToAdd = LocationPanel.showLocationDialog((Component)ContactMarker.this.getConsole(), (String)I18n.text((String)"Mark location"), (LocationType)loc, (MissionType)ContactMarker.this.getConsole().getMission(), (boolean)true);
                if (locToAdd == null) {
                    return;
                }
                long tstamp = System.currentTimeMillis();
                ContactMarker.this.placeLocationOnMap(locToAdd, I18n.textc((String)"POI", (String)"Short for Place of Interest. Keep it short because is a prefix for a map marker."), tstamp);
            }
        });
        JMenu myLocMenu = new JMenu(I18n.text((String)"Add mark"));
        if (!this.useSingleMarkAdditionMode) {
            menus.add(myLocMenu);
        }
        AbstractAction addToMap = new AbstractAction(I18n.text((String)"Add a mark at this location")){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    @Override
                    public void run() {
                        long tstamp = System.currentTimeMillis();
                        ContactMarker.this.placeLocationOnMap(loc, I18n.textc((String)"POI", (String)"Short for Place of Interest. Keep it short because is a prefix for a map marker."), tstamp);
                    }
                }.start();
            }
        };
        myLocMenu.add(new JMenuItem(addToMap));
        AbstractAction addToMapEdt = new AbstractAction(I18n.text((String)"Add a mark at...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                loc.convertToAbsoluteLatLonDepth();
                LocationType locToAdd = LocationPanel.showLocationDialog((Component)ContactMarker.this.getConsole(), (String)I18n.text((String)"Add a mark at..."), (LocationType)loc, (MissionType)ContactMarker.this.getConsole().getMission(), (boolean)true);
                if (locToAdd == null) {
                    return;
                }
                long tstamp = System.currentTimeMillis();
                ContactMarker.this.placeLocationOnMap(locToAdd, I18n.textc((String)"POI", (String)"Short for Place of Interest. Keep it short because is a prefix for a map marker."), tstamp);
            }
        };
        myLocMenu.add(new JMenuItem(addToMapEdt));
        Vector<VehicleType> avVehicles = new Vector<VehicleType>();
        ImcSystem[] veh = ImcSystemsHolder.lookupActiveSystemVehicles();
        for (int i = 0; i < veh.length; ++i) {
            avVehicles.add(VehiclesHolder.getVehicleWithImc((ImcId16)veh[i].getId()));
        }
        if (avVehicles.isEmpty() && this.getConsole().getMainSystem() != null) {
            avVehicles.add(VehiclesHolder.getVehicleById((String)this.getConsole().getMainSystem()));
        }
        for (VehicleType v : avVehicles) {
            final ImcSystem sys = ImcSystemsHolder.lookupSystemByName((String)v.getId());
            final String vid = v.getId();
            if (sys.getLocation() == null) continue;
            AbstractAction actionSys = new AbstractAction(I18n.textf((String)"Add a mark at %system's location", (Object[])new Object[]{v.getId()})){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContactMarker.this.placeLocationOnMap(sys.getLocation(), vid, System.currentTimeMillis());
                }
            };
            JMenuItem menuItem = new JMenuItem(actionSys);
            menuItem.setIcon(ImageUtils.getScaledIcon((String)v.getPresentationImageHref(), (int)20, (int)16));
            myLocMenu.add(menuItem);
        }
        if (this.getConsole() != null && this.getConsole().getMission() != null && (marks = MapGroup.getMapGroupInstance((MissionType)this.getConsole().getMission()).getAllObjectsOfType(MarkElement.class)).size() > 0) {
            AbstractAction rem;
            String markId;
            JMenu remove = new JMenu(I18n.text((String)"Remove mark"));
            menus.add(remove);
            for (AbstractElement elem : marks) {
                final MapType markMap = elem.getParentMap();
                markId = elem.getId();
                rem = new AbstractAction(markId){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        markMap.remove(markId);
                        markMap.getMission().save(false);
                        ContactMarker.this.getConsole().updateMissionListeners();
                    }
                };
                remove.add(rem);
                MenuScroller.setScrollerFor((JMenu)remove, (int)25);
            }
            JMenu copy = new JMenu(I18n.text((String)"Copy mark location"));
            menus.add(copy);
            for (final AbstractElement elem : marks) {
                markId = elem.getId();
                rem = new AbstractAction(markId){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        ClipboardOwner owner = new ClipboardOwner(){

                            @Override
                            public void lostOwnership(Clipboard clipboard, Transferable contents) {
                            }
                        };
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(elem.getCenterLocation().getClipboardText()), owner);
                    }
                };
                copy.add(rem);
                MenuScroller.setScrollerFor((JMenu)copy, (int)25);
            }
        }
        return menus;
    }

    public void propertiesChanged() {
    }

    public void subPanelChanged(SubPanelChangeEvent panelChange) {
        if (panelChange == null) {
            return;
        }
        this.renderersPopups = this.getConsole().getSubPanelsOfInterface(IMapPopup.class);
        if (ReflectionUtil.hasInterface(panelChange.getPanel().getClass(), IMapPopup.class)) {
            IMapPopup str2d;
            IMapPopup sub = (IMapPopup)panelChange.getPanel();
            if (panelChange.getAction() == SubPanelChangeEvent.SubPanelChangeAction.ADDED) {
                this.renderersPopups.add(sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.addMenuExtension((IEditorMenuExtension)this);
                }
            }
            if (panelChange.getAction() == SubPanelChangeEvent.SubPanelChangeAction.REMOVED) {
                this.renderersPopups.remove(sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.removeMenuExtension((IEditorMenuExtension)this);
                }
            }
        }
    }

    public void cleanSubPanel() {
    }
}

