/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.position;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.painter.Painter;
import pt.lsts.neptus.gui.painters.SubPanelTitlePainter;
import pt.lsts.neptus.plugins.position.OrientationIcon;
import pt.lsts.neptus.util.GuiUtils;

public class DisplayPanel
extends JXLabel
implements Painter<JXLabel> {
    public static final int DEFAULT_FONT_SIZE = 16;
    private String title = "";
    private String txt = "";
    private int fontSize = 16;
    private static Font titleFont = new Font("Sans", 3, 14);
    private SubPanelTitlePainter sPPainter = new SubPanelTitlePainter();

    public void setFontColor(Color color) {
        this.setForeground(color);
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public DisplayPanel(String title) {
        this.title = title;
        this.setBackgroundPainter(this);
        this.setForeground(Color.black);
        this.setHorizontalTextPosition(0);
        this.setHorizontalAlignment(0);
        if (title != null && title.length() > 0) {
            this.setVerticalAlignment(3);
        }
        if (this.fontSize != 0) {
            this.setFont(new Font("Arial", 1, this.fontSize));
        }
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setPreferredSize(new Dimension(118, 29));
        this.setMinimumSize(new Dimension(10, 10));
        this.setSize(118, 29);
    }

    public void paint(Graphics2D g, JXLabel c, int width, int height) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.sPPainter.setTitle(this.title);
        this.sPPainter.paint(g, (JComponent)c, width, height);
        if (this.txt != null) {
            if (this.fontSize != 0) {
                g.setFont(new Font("Arial", 1, this.fontSize));
                g.translate(10, this.getHeight() - 10);
            } else {
                Rectangle2D r = g.getFontMetrics(titleFont).getStringBounds(this.txt, g);
                double scale = r.getWidth() / (double)this.getWidth();
                double scale2 = r.getHeight() / (double)this.getHeight();
                if (this.title != null) {
                    scale2 = r.getHeight() / (double)(this.getHeight() - 10);
                }
                scale = Math.min(1.0 / scale, 1.0 / scale2);
                g.translate(5, this.getHeight() - 5);
                g.scale(scale, scale);
            }
            g.setColor(this.getForeground());
            g.drawString(this.txt, 0, 0);
        }
    }

    public void setText(String arg0) {
        this.txt = arg0;
        this.repaint();
    }

    public String getText() {
        return "";
    }

    public void setTitle(String title) {
        this.title = title;
        if (title != null && title.length() > 0) {
            this.setVerticalAlignment(3);
        } else {
            this.setVerticalAlignment(0);
        }
        this.repaint();
    }

    public boolean isActive() {
        return this.sPPainter.isActive();
    }

    public void setActive(boolean active) {
        this.sPPainter.setActive(active);
    }

    public static void main(String[] args) {
        OrientationIcon icon = new OrientationIcon(20, 2);
        JPanel panel = new JPanel(new GridLayout(0, 1));
        DisplayPanel lat = new DisplayPanel("latitude");
        lat.setIcon(icon);
        lat.setFontSize(0);
        lat.setText("41N35'45.234''");
        panel.add((Component)((Object)lat));
        OrientationIcon icon1 = new OrientationIcon(20, 2);
        DisplayPanel lon = new DisplayPanel("longitude");
        lon.setIcon(icon1);
        lon.setText("8W23'11.092''");
        panel.add((Component)((Object)lon));
        DisplayPanel alt = new DisplayPanel("depth");
        alt.setTitle(null);
        alt.setText("203.34 m");
        panel.add((Component)((Object)alt));
        GuiUtils.testFrame((JComponent)panel);
    }
}

