/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.position;

import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import pt.lsts.imc.DeviceState;
import pt.lsts.imc.Distance;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.Popup;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;

@PluginDescription(name="Distances Panel", description="Distances Panel")
@Popup(name="Distances Panel", pos=Popup.POSITION.CENTER, width=800, height=600, accelerator=68)
public class DistancesPanel
extends ConsolePanel
implements IPeriodicUpdates {
    private static final long serialVersionUID = 1L;
    int w = 600;
    int h = 600;
    double max = 50.0;
    int centerX = this.w / 2;
    int centerY = this.h / 2;
    double scale = (double)this.w / this.max;
    ArrayList<Point2D> pointList = new ArrayList();
    JPanel panel = new JPanel(){
        private static final long serialVersionUID = -7057170093044940039L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setBackground(Color.BLACK);
            g2d.clearRect(0, 0, DistancesPanel.this.w, DistancesPanel.this.h);
            g2d.setColor(Color.YELLOW);
            g2d.drawOval(DistancesPanel.this.centerX - 5, DistancesPanel.this.centerY - 5, 10, 10);
            ArrayList<Point2D> arrayList = DistancesPanel.this.pointList;
            synchronized (arrayList) {
                for (Point2D p : DistancesPanel.this.pointList) {
                    g2d.setColor(Color.RED);
                    g2d.drawOval((int)p.getX(), (int)p.getY(), 2, 2);
                }
                DistancesPanel.this.pointList.clear();
            }
        }
    };

    public DistancesPanel(ConsoleLayout console) {
        super(console);
    }

    public void initSubPanel() {
        this.setLayout((LayoutManager)new MigLayout());
        this.add(this.panel, " w 600, h 600");
    }

    public void cleanSubPanel() {
    }

    @Subscribe
    public void onDistance(Distance distance) {
        System.out.println(distance);
        System.out.println(this.scale);
        DeviceState devState = (DeviceState)distance.getLocation().get(0);
        double x = (double)this.centerX + distance.getValue() * Math.cos(devState.getPsi()) * this.scale;
        double y = (double)this.centerY + distance.getValue() * Math.sin(devState.getPsi()) * this.scale;
        System.out.println(x + " " + y);
        this.pointList.add(new Point2D.Double(x, y));
    }

    public long millisBetweenUpdates() {
        return 1000L;
    }

    public boolean update() {
        this.revalidate();
        this.repaint();
        return true;
    }
}

