/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.position;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.position.DisplayPanel;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;

@PluginDescription(name="Euler Angles", icon="pt/lsts/neptus/plugins/position/position.png", description="Displays the vehicle's orientation")
public class EulerAnglesPanel
extends ConsolePanel
implements ConfigurationListener,
IPeriodicUpdates,
NeptusMessageListener {
    private DisplayPanel displayRoll;
    private DisplayPanel displayPitch;
    private DisplayPanel displayYaw;
    private DecimalFormat formatter = new DecimalFormat("0.00");
    private static final char CHAR_PHI = '\u03c6';
    private static final char CHAR_THETA = '\u03b8';
    private static final char CHAR_PSI = '\u03c8';
    private static final char CHAR_DEGREE = '\u00b0';
    private long lastUpdate = 0L;
    boolean connected = true;
    @NeptusProperty(name="Update interval", description="Interval between updates in milliseconds")
    public long millisBetweenUpdates = 100L;
    @NeptusProperty(name="Orientation", description="How to show the displays")
    public EnOrientation orientation = EnOrientation.Vertical;
    @NeptusProperty(name="Font Size", description="The font size. Use '0' for automatic.")
    public int fontSize = 16;

    public EulerAnglesPanel(ConsoleLayout console) {
        super(console);
        this.initialize();
    }

    protected void initialize() {
        this.displayRoll = new DisplayPanel("\u03c6 roll");
        this.displayPitch = new DisplayPanel("\u03b8 pitch");
        this.displayYaw = new DisplayPanel("\u03c8 yaw");
        this.displayRoll.setFontSize(this.fontSize);
        this.displayPitch.setFontSize(this.fontSize);
        this.displayYaw.setFontSize(this.fontSize);
        this.removeAll();
        if (this.orientation == EnOrientation.Horizontal) {
            this.setLayout(new GridLayout(1, 0));
        } else {
            this.setLayout(new GridLayout(0, 1));
        }
        this.add((Component)((Object)this.displayRoll));
        this.add((Component)((Object)this.displayPitch));
        this.add((Component)((Object)this.displayYaw));
    }

    public void propertiesChanged() {
        this.displayRoll.setFontSize(this.fontSize);
        this.displayPitch.setFontSize(this.fontSize);
        this.displayYaw.setFontSize(this.fontSize);
        this.initialize();
        this.invalidate();
        this.revalidate();
    }

    public long millisBetweenUpdates() {
        return 500L;
    }

    public boolean update() {
        if (this.connected && System.currentTimeMillis() - this.lastUpdate > 3000L) {
            this.displayRoll.setFontColor(Color.red.darker());
            this.displayPitch.setFontColor(Color.red.darker());
            this.displayYaw.setFontColor(Color.red.darker());
            this.connected = false;
        }
        if (!this.connected && System.currentTimeMillis() - this.lastUpdate < 3000L) {
            this.displayRoll.setFontColor(Color.black);
            this.displayPitch.setFontColor(Color.black);
            this.displayYaw.setFontColor(Color.black);
            this.connected = true;
        }
        return true;
    }

    public String[] getObservedMessages() {
        return new String[]{"EstimatedState"};
    }

    public void messageArrived(IMCMessage message) {
        this.displayRoll.setText(this.formatter.format(Math.toDegrees(message.getDouble("phi"))) + "\u00b0");
        this.displayPitch.setText(this.formatter.format(Math.toDegrees(message.getDouble("theta"))) + "\u00b0");
        this.displayYaw.setText(this.formatter.format(Math.toDegrees(message.getDouble("psi"))) + "\u00b0");
        this.lastUpdate = System.currentTimeMillis();
    }

    public void initSubPanel() {
    }

    public void cleanSubPanel() {
    }

    public static enum EnOrientation {
        Horizontal,
        Vertical;

    }
}

