/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.position;

import java.awt.Color;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayer;
import pt.lsts.neptus.mystate.MyState;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.position.FindVehicle;
import pt.lsts.neptus.plugins.position.OrientationIcon;
import pt.lsts.neptus.plugins.update.Periodic;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.AngleCalc;
import pt.lsts.neptus.util.ColorUtils;
import pt.lsts.neptus.util.MathMiscUtils;

@PluginDescription(author="Paulo Dias", name="Find Main System", version="1.0", icon="pt/lsts/neptus/plugins/position/findsys.png", description="Points to where to look to find the main system.")
@LayerPriority(priority=182)
public class FindMainSystemLayer
extends ConsoleLayer {
    private static final Color COLOR_WHITE_200 = ColorUtils.setTransparencyToColor((Color)Color.WHITE, (int)200);
    private static final Color COLOR_GREEN_DARK_220 = ColorUtils.setTransparencyToColor((Color)Color.GREEN.darker(), (int)220);
    private static final Color COLOR_GREEN_DARK_100 = ColorUtils.setTransparencyToColor((Color)Color.GREEN.darker(), (int)100);
    private static final Color COLOR_RED_DARK_100 = ColorUtils.setTransparencyToColor((Color)Color.RED.darker(), (int)100);
    private static final Color COLOR_BLACK_200 = ColorUtils.setTransparencyToColor((Color)Color.BLACK, (int)200);
    private static final Color COLOR_BLACK_100 = ColorUtils.setTransparencyToColor((Color)Color.BLACK, (int)100);
    private static final int RECT_WIDTH = 80;
    private static final int RECT_HEIGHT = 80;
    private static final int MARGIN_INT = 5;
    private static final int MARGIN_EXT = 5;
    private static int secondsBeforeMyStatePosOldAge = 30;
    private final OrientationIcon icon = new OrientationIcon(80, 2){
        {
            this.setBackgroundColor(COLOR_RED_DARK_100);
            this.setForegroundColor(COLOR_GREEN_DARK_100);
        }
    };
    private double baseOrientationRadians = 0.0;
    private FindVehicle.BaseOrientations absHeadingRadsToLookOrientation = FindVehicle.BaseOrientations.North;
    private double absDistanceToLook = Double.NaN;
    private double absHeadingRadsToLook = Double.NaN;
    private boolean oldData = true;
    private JLabel toDraw = new JLabel();

    public FindMainSystemLayer() {
        this.toDraw.setForeground(Color.WHITE);
        this.toDraw.setHorizontalTextPosition(0);
        this.toDraw.setHorizontalAlignment(0);
        this.toDraw.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.toDraw.setBounds(0, 0, 80, 80);
    }

    public boolean userControlsOpacity() {
        return false;
    }

    public void initLayer() {
    }

    public void cleanLayer() {
    }

    @Periodic(millisBetweenUpdates=1000)
    public boolean update() {
        LocationType lt = new LocationType();
        this.oldData = false;
        ImcSystem sys = ImcSystemsHolder.lookupSystemByName((String)this.getConsole().getMainSystem());
        if (sys == null || LocationType.ABSOLUTE_ZERO.equals((Object)sys.getLocation())) {
            this.clearData();
        } else {
            try {
                lt.setLocation(sys.getLocation());
                if (System.currentTimeMillis() - sys.getLocationTimeMillis() > (long)(secondsBeforeMyStatePosOldAge * 1000)) {
                    this.oldData |= true;
                }
            }
            catch (Exception e) {
                this.clearData();
                return true;
            }
            LocationType baseLocation = MyState.getLocation();
            if (LocationType.ABSOLUTE_ZERO.equals((Object)baseLocation)) {
                this.clearData();
                return true;
            }
            this.baseOrientationRadians = MyState.getHeadingInRadians();
            if (System.currentTimeMillis() - MyState.getLastLocationUpdateTimeMillis() < (long)(secondsBeforeMyStatePosOldAge * 1000)) {
                this.oldData |= true;
            }
            this.absDistanceToLook = baseLocation.getHorizontalDistanceInMeters(lt);
            double angleRads = baseLocation.getXYAngle(lt);
            this.absHeadingRadsToLook = AngleCalc.nomalizeAngleRads2Pi((double)angleRads);
            this.absHeadingRadsToLookOrientation = FindVehicle.convertToBaseOrientation(this.absHeadingRadsToLook);
            this.icon.setAngleRadians(angleRads - this.baseOrientationRadians);
        }
        return true;
    }

    private void clearData() {
        this.icon.setAngleRadians(Double.NaN);
        this.baseOrientationRadians = Double.NaN;
        this.absDistanceToLook = Double.NaN;
        this.absHeadingRadsToLook = Double.NaN;
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        boolean validData = true;
        if (Double.isNaN(this.absDistanceToLook) || Double.isInfinite(this.absHeadingRadsToLook)) {
            validData = false;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        String txt = "<html><b>";
        txt = !validData ? txt + "?" : txt + this.absHeadingRadsToLookOrientation.getAbbrev() + "<br/>" + Math.round(Math.toDegrees(this.absHeadingRadsToLook)) + "\u00b0" + "<br/>" + MathMiscUtils.parseToEngineeringNotation((double)this.absDistanceToLook, (int)0) + "m";
        this.toDraw.setText(txt);
        g2.setColor(COLOR_BLACK_200);
        g2.drawRoundRect(renderer.getWidth() - 80 - 10, 210, 85, 85, 20, 20);
        g2.setColor(COLOR_BLACK_100);
        g2.fillRoundRect(renderer.getWidth() - 80 - 10, 210, 85, 85, 20, 20);
        g2.translate(renderer.getWidth() - 80 - 10, 210);
        if (this.oldData) {
            this.icon.setForegroundColor(COLOR_GREEN_DARK_100);
            this.icon.setBackgroundColor(COLOR_RED_DARK_100);
        } else {
            this.icon.setForegroundColor(COLOR_GREEN_DARK_220);
            this.icon.setBackgroundColor(COLOR_WHITE_200);
        }
        if (validData) {
            this.icon.paintIcon(null, g2, 0, 0);
        }
        this.toDraw.setForeground(!this.oldData ? COLOR_WHITE_200 : COLOR_BLACK_200);
        this.toDraw.paint(g2);
        this.toDraw.setForeground(this.oldData ? COLOR_WHITE_200 : COLOR_BLACK_200);
        g2.translate(1, 1);
        this.toDraw.paint(g2);
        g2.dispose();
    }
}

