/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.position;

import com.google.common.eventbus.Subscribe;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mystate.MyState;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.position.DisplayPanel;
import pt.lsts.neptus.plugins.position.OrientationIcon;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.AngleCalc;

@PluginDescription(author="Jos\u00e9 Pinto, Paulo Dias", name="FindVehicle", version="1.1", description="Find vehicle base on base position and orientation.", documentation="find-system/find-vehicle.html")
public class FindVehicle
extends ConsolePanel
implements ConfigurationListener,
IPeriodicUpdates,
MainVehicleChangeListener {
    private final DecimalFormat formatter = new DecimalFormat("0.00");
    @NeptusProperty(name="Use My Heading", editable=true, description="Use My Heading for the base location. Don't forget to set it first.")
    public boolean useMyHeading = true;
    @NeptusProperty(name="Base Orientation", description="Where the operator in the basestation is looking at")
    public BaseOrientations baseOrientation = BaseOrientations.North;
    @NeptusProperty(name="Use My Location", editable=true, description="Use My Location for the base location. Don't forget to set it first.")
    public boolean useMyLocation = true;
    private static int secondsBeforeMyStatePosOldAge = 30;
    @NeptusProperty(name="Base Location", editable=true, description="Where is the base located")
    public LocationType baseLocation = new LocationType();
    @NeptusProperty(name="Font Size", description="The font size. Use '0' for automatic.")
    public int fontSize = 16;
    private double baseOrientationRadians = 0.0;
    private final OrientationIcon icon = new OrientationIcon(30, 2);
    private final DisplayPanel display = new DisplayPanel("");

    public FindVehicle(ConsoleLayout console) {
        super(console);
        this.setLayout(new BorderLayout());
        this.display.setTitle(I18n.text((String)"find vehicle"));
        this.display.setIcon(this.icon);
        this.display.setHorizontalAlignment(11);
        this.add((Component)((Object)this.display), "Center");
        this.display.setFontSize(this.fontSize);
    }

    public void initSubPanel() {
        this.addMenuItem(I18n.text((String)"Settings") + ">" + I18n.text((String)"Base Location Settings"), null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesEditor.editProperties((PropertiesProvider)FindVehicle.this, (Frame)FindVehicle.this.getConsole(), (boolean)true);
            }
        });
        this.addMenuItem(I18n.text((String)"Advanced") + ">" + I18n.text((String)"Reset Base Heading"), null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyState.setHeadingInRadians((double)FindVehicle.this.baseOrientationRadians);
            }
        });
    }

    public void propertiesChanged() {
        this.baseOrientationRadians = Math.toRadians(this.baseOrientation.ordinal() * 45);
        if (this.useMyHeading) {
            MyState.setHeadingInRadians((double)this.baseOrientationRadians);
        }
        this.display.setFontSize(this.fontSize);
        this.invalidate();
        this.revalidate();
    }

    public boolean update() {
        LocationType lt = new LocationType();
        boolean oldPos = false;
        ImcSystem sys = ImcSystemsHolder.lookupSystemByName((String)this.getMainVehicleId());
        try {
            lt.setLocation(sys.getLocation());
            if (System.currentTimeMillis() - sys.getLocationTimeMillis() > (long)(secondsBeforeMyStatePosOldAge * 1000)) {
                oldPos = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.icon.setAngleRadians(Double.NaN);
            this.display.setText(I18n.text((String)"pos? "));
            this.display.setToolTipText(I18n.text((String)"unknown vehicle position"));
            this.display.setActive(true);
            return true;
        }
        if (this.useMyLocation) {
            this.baseLocation.setLocation(MyState.getLocation());
            this.display.setTitle(I18n.textf((String)"find vehicle (base: %orientation)", (Object[])new Object[]{this.baseOrientation.getAbbrev()}));
            if (System.currentTimeMillis() - MyState.getLastLocationUpdateTimeMillis() < (long)(secondsBeforeMyStatePosOldAge * 1000)) {
                this.display.setActive(true);
            } else {
                this.display.setActive(false);
            }
        } else {
            this.display.setTitle(I18n.text((String)"find vehicle"));
            this.display.setActive(true);
        }
        if (this.useMyHeading) {
            this.baseOrientationRadians = MyState.getAxisAnglesRadians()[2];
            this.baseOrientation = FindVehicle.convertToBaseOrientation(this.baseOrientationRadians);
        }
        double distance = this.baseLocation.getHorizontalDistanceInMeters(lt);
        double angleRads = this.baseLocation.getXYAngle(lt);
        this.icon.setAngleRadians(angleRads - this.baseOrientationRadians);
        this.display.setText((int)distance + " m ");
        if (oldPos) {
            this.display.setForeground(Color.RED.darker());
        } else {
            this.display.setForeground(Color.BLACK);
        }
        this.display.setToolTipText(this.formatter.format(Math.toDegrees(angleRads)) + "\u00b0");
        return true;
    }

    public static BaseOrientations convertToBaseOrientation(double baseOrientationRadians) {
        double headingDegrees = Math.toDegrees(baseOrientationRadians);
        if ((headingDegrees = AngleCalc.nomalizeAngleDegrees360((double)headingDegrees)) >= -22.5 && headingDegrees <= 22.5) {
            return BaseOrientations.North;
        }
        if (headingDegrees > 22.5 && headingDegrees < 67.5) {
            return BaseOrientations.NorthEast;
        }
        if (headingDegrees >= 67.5 && headingDegrees <= 112.5) {
            return BaseOrientations.East;
        }
        if (headingDegrees > 112.5 && headingDegrees < 157.5) {
            return BaseOrientations.SouthEast;
        }
        if (headingDegrees >= 157.5 && headingDegrees <= 202.5) {
            return BaseOrientations.South;
        }
        if (headingDegrees > 202.5 && headingDegrees < 247.5) {
            return BaseOrientations.SouthWest;
        }
        if (headingDegrees >= 247.5 && headingDegrees <= 292.5) {
            return BaseOrientations.West;
        }
        if (headingDegrees > 292.5 && headingDegrees < 337.5) {
            return BaseOrientations.NorthWest;
        }
        return BaseOrientations.North;
    }

    @Subscribe
    public void mainVehicleChangeNotification(ConsoleEventMainSystemChange evt) {
        this.display.setTitle(evt.getCurrent());
    }

    public long millisBetweenUpdates() {
        return 1000L;
    }

    public void cleanSubPanel() {
    }

    public static enum BaseOrientations {
        North,
        NorthEast,
        East,
        SouthEast,
        South,
        SouthWest,
        West,
        NorthWest;


        public String getAbbrev() {
            return this.name().replaceAll("[a-z]", "");
        }
    }
}

