/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.position;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Vector;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.console.plugins.SubPanelChangeEvent;
import pt.lsts.neptus.console.plugins.SubPanelChangeListener;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.ILayerPainter;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.ScatterPointsElement;
import pt.lsts.neptus.util.ReflectionUtil;

@PluginDescription(author="Rui Gon\u00e7alves", name="GPSFixPanel", icon="pt/lsts/neptus/plugins/position/gpsbutton.png", description="GPS Fix display")
@LayerPriority(priority=40)
public class GPSFixPanel
extends ConsolePanel
implements MainVehicleChangeListener,
Renderer2DPainter,
SubPanelChangeListener,
NeptusMessageListener {
    @NeptusProperty(name="Tail number of Points", description="Number of points for GPS fix history.")
    public int tailPoints = 30;
    @NeptusProperty(name="Show tail of fix GPS Points")
    public boolean showTailPoints = true;
    @NeptusProperty(name="Show GPS Fix Icon")
    public boolean gpsFixIconVisible = true;
    @NeptusProperty(name="Seconds to display ranges")
    public int secondsToDisplayRanges = 10;
    private boolean isExtGpsFix = true;
    private Vector<ILayerPainter> renderers;
    private long lastCalcPosTimeMillis;
    private boolean initCalled;
    private double lat;
    private double lon;
    private double radius;
    private ScatterPointsElement scatter;

    public GPSFixPanel(ConsoleLayout console) {
        super(console);
        IMCMessage dummy = IMCDefinition.getInstance().create("GpsFix", new Object[0]);
        if (dummy != null) {
            this.isExtGpsFix = dummy.getMessageType().getFieldType("validity") != null;
        }
        this.renderers = new Vector();
        this.lastCalcPosTimeMillis = 0L;
        this.initCalled = false;
        this.scatter = null;
        this.setVisibility(false);
    }

    public void initSubPanel() {
        this.renderers = this.getConsole().getSubPanelsOfInterface(ILayerPainter.class);
        for (ILayerPainter str2d : this.renderers) {
            str2d.addPostRenderPainter((Renderer2DPainter)this, ((Object)((Object)this)).getClass().getSimpleName());
        }
        if (this.initCalled) {
            return;
        }
        this.initCalled = true;
        this.addMenuItem("Settings>Vehicle Trail Settings", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesEditor.editProperties((PropertiesProvider)GPSFixPanel.this, (Frame)GPSFixPanel.this.getConsole(), (boolean)true);
            }
        });
    }

    public void subPanelChanged(SubPanelChangeEvent panelChange) {
        if (panelChange == null) {
            return;
        }
        if (ReflectionUtil.hasInterface(panelChange.getPanel().getClass(), ILayerPainter.class)) {
            ILayerPainter str2d;
            ILayerPainter sub = (ILayerPainter)panelChange.getPanel();
            if (panelChange.added()) {
                this.renderers.add(sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.addPostRenderPainter((Renderer2DPainter)this, "GPS FIX");
                }
            }
            if (panelChange.removed()) {
                this.renderers.remove(sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.removePostRenderPainter((Renderer2DPainter)this);
                }
            }
        }
    }

    public void paint(Graphics2D g2, StateRenderer2D renderer) {
        if (this.showTailPoints) {
            if (this.scatter != null) {
                Graphics2D gS = (Graphics2D)g2.create();
                this.scatter.paint(gS, renderer, -renderer.getRotation());
            }
        } else {
            this.scatter.clearPoints();
        }
        if (this.gpsFixIconVisible) {
            double alfaPercentage = 1.0;
            long deltaTimeMillis = System.currentTimeMillis() - this.lastCalcPosTimeMillis;
            if ((double)deltaTimeMillis > (double)this.secondsToDisplayRanges * 1000.0 / 2.0) {
                alfaPercentage = 0.5;
            } else if ((double)deltaTimeMillis > (double)this.secondsToDisplayRanges * 1000.0 / 4.0) {
                alfaPercentage = 0.7;
            }
            LocationType lt = new LocationType();
            lt.setLatitudeDegs(this.lat);
            lt.setLongitudeDegs(this.lon);
            Point2D centerPos = renderer.getScreenPosition(new LocationType(lt));
            double radius = this.radius * (double)renderer.getZoom();
            Graphics2D g = (Graphics2D)g2.create();
            Ellipse2D.Double ellis = new Ellipse2D.Double(centerPos.getX() - radius, centerPos.getY() - radius, radius * 2.0, radius * 2.0);
            g.setColor(new Color(255, 128, 128, (int)(64.0 * alfaPercentage)));
            g.fill(ellis);
            g.setColor(new Color(255, 128, 25, (int)(255.0 * alfaPercentage)));
            g.draw(ellis);
            g.setColor(new Color(0, 0, 0, (int)(255.0 * alfaPercentage)));
            g.draw(new Ellipse2D.Double(centerPos.getX() - 10.0, centerPos.getY() - 10.0, 20.0, 20.0));
            g.setColor(new Color(139, 69, 19, (int)(255.0 * alfaPercentage)));
            g.draw(new Ellipse2D.Double(centerPos.getX() - 12.0, centerPos.getY() - 12.0, 24.0, 24.0));
            g.setColor(new Color(0, 0, 0, (int)(255.0 * alfaPercentage)));
            g.draw(new Ellipse2D.Double(centerPos.getX() - 14.0, centerPos.getY() - 14.0, 28.0, 28.0));
            g.translate(centerPos.getX(), centerPos.getY());
            Color color = new Color(139, 69, 19).darker();
            g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(200.0 * alfaPercentage)));
            g.fill(new Ellipse2D.Double(-7.0, -7.0, 14.0, 14.0));
            color = new Color(139, 69, 19, 0).brighter();
            g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(150.0 * alfaPercentage)));
            g.setStroke(new BasicStroke(2.0f));
            g.draw(new Ellipse2D.Double(-7.0, -7.0, 14.0, 14.0));
            g.setColor(new Color(0, 0, 0, (int)(150.0 * alfaPercentage)));
            g.fill(new Ellipse2D.Double(-2.0, -2.0, 4.0, 4.0));
            g.setColor(Color.BLACK);
            if (this.getConsole() != null && this.getConsole().getMainSystem() != null) {
                g.drawString("GPS " + this.getConsole().getMainSystem(), 10, 10);
            }
            g.translate(-centerPos.getX(), -centerPos.getY());
        }
    }

    public void cleanSubPanel() {
        this.renderers = this.getConsole().getSubPanelsOfInterface(ILayerPainter.class);
        for (ILayerPainter str2d : this.renderers) {
            str2d.removePostRenderPainter((Renderer2DPainter)this);
        }
    }

    public String[] getObservedMessages() {
        return new String[]{"GpsFix"};
    }

    public void messageArrived(IMCMessage message) {
        if (this.isExtGpsFix && !((Boolean)message.getBitmask("validity").get("VALID_POS")).booleanValue()) {
            return;
        }
        this.lat = Math.toDegrees(message.getDouble("lat"));
        this.lon = Math.toDegrees(message.getDouble("lon"));
        this.radius = message.getDouble("hacc");
        this.radius = Double.isNaN(this.radius) ? 0.0 : this.radius;
        this.lastCalcPosTimeMillis = System.currentTimeMillis();
        LocationType lt = new LocationType();
        lt.setLatitudeDegs(this.lat);
        lt.setLongitudeDegs(this.lon);
        if (this.showTailPoints) {
            if (this.scatter == null) {
                this.scatter = new ScatterPointsElement();
                this.scatter.setColor(Color.green.darker(), Color.black);
                this.scatter.setCenterLocation(lt);
                this.scatter.setNumberOfPoints(this.tailPoints);
            }
            if (this.scatter.getPoints().size() >= this.tailPoints && this.scatter.getPoints().size() > 0) {
                this.scatter.getPoints().remove(0);
            }
            this.scatter.addPoint(lt);
        } else if (this.scatter != null) {
            this.scatter.clearPoints();
        }
    }
}

