/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.position;

import com.google.common.eventbus.Subscribe;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.LinkedHashMap;
import javax.swing.Box;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.Painter;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.comm.manager.imc.EntitiesResolver;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.console.plugins.SystemsList;
import pt.lsts.neptus.gui.painters.SubPanelTitlePainter;
import pt.lsts.neptus.messages.Enumerated;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.position.DisplayPanel;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.ConsoleParse;
import pt.lsts.neptus.util.MathMiscUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

@PluginDescription(name="Multi Entity Display Panel", author="Paulo Dias", version="1.0", icon="pt/lsts/neptus/plugins/position/position.png")
public class MultiEntityDisplayPanel
extends ConsolePanel
implements ConfigurationListener,
NeptusMessageListener,
MainVehicleChangeListener,
IPeriodicUpdates {
    @NeptusProperty(name="Title")
    public String titleTxt = "";
    @NeptusProperty(name="Show Title")
    public boolean showTitle = false;
    @NeptusProperty(name="Show Title Inline for Every Entity")
    public boolean showTitleInline = false;
    @NeptusProperty(name="Message Name")
    public String messageName = "";
    @NeptusProperty(name="Message Field Name")
    public String messageFieldName = "";
    @NeptusProperty(name="Decimal Houses (if numeric value)")
    public short decimalHouses = 1;
    @NeptusProperty(name="Unit", description="The unit of the value.")
    public String unitName = "";
    @NeptusProperty(name="Show Unit in the Title")
    public boolean showUnitInTitle = false;
    @NeptusProperty(name="Number of columns", description="The number of columns to be displayed")
    public int numberOfCols = 1;
    @NeptusProperty(name="Update period (ms)", description="Interval between display updates, in milliseconds")
    public long millisBetweenUpdates = 200L;
    @NeptusProperty(name="Font Size", description="The font size. Use '0' for automatic.")
    public int fontSize = 16;
    private boolean noMessagesYet = true;
    private LinkedHashMap<String, DisplayPanel> displays = new LinkedHashMap();
    private LinkedHashMap<String, String> values = new LinkedHashMap();
    private LinkedHashMap<String, Long> lastUpdates = new LinkedHashMap();
    private JXPanel holder;
    private SubPanelTitlePainter backPainter;

    public MultiEntityDisplayPanel(ConsoleLayout console) {
        super(console);
        this.initialize();
    }

    private void initialize() {
        this.removeAll();
        this.displays.clear();
        this.values.clear();
        this.lastUpdates.clear();
        this.backPainter = new SubPanelTitlePainter(this.showTitle || this.noMessagesYet ? this.titleTxt.toLowerCase() + (this.showUnitInTitle ? " (" + this.unitName + ")" : "") : "");
        this.holder = new JXPanel();
        this.holder.setOpaque(false);
        int numCols = Math.max(this.numberOfCols, 1);
        this.holder.setLayout((LayoutManager)new GridLayout(0, numCols));
        JXPanel holderB = new JXPanel();
        holderB.setBackgroundPainter((Painter)this.backPainter);
        holderB.setLayout((LayoutManager)new BorderLayout());
        holderB.add((Component)this.holder);
        if (!"".equalsIgnoreCase(this.titleTxt) && this.showTitle && !this.showTitleInline) {
            holderB.add(Box.createVerticalStrut(this.fontSize), (Object)"North");
        }
        this.setLayout(new BorderLayout());
        this.add((Component)holderB);
    }

    public void propertiesChanged() {
        this.mainVehicleChange(this.getMainVehicleId());
    }

    private void resetView() {
        this.noMessagesYet = true;
        this.initialize();
        this.invalidate();
        this.validate();
    }

    @Subscribe
    public void mainVehicleChangeNotification(ConsoleEventMainSystemChange e) {
        this.resetView();
    }

    public boolean update() {
        for (String key : this.displays.keySet()) {
            try {
                long lastUpTime = this.lastUpdates.get(key);
                String value = this.values.get(key);
                DisplayPanel d = this.displays.get(key);
                if (System.currentTimeMillis() - lastUpTime > 5000L) {
                    d.setFontColor(Color.red.darker());
                } else {
                    d.setFontColor(Color.black);
                }
                d.setText(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public long millisBetweenUpdates() {
        return this.millisBetweenUpdates;
    }

    public String[] getObservedMessages() {
        if ("".equalsIgnoreCase(this.messageName) || "".equalsIgnoreCase(this.messageFieldName)) {
            return new String[0];
        }
        return new String[]{this.messageName};
    }

    public void messageArrived(IMCMessage message) {
        try {
            int srcEnt = message.getHeader().getInteger("src_ent");
            String entityName = EntitiesResolver.resolveName((String)ImcSystemsHolder.lookupSystemByName((String)this.getMainVehicleId()).getId().toString(), (Integer)srcEnt);
            if (entityName == null) {
                return;
            }
            if (!this.displays.containsKey(entityName)) {
                String prefixAdded = "";
                String postfixAdded = "";
                if (this.showTitle && !"".equalsIgnoreCase(this.titleTxt) && this.showTitleInline) {
                    prefixAdded = this.titleTxt + " ";
                    if (this.showUnitInTitle) {
                        postfixAdded = " (" + this.unitName + ")";
                    }
                }
                DisplayPanel dp = new DisplayPanel(prefixAdded + entityName.toLowerCase() + postfixAdded);
                dp.setFontSize(this.fontSize);
                this.displays.put(entityName, dp);
                this.holder.add((Component)((Object)dp));
                this.invalidate();
                this.validate();
            } else {
                DisplayPanel dp = this.displays.get(entityName);
            }
            this.lastUpdates.put(entityName, System.currentTimeMillis());
            Object value = message.getValue(this.messageFieldName);
            String valueStr = value.toString();
            try {
                double dvalue = MathMiscUtils.round((double)((Number)value).doubleValue(), (int)this.decimalHouses);
                valueStr = this.decimalHouses < 1 ? "" + (int)dvalue : "" + dvalue;
                if (value instanceof Enumerated) {
                    valueStr = value.toString();
                }
            }
            catch (Exception e) {
                e.getMessage();
                valueStr = value.toString();
            }
            String unitPostfix = "";
            if (!this.showUnitInTitle) {
                unitPostfix = " " + this.unitName;
            }
            this.values.put(entityName, valueStr + unitPostfix);
            if (this.noMessagesYet) {
                this.noMessagesYet = false;
                if (!this.showTitle || this.showTitle && ("".equalsIgnoreCase(this.titleTxt) || this.showTitleInline)) {
                    this.backPainter.setTitle("");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        VehiclesHolder.loadVehicles();
        MultiEntityDisplayPanel mdp = new MultiEntityDisplayPanel(null);
        mdp.messageName = "EntityState";
        mdp.messageFieldName = "state";
        ConsoleParse.dummyConsole((ConsolePanel[])new ConsolePanel[]{mdp, new SystemsList(null)});
        mdp.propertiesChanged();
    }

    public void initSubPanel() {
    }

    public void cleanSubPanel() {
    }
}

