/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.position;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Icon;
import javax.swing.JComponent;
import pt.lsts.neptus.plugins.position.DisplayPanel;
import pt.lsts.neptus.util.GuiUtils;

public class OrientationIcon
implements Icon {
    private double diam;
    private double margin;
    private double angleRadians = Double.NaN;
    private Color backgroundColor = Color.white;
    private Color foregroundColor = Color.black;
    private GeneralPath arrow = new GeneralPath();

    public OrientationIcon(int diameter, int margin) {
        this.arrow.moveTo(0.0f, -47.0f);
        this.arrow.lineTo(30.0f, 37.0f);
        this.arrow.lineTo(0.0f, 15.0f);
        this.arrow.lineTo(-30.0f, 37.0f);
        this.arrow.closePath();
        this.diam = diameter;
        this.margin = margin;
    }

    @Override
    public int getIconHeight() {
        return (int)(this.diam + this.margin * 2.0);
    }

    @Override
    public int getIconWidth() {
        return this.getIconHeight();
    }

    @Override
    public void paintIcon(Component c, Graphics arg0, int x, int y) {
        Ellipse2D.Double circle = new Ellipse2D.Double(-this.diam / 2.0, -this.diam / 2.0, this.diam, this.diam);
        Graphics2D g = (Graphics2D)arg0;
        AffineTransform t = g.getTransform();
        g.translate(x, y);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.translate(this.margin + this.diam / 2.0, this.margin + this.diam / 2.0);
        g.setColor(this.backgroundColor);
        g.fill(circle);
        g.setColor(this.foregroundColor);
        g.draw(circle);
        if (this.angleRadians != Double.NaN) {
            g.rotate(this.angleRadians);
            g.scale(this.diam / 100.0, this.diam / 100.0);
            g.fill(this.arrow);
        }
        g.setTransform(t);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public void setAngleRadians(double angleRadians) {
        this.angleRadians = angleRadians;
    }

    public void setAngleDegs(double angleRadians) {
        this.angleRadians = Math.toRadians(angleRadians);
    }

    public static void main(String[] args) {
        final OrientationIcon ico = new OrientationIcon(22, 2);
        final DisplayPanel lbl = new DisplayPanel("lauv-seacon-1");
        lbl.setText("845 m ");
        lbl.setIcon(ico);
        lbl.setVerticalAlignment(0);
        lbl.setHorizontalTextPosition(2);
        lbl.setVerticalTextPosition(0);
        GuiUtils.testFrame((JComponent)((Object)lbl));
        TimerTask tt = new TimerTask(){
            int count = 1;

            @Override
            public void run() {
                ico.setAngleDegs(this.count % 360);
                ++this.count;
                lbl.repaint();
            }
        };
        Timer t = new Timer("Orientation Icon");
        t.schedule(tt, 10L, 10L);
    }
}

